/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.bosh.BoshConnectionManager;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSendQueueTask;
import tigase.server.bosh.BoshSessionCache;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.bosh.BoshTask;
import tigase.server.bosh.Constants;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.util.common.TimerTask;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class BoshSession {
    private static final String IQ_ELEMENT_NAME = "iq";
    private static final Logger log = Logger.getLogger(BoshSession.class.getName());
    private static final String MESSAGE_ELEMENT_NAME = "message";
    private static final String PRESENCE_ELEMENT_NAME = "presence";
    private static final long SECOND = 1000L;
    private static final TimerTaskComparator timerTaskComparator = new TimerTaskComparator();
    private long batch_queue_timeout = 100L;
    private BoshSessionCache cache = null;
    private boolean cache_on = false;
    private long cache_reload_counter = 0L;
    private int concurrent_requests = 2;
    private ConcurrentSkipListMap<BoshTask, BoshIOService> connections = new ConcurrentSkipListMap(timerTaskComparator);
    private String content_type = "text/xml; charset=utf-8";
    private long[] currentRids = null;
    private JID dataReceiver = null;
    private String domain = null;
    private BoshSessionTaskHandler handler = null;
    private int[] hashCodes = null;
    private int hold_requests = 1;
    private String hostname = null;
    private BoshTask inactivityTimer = null;
    private long last_send_time;
    private Pattern[] links_regexs = new Pattern[]{Pattern.compile("([^>/\";]|^)(www\\.[^ ]+)", 2), Pattern.compile("([^\">;]|^)(http://[^ ]+)", 2)};
    private int max_batch_size = 15;
    private long max_inactivity = 10L;
    private long max_pause = 10L;
    private long max_wait = 30L;
    private long min_polling = 10L;
    private Queue<BoshIOService> old_connections = new LinkedBlockingQueue<BoshIOService>(4);
    private long previous_received_rid = -1L;
    private BoshSendQueueTask queueTask = null;
    private String[] replace_with = new String[]{"$1&lt;a href=\"http://$2\" target=\"_blank\"&gt;$2&lt;/a&gt;", "$1&lt;a href=\"$2\" target=\"_blank\"&gt;$2&lt;/a&gt;"};
    private int rids_head = 0;
    private int rids_tail = 0;
    private String sessionId = null;
    private UUID sid = null;
    private boolean terminate = false;
    private JID userJid = null;
    private Set<BoshTask> waitTimerSet = new ConcurrentSkipListSet<BoshTask>(timerTaskComparator);
    private Queue<Element> waiting_packets = null;

    public BoshSession(String def_domain, JID dataReceiver, BoshSessionTaskHandler handler, String hostname, int maxWaitingPackets) {
        this.sid = UUID.randomUUID();
        this.domain = def_domain;
        this.dataReceiver = dataReceiver;
        this.handler = handler;
        this.last_send_time = System.currentTimeMillis();
        this.hostname = hostname;
        this.waiting_packets = new LinkedBlockingQueue<Element>(maxWaitingPackets);
    }

    public void close() {
        this.terminate = true;
        this.processPacket(null, null);
        this.closeAllConnections();
    }

    public void disconnected(BoshIOService bios) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disconnected called for: " + bios.getUniqueId());
        }
        if (bios != null && bios.getWaitTimer() != null) {
            this.handler.cancelTask(bios.getWaitTimer());
            this.connections.remove(bios.getWaitTimer());
        }
        if (this.inactivityTimer != null && log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Canceling inactivityTimer: " + bios != null ? bios.getUniqueId() : "n/a"});
        }
        if (this.connections.isEmpty()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Setting inactivityTimer for " + this.max_inactivity + " on: " + bios != null ? bios.getUniqueId() : "n/a"});
            }
            this.inactivityTimer = this.handler.scheduleTask(this, this.max_inactivity * 1000L);
        }
    }

    public void init(Packet packet, BoshIOService service, long max_wait, long min_polling, long max_inactivity, int concurrent_requests, int hold_requests, long max_pause, int max_batch_size, long batch_queue_timeout, Queue<Packet> out_results) {
        this.init(packet, service, max_wait, min_polling, max_inactivity, concurrent_requests, hold_requests, max_pause, max_batch_size, batch_queue_timeout, out_results, false);
    }

    public synchronized void processPacket(Packet packet, Queue<Packet> out_results) {
        if (packet != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("[" + this.connections.size() + "] Processing packet: " + packet.toString());
            }
            if (this.filterInPacket(packet)) {
                if (!this.waiting_packets.offer(packet.getElement()) && log.isLoggable(Level.FINEST)) {
                    log.log(Level.INFO, "waiting_packets queue exceeded, dropping packet: " + packet.toString());
                }
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("[" + this.connections.size() + "] In packet filtered: " + packet.toString());
            }
        }
        if (!(this.connections.isEmpty() || this.waiting_packets.isEmpty() && !this.terminate)) {
            long currentTime = System.currentTimeMillis();
            if (this.terminate || this.waiting_packets.size() >= this.max_batch_size || currentTime - this.last_send_time > this.batch_queue_timeout) {
                Map.Entry<BoshTask, BoshIOService> entry = this.connections.pollFirstEntry();
                BoshIOService serv = entry.getValue();
                this.sendBody(serv, null);
            } else if (this.queueTask == null) {
                this.queueTask = this.handler.scheduleSendQueueTask(this, this.batch_queue_timeout);
            }
        }
    }

    public synchronized void processSocketPacket(Packet packet, BoshIOService service, Queue<Packet> out_results) {
        BoshTask waitTimer;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.connections.size() + "] Processing socket packet: " + packet.toString());
        }
        if ((waitTimer = service.getWaitTimer()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Canceling waitTimer: " + service.getUniqueId()});
            }
            this.handler.cancelTask(waitTimer);
        }
        if (this.inactivityTimer != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Canceling inactivityTimer: " + service.getUniqueId()});
            }
            this.handler.cancelTask(this.inactivityTimer);
        }
        if (packet.getElemName() == "body" && packet.getXMLNS() == "http://jabber.org/protocol/httpbind") {
            List<Element> children = packet.getElemChildrenStaticStr(Constants.BODY_EL_PATH);
            boolean duplicate = false;
            if (packet.getAttributeStaticStr("rid") != null) {
                try {
                    long rid = Long.parseLong(packet.getAttributeStaticStr("rid"));
                    if (this.isDuplicateRid(rid, children)) {
                        log.info("Discovered duplicate client connection, trying to close the old one with RID: " + rid);
                        Element body = this.getBodyElem();
                        body.setAttribute("type", StanzaType.terminate.toString());
                        this.sendBody(service, body);
                        return;
                    }
                    service.setRid(rid);
                    duplicate = this.isDuplicateMessage(rid, children);
                    if (!duplicate) {
                        this.processRid(rid, children);
                    }
                }
                catch (NumberFormatException e) {
                    log.warning("Incorrect RID value: " + packet.getAttributeStaticStr("rid"));
                }
            }
            service.setContentType(this.content_type);
            service.setSid(this.sid);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting waitTimer for " + this.max_wait + ": " + this.getSid());
            }
            waitTimer = this.handler.scheduleTask(this, this.max_wait * 1000L);
            service.setWaitTimer(waitTimer);
            this.connections.put(waitTimer, service);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Scheduling waitTimer: " + service.getUniqueId()});
            }
            if (!duplicate) {
                if (packet.getType() != null && packet.getType() == StanzaType.terminate) {
                    this.max_inactivity = 2L;
                    this.terminate = true;
                    Packet command2 = Command.STREAM_CLOSED.getPacket(this.handler.getJidForBoshSession(this), this.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                    if (this.userJid != null) {
                        Command.addFieldValue(command2, "user-jid", this.userJid.toString());
                    }
                    this.handler.addOutStreamClosed(command2, this, true);
                }
                if (packet.getAttributeStaticStr("xmpp:restart") != null && packet.getAttributeStaticStr("xmpp:restart").equals("true")) {
                    log.fine("Found stream restart instruction: " + packet.toString());
                    out_results.offer(Command.GETFEATURES.getPacket(null, null, StanzaType.get, "restart1", null));
                }
                if (packet.getAttributeStaticStr("cache") != null) {
                    try {
                        Constants.CacheAction action = Constants.CacheAction.valueOf(packet.getAttributeStaticStr("cache"));
                        if (this.cache_on || action == Constants.CacheAction.on) {
                            this.processCache(action, packet);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.warning("Incorrect cache action: " + packet.getAttributeStaticStr("cache"));
                    }
                } else if (children != null) {
                    for (Element el : children) {
                        try {
                            Packet result;
                            if (el.getXMLNS().equals("http://jabber.org/protocol/httpbind")) {
                                el.setXMLNS("jabber:client");
                            }
                            if (this.filterOutPacket(result = Packet.packetInstance(el))) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Sending out packet: " + result.toString());
                                }
                                out_results.offer(result);
                                continue;
                            }
                            if (!log.isLoggable(Level.FINEST)) continue;
                            log.finest("Out packet filtered: " + result.toString());
                        }
                        catch (TigaseStringprepException ex) {
                            log.warning("Packet addressing problem, stringprep processing failed, dropping: " + el);
                        }
                    }
                }
                if (this.terminate) {
                    Packet command3 = Command.STREAM_CLOSED.getPacket(this.handler.getJidForBoshSession(this), this.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                    if (this.userJid != null) {
                        Command.addFieldValue(command3, "user-jid", this.userJid.toString());
                    }
                    this.handler.addOutStreamClosed(command3, this, true);
                }
            } else {
                log.info("Duplicated packet: " + packet.toString());
            }
        } else {
            log.warning("[" + this.connections.size() + "] Unexpected packet from the network: " + packet.toString());
            Object er_msg = "Invalid body element";
            if (packet.getElemName() != "body") {
                er_msg = (String)er_msg + ", incorrect root element name, use body";
            }
            if (packet.getXMLNS() != "http://jabber.org/protocol/httpbind") {
                er_msg = (String)er_msg + ", incorrect xmlns, use http://jabber.org/protocol/httpbind";
            }
            try {
                Packet error = Authorization.BAD_REQUEST.getResponseMessage(packet, (String)er_msg, true);
                if (!this.waiting_packets.offer(error.getElement()) && log.isLoggable(Level.FINEST)) {
                    log.log(Level.INFO, "waiting_packets queue exceeded, dropping packet: " + error.toString());
                }
                this.terminate = true;
                Packet command4 = Command.STREAM_CLOSED.getPacket(this.handler.getJidForBoshSession(this), this.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                if (this.userJid != null) {
                    Command.addFieldValue(command4, "user-jid", this.userJid.toString());
                }
                this.handler.addOutStreamClosed(command4, this, true);
                command4 = Command.STREAM_FINISHED.getPacket(this.handler.getJidForBoshSession(this), this.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                if (this.userJid != null) {
                    Command.addFieldValue(command4, "user-jid", this.userJid.toString());
                }
                this.handler.addOutStreamClosed(command4, this, false);
            }
            catch (PacketErrorTypeException e) {
                log.info("Error type and incorrect from bosh client? Ignoring...");
            }
        }
        this.processPacket(null, out_results);
        if (this.connections.size() > this.hold_requests) {
            BoshIOService serv = this.connections.pollFirstEntry().getValue();
            this.sendBody(serv, null);
        }
    }

    public synchronized void sendWaitingPackets() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("trying to send waiting packets from queue of " + this.getSid() + " after timer = " + this.waiting_packets.size());
        }
        if (!this.waiting_packets.isEmpty()) {
            Map.Entry<BoshTask, BoshIOService> entry = this.connections.pollFirstEntry();
            if (entry == null) {
                return;
            }
            BoshIOService serv = entry.getValue();
            this.sendBody(serv, null);
        }
    }

    public boolean task(Queue<Packet> out_results, TimerTask tt) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "task called for {0}, inactivityTimer = {1}, tt = {2}", new Object[]{this.getSid(), this.inactivityTimer, tt});
        }
        if (tt == this.inactivityTimer) {
            if (this.connections.size() > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    Object conns = "";
                    for (BoshIOService serv : this.connections.values()) {
                        if (!((String)conns).isEmpty()) {
                            conns = (String)conns + ", ";
                        }
                        conns = (String)conns + "[" + serv.toString() + "]";
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "ignoring inactivityTimer"});
                    }
                }
                return false;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "inactivityTimer fired"});
            }
            for (BoshTask waitTimer : this.waitTimerSet) {
                if (waitTimer == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Canceling waitTimer"});
                }
                this.handler.cancelTask(waitTimer);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.REMOVE, this.getSid(), "Closing session, inactivity timeout expired"});
            }
            Packet command2 = Command.STREAM_CLOSED.getPacket(this.handler.getJidForBoshSession(this), this.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
            if (this.userJid != null) {
                Command.addFieldValue(command2, "user-jid", this.userJid.toString());
            }
            this.handler.addOutStreamClosed(command2, this, true);
            for (Element packet : this.waiting_packets) {
                try {
                    if (packet.getName() == "stream:features") continue;
                    Packet p = Packet.packetInstance(packet);
                    p.setPacketTo(this.handler.getJidForBoshSession(this));
                    p.setPacketFrom(this.getDataReceiver());
                    this.handler.processUndeliveredPacket(p, null, "Bosh = disconnected");
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Packet addressing problem, stringprep processing failed, dropping: " + packet);
                }
            }
            command2 = Command.STREAM_FINISHED.getPacket(this.handler.getJidForBoshSession(this), this.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
            if (this.userJid != null) {
                Command.addFieldValue(command2, "user-jid", this.userJid.toString());
            }
            this.handler.addOutStreamClosed(command2, this, false);
            this.closeAllConnections();
            return true;
        }
        BoshIOService serv = this.connections.remove(tt);
        if (serv != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("waitTimer fired: " + this.getSid());
            }
            this.sendBody(serv, null);
        }
        return false;
    }

    public void terminateBoshSession() {
        this.terminate = true;
    }

    public JID getDataReceiver() {
        return this.dataReceiver;
    }

    public void setDataReceiver(JID dataReceiver) {
        this.dataReceiver = dataReceiver;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UUID getSid() {
        return this.sid;
    }

    public void setUserJid(String jid) {
        this.userJid = JID.jidInstanceNS((String)jid);
    }

    protected void init(Packet packet, BoshIOService service, long max_wait, long min_polling, long max_inactivity, int concurrent_requests, int hold_requests, long max_pause, int max_batch_size, long batch_queue_timeout, Queue<Packet> out_results, boolean preBindEnabled) {
        String lang;
        String cache_action = packet.getAttributeStaticStr("cache");
        if (cache_action != null && cache_action.equals(Constants.CacheAction.on.toString())) {
            this.cache = new BoshSessionCache();
            this.cache_on = true;
            log.fine("BoshSessionCache set to ON");
        }
        this.hashCodes = new int[(this.concurrent_requests + 1) * 5];
        this.currentRids = new long[(this.concurrent_requests + 1) * 5];
        for (int i = 0; i < this.currentRids.length; ++i) {
            this.currentRids[i] = -1L;
            this.hashCodes[i] = -1;
        }
        long wait_l = max_wait;
        String wait_s = packet.getAttributeStaticStr("wait");
        if (wait_s != null) {
            try {
                wait_l = Long.parseLong(wait_s);
            }
            catch (NumberFormatException e) {
                wait_l = max_wait;
            }
        }
        this.max_wait = Math.min(wait_l, max_wait);
        int hold_i = hold_requests;
        String tmp_str = packet.getAttributeStaticStr("hold");
        if (tmp_str != null) {
            try {
                hold_i = Integer.parseInt(tmp_str);
            }
            catch (NumberFormatException e) {
                hold_i = hold_requests;
            }
        }
        if ((tmp_str = packet.getAttributeStaticStr("rid")) != null) {
            try {
                this.previous_received_rid = Long.parseLong(tmp_str);
                this.currentRids[this.rids_head++] = this.previous_received_rid;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.hold_requests = Math.max(hold_i, hold_requests);
        if (packet.getAttributeStaticStr("to") != null) {
            this.domain = packet.getAttributeStaticStr("to");
        }
        this.max_batch_size = max_batch_size;
        this.batch_queue_timeout = batch_queue_timeout;
        this.min_polling = min_polling;
        this.max_inactivity = max_inactivity;
        this.concurrent_requests = concurrent_requests;
        this.max_pause = max_pause;
        if (packet.getAttributeStaticStr("content") != null) {
            this.content_type = packet.getAttributeStaticStr("content");
        }
        if ((lang = packet.getAttributeStaticStr("xml:lang")) == null) {
            lang = "en";
        }
        Element body = new Element("body", new String[]{"wait", "inactivity", "polling", "requests", "hold", "maxpause", "sid", "ver", "from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{Long.toString(this.max_wait), Long.toString(this.max_inactivity), Long.toString(this.min_polling), Integer.toString(this.concurrent_requests), Integer.valueOf(this.hold_requests).toString(), Long.valueOf(this.max_pause).toString(), this.sid.toString(), "1.6", this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
        if (this.hostname != null) {
            body.addAttribute("host", this.hostname);
        }
        this.sessionId = UUID.randomUUID().toString();
        body.setAttribute("authid", this.sessionId);
        if (this.getCurrentRidTail() > 0L) {
            body.setAttribute("ack", "" + this.takeCurrentRidTail());
        }
        JID userId = null;
        try {
            BareJID hostJid;
            JID jID = userId = packet.getAttributeStaticStr("from") != null ? JID.jidInstance((String)packet.getAttributeStaticStr("from")) : null;
            if (userId != null && (hostJid = this.handler.getSeeOtherHostForJID(packet, userId.getBareJID(), SeeOtherHostIfc.Phase.OPEN)) != null) {
                Element error = new Element("stream:error");
                Element seeOtherHost = this.handler.getSeeOtherHostError(packet, hostJid);
                seeOtherHost.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                error.addChild((XMLNodeIfc)seeOtherHost);
                body.addChild((XMLNodeIfc)error);
            }
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(BoshSession.class.getName()).log(Level.SEVERE, null, ex);
        }
        body.setXMLNS("http://jabber.org/protocol/httpbind");
        Packet streamOpen = Command.STREAM_OPENED.getPacket(this.handler.getJidForBoshSession(this), null, StanzaType.set, UUID.randomUUID().toString(), Command.DataType.submit);
        Command.addFieldValue(streamOpen, "session-id", this.sessionId);
        Command.addFieldValue(streamOpen, "hostname", this.domain);
        Command.addFieldValue(streamOpen, "xml:lang", lang);
        if (null != service) {
            service.setContentType(this.content_type);
            this.sendBody(service, body);
        }
        if (preBindEnabled) {
            String ridString;
            this.inactivityTimer = this.handler.scheduleTask(this, max_inactivity * 1000L);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} : {1} ({2})", new Object[]{BoshConnectionManager.BOSH_OPERATION_TYPE.TIMER, this.getSid(), "Setting inactivityTimer for " + max_inactivity + " on " + service});
            }
            if (null != userId) {
                Command.addFieldValue(streamOpen, "jid", userId.toString());
            }
            if (null != (ridString = packet.getAttributeStaticStr("rid"))) {
                long rid = Long.valueOf(ridString);
                this.processRid(rid, null);
            }
            Command.addFieldValue(streamOpen, "prebind", String.valueOf(preBindEnabled));
        }
        this.handler.addOutStreamOpen(streamOpen, this);
    }

    private Element applyFilters(Element packet) {
        String body;
        Element result = packet.clone();
        if (result.getName() == MESSAGE_ELEMENT_NAME && (body = result.getCDataStaticStr(Message.MESSAGE_BODY_PATH)) != null) {
            boolean count = false;
            result.getChild("body").setCData(body);
        }
        return result;
    }

    private void closeAllConnections() {
        for (BoshIOService conn : this.old_connections) {
            conn.stop();
        }
        for (BoshIOService conn : this.connections.values()) {
            conn.stop();
        }
    }

    private boolean filterInPacket(Packet packet) {
        if (this.cache_on) {
            this.processAutomaticCache(packet);
        }
        return true;
    }

    private boolean filterOutPacket(Packet packet) {
        if (this.cache_on && packet.getElemName() == MESSAGE_ELEMENT_NAME) {
            this.cache.addToMessage(packet.getElement());
        }
        return true;
    }

    private void processAutomaticCache(Packet packet) {
        if (packet.getElemName() == PRESENCE_ELEMENT_NAME) {
            this.cache.addPresence(packet.getElement());
        }
        if (packet.getElemName() == MESSAGE_ELEMENT_NAME) {
            this.cache.addFromMessage(packet.getElement());
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_QUERY_PATH, "jabber:iq:roster")) {
            this.cache.addRoster(packet.getElement());
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_BIND_PATH, "urn:ietf:params:xml:ns:xmpp-bind")) {
            this.cache.set("bosh-resource-bind", Collections.singletonList(packet.getElement()));
        }
    }

    private void processCache(Constants.CacheAction action, Packet packet) {
        ++this.cache_reload_counter;
        int packet_counter = 0;
        List<Element> children = packet.getElemChildrenStaticStr(Constants.BODY_EL_PATH);
        String cache_id = packet.getAttributeStaticStr("cache-id");
        List<Element> cache_res = null;
        switch (action) {
            case on: {
                if (this.cache == null) {
                    this.cache = new BoshSessionCache();
                }
                this.cache_on = true;
                log.fine("BoshSessionCache set to ON");
                break;
            }
            case off: {
                this.cache_on = false;
                log.fine("BoshSessionCache set to OFF");
                break;
            }
            case set: {
                this.cache.set(cache_id, children);
                break;
            }
            case add: {
                this.cache.add(cache_id, children);
                break;
            }
            case get: {
                cache_res = this.cache.get(cache_id);
                break;
            }
            case remove: {
                this.cache.remove(cache_id);
                break;
            }
            case get_all: {
                cache_res = this.cache.getAll();
                this.retireAllOldConnections();
                break;
            }
            default: {
                log.warning("Unknown cache action: " + action.toString());
            }
        }
        if (cache_res != null) {
            for (Element elem : cache_res) {
                elem.addAttribute("reload-counter", "" + this.cache_reload_counter);
                elem.addAttribute("packet-counter", "" + ++packet_counter);
                if (this.waiting_packets.offer(elem) || !log.isLoggable(Level.FINEST)) continue;
                log.log(Level.INFO, "waiting_packets queue exceeded, dropping packet: " + elem.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRid(long rid, List<Element> packets) {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            if (this.previous_received_rid + 1L != rid) {
                log.log(Level.FINER, "Incorrect packet order, last_rid={0}, current_rid={1}", new Object[]{this.previous_received_rid, rid});
            }
            if (packets != null && !packets.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Element elem : packets) {
                    sb.append(elem.toString());
                }
                this.hashCodes[this.rids_head] = sb.toString().hashCode();
            } else {
                this.hashCodes[this.rids_head] = -1;
            }
            this.previous_received_rid = rid;
            this.currentRids[this.rids_head++] = rid;
            if (this.rids_head >= this.currentRids.length) {
                this.rids_head = 0;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private void retireAllOldConnections() {
        while (this.connections.size() > 1) {
            Map.Entry<BoshTask, BoshIOService> entry = this.connections.pollFirstEntry();
            this.handler.cancelTask(entry.getKey());
            BoshIOService serv = entry.getValue();
            if (serv != null) {
                this.retireConnectionService(serv);
                continue;
            }
            if (!log.isLoggable(Level.WARNING)) continue;
            log.warning("connections queue size is greater than 1 but poll returns null" + this.getSid());
        }
    }

    private void retireConnectionService(BoshIOService serv) {
        if (!this.old_connections.contains(serv)) {
            while (!this.old_connections.offer(serv)) {
                BoshIOService old_serv = this.old_connections.poll();
                if (old_serv != null) {
                    old_serv.stop();
                    continue;
                }
                if (!log.isLoggable(Level.WARNING)) break;
                log.warning("old_connections queue is empty but can not add new element!: " + this.getSid());
                break;
            }
        }
        serv.setSid(null);
        this.disconnected(serv);
    }

    private synchronized void sendBody(BoshIOService serv, Element body_par) {
        if (this.queueTask != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling queue timer: " + this.getSid());
            }
            this.handler.cancelSendQueueTask(this.queueTask);
            this.queueTask = null;
        }
        this.last_send_time = System.currentTimeMillis();
        BoshTask timer = serv.getWaitTimer();
        if (timer != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Canceling waitTimer: " + this.getSid());
            }
            this.handler.cancelTask(timer);
        } else {
            log.fine("No waitTimer for the Bosh connection! " + serv);
        }
        Element body = body_par;
        if (body == null) {
            body = this.getBodyElem();
            long rid = this.takeCurrentRidTail();
            if (rid > 0L) {
                body.setAttribute("ack", "" + rid);
            }
            if (!this.waiting_packets.isEmpty()) {
                Element stanza = this.waiting_packets.poll();
                if (stanza.getXMLNS() == null) {
                    stanza.setXMLNS("jabber:client");
                }
                body.addChild((XMLNodeIfc)stanza);
                while (!this.waiting_packets.isEmpty() && body.getChildren().size() < this.max_batch_size) {
                    stanza = this.waiting_packets.poll();
                    if (stanza.getXMLNS() == null) {
                        stanza.setXMLNS("jabber:client");
                    }
                    body.addChild((XMLNodeIfc)stanza);
                }
            }
        }
        if (body.getChild("stream:error") != null) {
            body.addAttribute("condition", "remote-stream-error");
            body.addAttribute("type", "terminate");
            body.addAttribute("xmlns:stream", "http://etherx.jabber.org/streams");
            this.terminate = true;
        }
        try {
            if (this.terminate) {
                body.setAttribute("type", StanzaType.terminate.toString());
            }
            this.handler.writeRawData(serv, body.toString());
            this.retireConnectionService(serv);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "[" + this.connections.size() + "] Exception during writing to socket", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long takeCurrentRidTail() {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            int idx = this.rids_tail++;
            if (this.rids_tail >= this.currentRids.length) {
                this.rids_tail = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentRids[idx];
        }
    }

    private Element getBodyElem() {
        Element body = new Element("body", new String[]{"from", "secure", "xmpp:version", "xmlns:xmpp", "xmlns:stream"}, new String[]{this.domain, "true", "1.0", "urn:xmpp:xbosh", "http://etherx.jabber.org/streams"});
        if (this.hostname != null) {
            body.addAttribute("host", this.hostname);
        }
        body.setXMLNS("http://jabber.org/protocol/httpbind");
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentRidTail() {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentRids[this.rids_tail];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicateMessage(long rid, List<Element> packets) {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            int hashCode = -1;
            if (packets != null && !packets.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Element elem : packets) {
                    sb.append(elem.toString());
                }
                hashCode = sb.toString().hashCode();
            }
            if (hashCode == -1) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return false;
            }
            for (int i = 0; i < this.currentRids.length; ++i) {
                if (rid != this.currentRids[i]) continue;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return hashCode == this.hashCodes[i];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicateRid(long rid, List<Element> packets) {
        long[] lArray = this.currentRids;
        synchronized (this.currentRids) {
            int hashCode = -1;
            if (packets != null && !packets.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Element elem : packets) {
                    sb.append(elem.toString());
                }
                hashCode = sb.toString().hashCode();
            }
            for (int i = 0; i < this.currentRids.length; ++i) {
                if (rid != this.currentRids[i]) continue;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return hashCode != this.hashCodes[i];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    private static class TimerTaskComparator
    implements Comparator<BoshTask> {
        private TimerTaskComparator() {
        }

        @Override
        public int compare(BoshTask o1, BoshTask o2) {
            if (o1.timerOrder > o2.timerOrder) {
                return 1;
            }
            if (o1.timerOrder < o2.timerOrder) {
                return -1;
            }
            return 0;
        }
    }
}

