/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.AccessModel;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PublisherModel;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IItems;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;

@Bean(name="channelCreateModule", parent=IMixComponent.class, active=true)
public class ChannelCreateModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_CREATE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"create", (String)"urn:xmpp:mix:core:1"));
    private static final String[] CREATE_PATH = new String[]{"iq", "create"};
    private static final TimestampHelper timestampHelper = new TimestampHelper();
    @Inject
    private MixLogic mixLogic;

    public Criteria getModuleCriteria() {
        return CRIT_CREATE;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        boolean isAdHoc;
        if (packet.getStanzaTo().getLocalpart() != null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        String channel = packet.getAttributeStaticStr(CREATE_PATH, "channel");
        boolean bl = isAdHoc = channel == null;
        if (channel == null) {
            channel = UUID.randomUUID().toString();
        }
        BareJID channelJID = BareJID.bareJIDInstanceNS((String)channel, (String)packet.getStanzaTo().getDomain());
        BareJID owner = packet.getStanzaFrom().getBareJID();
        try {
            this.mixLogic.checkPermission(isAdHoc ? BareJID.bareJIDInstance(null, (String)channelJID.getDomain()) : channelJID, owner, MixAction.manage);
            if (this.getRepository().getNodeConfig(channelJID, "urn:xmpp:mix:nodes:config") != null) {
                throw new PubSubException(Authorization.CONFLICT);
            }
            this.getRepository().createService(channelJID, !isAdHoc);
            ChannelConfiguration channelConfig = new ChannelConfiguration();
            channelConfig.setLastChangeMadeBy(owner);
            channelConfig.setOwners(Collections.singleton(owner));
            LeafNodeConfig config = new LeafNodeConfig("urn:xmpp:mix:nodes:config");
            config.setValue("pubsub#max_items", (Object)"1");
            config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
            config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
            config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
            this.getRepository().createNode(channelJID, "urn:xmpp:mix:nodes:config", owner, (AbstractNodeConfig)config, NodeType.leaf, null);
            this.getRepository().addToRootCollection(channelJID, "urn:xmpp:mix:nodes:config");
            config = new LeafNodeConfig("urn:xmpp:mix:nodes:participants");
            config.setValue("pubsub#max_items", null);
            config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
            config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
            config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
            config.setValue("pubsub#notification_type", (Object)StanzaType.normal.name());
            this.getRepository().createNode(channelJID, "urn:xmpp:mix:nodes:participants", owner, (AbstractNodeConfig)config, NodeType.leaf, null);
            this.getRepository().addToRootCollection(channelJID, "urn:xmpp:mix:nodes:participants");
            config = new LeafNodeConfig("urn:xmpp:mix:nodes:messages");
            config.setValue("pubsub#max_items", null);
            config.setValue("pubsub#pubsub#persist_items", false);
            config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
            config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
            config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
            config.setValue("pubsub#notification_type", (Object)StanzaType.normal.name());
            this.getRepository().createNode(channelJID, "urn:xmpp:mix:nodes:messages", owner, (AbstractNodeConfig)config, NodeType.leaf, null);
            this.getRepository().addToRootCollection(channelJID, "urn:xmpp:mix:nodes:messages");
            config = new LeafNodeConfig("urn:xmpp:mix:nodes:info");
            config.setValue("pubsub#max_items", (Object)"1");
            config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
            config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
            config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
            config.setValue("pubsub#notification_type", (Object)StanzaType.normal.name());
            this.getRepository().createNode(channelJID, "urn:xmpp:mix:nodes:info", owner, (AbstractNodeConfig)config, NodeType.leaf, null);
            this.getRepository().addToRootCollection(channelJID, "urn:xmpp:mix:nodes:info");
            config = new LeafNodeConfig("urn:xmpp:avatar:data");
            config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
            config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
            config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
            config.setValue("pubsub#notification_type", (Object)StanzaType.headline.name());
            this.getRepository().createNode(channelJID, "urn:xmpp:avatar:data", owner, (AbstractNodeConfig)config, NodeType.leaf, null);
            this.getRepository().addToRootCollection(channelJID, "urn:xmpp:avatar:data");
            config = new LeafNodeConfig("urn:xmpp:avatar:metadata");
            config.setValue("pubsub#max_items", (Object)"1");
            config.setValue("pubsub#access_model", (Object)AccessModel.whitelist.name());
            config.setValue("pubsub#publish_model", (Object)PublisherModel.publishers.name());
            config.setValue("pubsub#send_last_published_item", (Object)SendLastPublishedItem.never.name());
            config.setValue("pubsub#notification_type", (Object)StanzaType.normal.name());
            this.getRepository().createNode(channelJID, "urn:xmpp:avatar:metadata", owner, (AbstractNodeConfig)config, NodeType.leaf, null);
            this.getRepository().addToRootCollection(channelJID, "urn:xmpp:avatar:metadata");
            channelConfig.setNodesPresent(new String[]{"participants", "information", "avatar"});
            IItems nodeItems = this.getRepository().getNodeItems(channelJID, "urn:xmpp:mix:nodes:config");
            String configItemId = timestampHelper.format(new Date());
            nodeItems.writeItem(configItemId, owner.toString(), channelConfig.toElement(configItemId), null);
            Element item = new Element("item", new String[]{"id"}, new String[]{configItemId});
            new DataForm.Builder(item, Command.DataType.result).withFields(builder -> {
                builder.addField(DataForm.FieldType.Hidden, "FORM_TYPE").setValue("urn:xmpp:mix:core:1").build();
                builder.addField(DataForm.FieldType.TextSingle, "Name").setLabel("Channel Name").setValue("").build();
                builder.addField(DataForm.FieldType.TextSingle, "Description").setLabel("Channel Description").setValue("").build();
                builder.addField(DataForm.FieldType.JidMulti, "Contact").setLabel("Channel Administrative Contact").build();
            }).build();
            nodeItems = this.getRepository().getNodeItems(channelJID, "urn:xmpp:mix:nodes:info");
            nodeItems.writeItem(configItemId, owner.toString(), item, null);
            Packet response = packet.okResult(new Element("create", new String[]{"xmlns", "channel"}, new String[]{"urn:xmpp:mix:core:1", channel}), 0);
            response.getElemChild("create", "urn:xmpp:mix:core:1").setAttribute("channel", channel);
            this.packetWriter.write(response);
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, null, (Exception)((Object)ex));
        }
    }
}

