/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import groovy.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigFieldType;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.IEncryptedNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPlainNotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.fcm.FcmConnection;
import tigase.push.fcm.FcmProvider;
import tigase.push.modules.AffiliationChangedModule;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.Counter;
import tigase.stats.StatisticsList;

@Bean(name="fcm-xmpp-api", parent=PushNotificationsComponent.class, active=false)
public class FcmXmppApiProvider
implements UnregisterAware,
ConfigurationChangedAware,
IPushProvider,
FcmProvider,
ComponentStatisticsProvider {
    private static final Logger a = Logger.getLogger(FcmXmppApiProvider.class.getCanonicalName());
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    private List<FcmConnection> b = new ArrayList<FcmConnection>();
    @ConfigField(desc="Provider description")
    private String description = "Push provider for FCM - XMPP";
    @ConfigField(desc="Provider name")
    private String name = "fcm-xmpp-api";
    private BlockingDeque<FcmConnection> c = new LinkedBlockingDeque<FcmConnection>();
    @ConfigField(desc="Connections pool size", alias="pool-size")
    private int poolSize = 2;
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Sender ID", alias="sender-id")
    private String senderId;
    @ConfigField(desc="Server key", alias="server-key", type=ConfigFieldType.Password)
    private String serverKey;
    private final Counter d = new Counter("Number of push notifications sent", Level.FINE);
    private final Counter e = new Counter("Number of failed push notifications", Level.FINE);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CompletableFuture<String> pushNotification(IPushSettings.IDevice device, INotification notification) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        Map<String, Object> map = this.preparePayload(notification);
        map.put("to", device.getDeviceId());
        String string = new JsonBuilder(map).toString();
        this.d.inc();
        for (int i = 0; i <= 3 && !completableFuture.isDone(); ++i) {
            try {
                if (!this.a(string)) continue;
                this.d.inc();
                completableFuture.complete((String)map.get("message_id"));
                continue;
            }
            catch (JaxmppException jaxmppException) {
                a.log(Level.WARNING, "Failed to send push notification, retry " + i, jaxmppException);
                if (i != 3) continue;
                completableFuture.completeExceptionally(jaxmppException);
                continue;
            }
            catch (Throwable throwable) {
                a.log(Level.WARNING, "Failed to send push notification, retry " + i, throwable);
                if (i != 3) continue;
                completableFuture.completeExceptionally(throwable);
            }
        }
        if (completableFuture.isCompletedExceptionally()) {
            this.e.inc();
        }
        return completableFuture;
    }

    public void beforeUnregister() {
        for (FcmConnection fcmConnection : this.b) {
            fcmConnection.setProvider(null);
            fcmConnection.stop();
        }
        this.b.clear();
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("serverKey") || changedFields.contains("senderId") || changedFields.contains("poolSize")) {
            for (FcmConnection fcmConnection : this.b) {
                fcmConnection.setProvider(null);
                fcmConnection.stop();
            }
            this.b.clear();
            for (int i = 0; i < this.poolSize; ++i) {
                FcmConnection fcmConnection;
                fcmConnection = new FcmConnection(this.serverKey, this.senderId, false);
                fcmConnection.setProvider(this);
                fcmConnection.start();
                this.b.add(fcmConnection);
            }
        }
    }

    @Override
    public void connected(FcmConnection conn) {
        this.c.offer(conn);
    }

    @Override
    public void disconnected(FcmConnection conn) {
        this.c.remove(conn);
    }

    @Override
    public void unregisterDevice(String deviceId) {
        try {
            Stream<IPushSettings> stream = this.repository.getNodeSettings(this.getName(), deviceId);
            stream.forEach(iPushSettings -> {
                try {
                    IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), this.getName(), deviceId);
                    if (iPushSettings2 != null && (iPushSettings2.getDevices().isEmpty() || iPushSettings2.getVersion() > 0)) {
                        this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings2.getServiceJid(), iPushSettings2.getOwnerJid(), iPushSettings2.getNode(), Affiliation.none);
                    }
                }
                catch (ComponentException | RepositoryException throwable) {
                    a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, throwable);
                }
            });
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
        }
    }

    public void everyHour() {
        this.d.everyHour();
        this.e.everyHour();
    }

    public void everyMinute() {
        this.d.everyMinute();
        this.e.everyMinute();
    }

    public void everySecond() {
        this.d.everySecond();
        this.e.everySecond();
    }

    public void getStatistics(String compName, StatisticsList list) {
        this.d.getStatistics(compName + "/" + this.getName(), list);
        this.e.getStatistics(compName + "/" + this.getName(), list);
    }

    protected Map<String, Object> preparePayload(INotification notification) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message_id", "m-" + UUID.randomUUID().toString());
        hashMap.put("priority", "high");
        if (notification instanceof IPlainNotification) {
            IPlainNotification iPlainNotification = (IPlainNotification)notification;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("account", notification.getAccount().toString());
            iPlainNotification.ifMessageCount(l -> hashMap2.put("unread-messages", (String)l));
            iPlainNotification.ifLastMessageSender(jID -> hashMap2.put("sender", jID.toString()));
            iPlainNotification.ifGroupchatSenderNickname(string -> hashMap2.put("nickname", (String)string));
            iPlainNotification.ifLastMessageBody(object -> {
                if (((String)object).length() > 512) {
                    object = ((String)object).substring(0, 500) + "...";
                }
                hashMap2.put("body", (String)object);
            });
            hashMap.put("data", hashMap2);
        } else if (notification instanceof IEncryptedNotification) {
            IEncryptedNotification iEncryptedNotification = (IEncryptedNotification)notification;
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            hashMap3.put("account", notification.getAccount().toString());
            hashMap3.put("encrypted", iEncryptedNotification.getEncrypted());
            hashMap.put("data", hashMap3);
        }
        return hashMap;
    }

    @Override
    public void pushNotificationFailed(String error) {
        this.e.inc();
    }

    private boolean a(String string) throws Throwable {
        FcmConnection fcmConnection = null;
        try {
            fcmConnection = this.c.poll(5L, TimeUnit.SECONDS);
            if (fcmConnection != null) {
                fcmConnection.sendNotification(string);
                this.c.offer(fcmConnection);
            }
        }
        finally {
            if (fcmConnection != null) {
                this.c.offer(fcmConnection);
            }
        }
        return false;
    }
}

