/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.push.PushNotificationsComponent;
import tigase.push.adhoc.AbstractAdHocCommand;
import tigase.push.api.IPushProvider;
import tigase.push.apns.APNSUtil;
import tigase.push.apns.APNsBinaryApiProvider;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="set-apns-encryption-key", parent=PushNotificationsComponent.class, active=true)
public class SetAPNSEncryptionKey
extends AbstractAdHocCommand {
    private static final Logger b = Logger.getLogger(SetAPNSEncryptionKey.class.getCanonicalName());
    @Inject
    PushNotificationsComponent a;
    @Inject(nullAllowed=true)
    private List<APNsBinaryApiProvider> pushProviders;

    public String getName() {
        return "Set APNS encryption key";
    }

    public String getNode() {
        return "set-apns-encryption-key";
    }

    public boolean isAllowedFor(JID jid) {
        return this.a.isAdmin(jid);
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("form", "Select APNS provider to set APNS encryption key", "Use this form to set APNS encryption key for push provider");
        String[] stringArray = new String[this.pushProviders.size()];
        String[] stringArray2 = new String[this.pushProviders.size()];
        for (int i = 0; i < this.pushProviders.size(); ++i) {
            IPushProvider iPushProvider = this.pushProviders.get(i);
            stringArray[i] = iPushProvider.getDescription() + ": " + iPushProvider.getName();
            stringArray2[i] = iPushProvider.getName();
        }
        form.addField(Field.fieldListSingle((String)"provider", (String)"", (String)"Provider", (String[])stringArray, (String[])stringArray2));
        form.addField(Field.fieldTextSingle((String)"apns-key-id", (String)"", (String)"APNS Key ID"));
        form.addField(Field.fieldTextMulti((String)"apns-key", (String)"", (String)"APNS Key"));
        form.addField(Field.fieldTextSingle((String)"apns-team-id", (String)"", (String)"APNS Team ID"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String string = form.getAsString("provider");
        String string2 = Optional.ofNullable(form.getAsString("apns-key-id")).map(String::trim).orElse("");
        String string3 = Optional.ofNullable(form.getAsStrings("apns-key")).map(stringArray -> String.join((CharSequence)"\n", stringArray)).orElse("");
        String string4 = Optional.ofNullable(form.getAsString("apns-team-id")).map(String::trim).orElse("");
        if (string == null || string2.isBlank() || string3.isBlank() || string4.isBlank()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Provider, Key ID, Key, and Team ID must not be empty and key must be a valid p8 encoded private key.");
        }
        try {
            APNSUtil.loadPrivateKey(string3);
        }
        catch (Exception exception) {
            b.log(Level.FINEST, "Invalid ad-hoc payload", exception);
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Key is not a valid p8 encoded private key!");
        }
        APNsBinaryApiProvider aPNsBinaryApiProvider2 = this.pushProviders.stream().filter(aPNsBinaryApiProvider -> aPNsBinaryApiProvider.getName().equals(string)).findAny().orElseThrow(() -> new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported push provider"));
        try {
            aPNsBinaryApiProvider2.setAPNSEncryptionKey(string2, string3, string4);
            Form form2 = new Form("result", "APNS encryption key updated", "APNS encryption key updated");
            form2.addField(Field.fieldFixed((String)"APNS encryption key updated"));
            response.completeSession();
            return form2;
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }
}

