/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import tigase.db.util.SchemaManager;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.Page;

public class DBCheckPage
extends Page {
    private final Config config;

    public DBCheckPage(Config config) {
        super("Database connectivity check", "dbCheck.html", Stream.empty());
        this.config = config;
    }

    public synchronized Map<SchemaManager.DataSourceInfo, List<SchemaManager.ResultEntry>> loadSchema() {
        try {
            Map<String, Object> configStr = this.config.getConfigurationInMap();
            SchemaManager schemaManager = new SchemaManager();
            schemaManager.setConfig(configStr);
            if (this.config.dbProperties.getProperty("rootUser") != null || this.config.dbProperties.getProperty("rootPass") != null) {
                schemaManager.setDbRootCredentials(this.config.dbProperties.getProperty("rootUser"), this.config.dbProperties.getProperty("rootPass"));
            }
            if (this.config.admins != null) {
                schemaManager.setAdmins(Arrays.asList(this.config.admins), this.config.adminPwd);
            }
            return schemaManager.loadSchemas();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

