/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

@Bean(name="defaultConfigModule", parent=PubSubComponent.class, active=true)
public class DefaultConfigModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_DEFAULT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"default"));
    @Inject(bean="defaultNodeConfig")
    protected LeafNodeConfig defaultNodeConfig;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-default"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_DEFAULT;
    }

    public void process(Packet packet) throws PubSubException {
        try {
            Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
            Element def = new Element("default");
            Element x = this.defaultNodeConfig.getFormElement();
            if (x == null) {
                throw new PubSubException(packet.getElement(), Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "config-node"));
            }
            def.addChild((XMLNodeIfc)x);
            pubsub.addChild((XMLNodeIfc)def);
            Packet result = packet.okResult(pubsub, 0);
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing config command", e);
            throw new RuntimeException(e);
        }
    }
}

