/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.manager.SendQ;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSendServer;
import com.sun.management.snmp.manager.SnmpTimerServer;
import com.sun.management.snmp.manager.WaitQ;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;

final class SnmpQManager
implements Serializable {
    private static final long serialVersionUID = 6564946501693011456L;
    static final long pollMargin = 900L;
    private static final Object globalLock = new int[1];
    static String dbgTag = "SnmpQManager";
    static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpQManager");
    private SendQ newq;
    private WaitQ waitq;
    private static SnmpQManager theSnmpq = null;
    private ThreadGroup queueThreadGroup = null;
    private Thread requestQThread = null;
    private Thread timerQThread = null;
    private static int nbSessions;
    private final Object lock = new int[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpQManager getTheInstance() {
        Object object = globalLock;
        synchronized (object) {
            if (theSnmpq == null) {
                theSnmpq = new SnmpQManager();
                nbSessions = 0;
            }
            return theSnmpq;
        }
    }

    static synchronized SnmpQManager incNbSessions() {
        SnmpQManager inst = SnmpQManager.getTheInstance();
        ++nbSessions;
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void decNbSessions() {
        if (--nbSessions == 0) {
            theSnmpq.destroy();
            Object object = globalLock;
            synchronized (object) {
                theSnmpq = null;
            }
        }
    }

    private SnmpQManager() {
        this.newq = new SendQ(20, 5);
        this.waitq = new WaitQ(20, 5);
        this.queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
        this.startQThreads();
    }

    Object getRemoveLock() {
        return this.lock;
    }

    private void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public void finalize() {
        this.queueThreadGroup.destroy();
    }

    private void stopQThreads() {
        if (this.timerQThread != null && this.timerQThread.isAlive()) {
            ((SnmpTimerServer)this.timerQThread).stopTimerServer();
        }
        this.waitq = null;
        this.timerQThread = null;
        if (this.requestQThread != null && this.requestQThread.isAlive()) {
            ((SnmpSendServer)this.requestQThread).stopSendServer();
        }
        this.newq = null;
        this.requestQThread = null;
    }

    public String statusReport() {
        return "Requests outstanding/waiting : " + this.newq.size() + "/" + this.waitq.size() + " Send/timer servers : " + this.requestQThread.isAlive() + "/" + this.timerQThread.isAlive();
    }

    public void addRequest(SnmpRequest reqc) {
        this.newq.addRequest(reqc);
    }

    public void addWaiting(SnmpRequest reqc) {
        this.waitq.addWaiting(reqc);
    }

    public Vector getAllOutstandingRequest(long range) {
        return this.newq.getAllOutstandingRequest(range);
    }

    public SnmpRequest getOutstandingRequest() {
        return this.newq.getOutstandingRequest();
    }

    public SnmpRequest getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(SnmpRequest reqc) {
        Object object = this.lock;
        synchronized (object) {
            this.newq.removeElement(reqc);
            this.waitq.removeElement(reqc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpRequest removeRequest(long reqid) {
        SnmpRequest reqc = null;
        Object object = this.lock;
        synchronized (object) {
            reqc = this.newq.removeRequest(reqid);
            if (reqc == null) {
                reqc = this.waitq.removeRequest(reqid);
            }
        }
        return reqc;
    }

    public SnmpPduFactory findPduFactory(InetAddress address, int port) {
        SnmpPduFactory factory = this.newq.findPduFactory(address, port);
        if (factory == null) {
            factory = this.waitq.findPduFactory(address, port);
        }
        return factory;
    }

    public String listQContents() {
        try {
            long time = System.currentTimeMillis();
            StringBuffer s = new StringBuffer("******* Qdump begins ****\n");
            s.append(this.newq.printAllRequest(time) + "\n");
            s.append(this.waitq.printAllRequest(time) + "\n");
            s.append("********* Qdump ends ***********\n");
            return s.toString();
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("listQContents", e);
            }
            return null;
        }
    }

    private synchronized void destroy() {
        ((SnmpTimerServer)this.timerQThread).isBeingDestroyed = true;
        this.waitq.isBeingDestroyed = true;
        ((SnmpSendServer)this.requestQThread).isBeingDestroyed = true;
        this.newq.isBeingDestroyed = true;
        this.stopQThreads();
    }
}

