/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.filetransfer;

import java.net.Socket;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.AsyncCallback;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesCache;
import tigase.jaxmpp.core.client.xmpp.modules.capabilities.CapabilitiesModule;
import tigase.jaxmpp.core.client.xmpp.modules.connection.ConnectionSession;
import tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransferModule;
import tigase.jaxmpp.core.client.xmpp.modules.presence.PresenceModule;
import tigase.jaxmpp.core.client.xmpp.modules.socks5.StreamInitiationOfferAsyncCallback;
import tigase.jaxmpp.core.client.xmpp.stanzas.Presence;
import tigase.jaxmpp.j2se.connection.ConnectionManager;
import tigase.jaxmpp.j2se.connection.socks5bytestream.Socks5BytestreamsConnectionManager;
import tigase.jaxmpp.j2se.filetransfer.FileTransfer;
import tigase.jaxmpp.j2se.filetransfer.FileTransferManager;
import tigase.jaxmpp.j2se.filetransfer.FileTransferNegotiatorAbstract;

public class Socks5FileTransferNegotiator
extends FileTransferNegotiatorAbstract
implements ConnectionManager.ConnectionEstablishedHandler,
FileTransferModule.FileTransferRequestHandler {
    private static final Logger log = Logger.getLogger(Socks5FileTransferNegotiator.class.getCanonicalName());
    private final String BASE = "session-";
    private final String PACKET_ID = "session-initiation-packet-id";
    private final String STREAM_METHOD = "session-stream-method";
    private final Socks5BytestreamsConnectionManager connectionManager = new Socks5BytestreamsConnectionManager();

    @Override
    public void acceptFile(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) throws JaxmppException {
        FileTransferModule ftModule = (FileTransferModule)jaxmpp.getModule(FileTransferModule.class);
        if (ftModule != null) {
            String packetId = (String)ft.getData("session-initiation-packet-id");
            String streamMethod = (String)ft.getData("session-stream-method");
            if (packetId == null) {
                this.fireOnFailure(ft, null);
            } else if (streamMethod == null) {
                ftModule.rejectStreamInitiation(ft, packetId);
            } else {
                this.connectionManager.register(jaxmpp, (ConnectionSession)ft);
                ftModule.acceptStreamInitiation(ft, packetId, streamMethod);
            }
        }
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public boolean isSupported(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) {
        Presence p = PresenceModule.getPresenceStore((SessionObject)jaxmpp.getSessionObject()).getPresence(ft.getPeer());
        CapabilitiesModule capsModule = (CapabilitiesModule)jaxmpp.getModule(CapabilitiesModule.class);
        CapabilitiesCache capsCache = capsModule.getCache();
        try {
            String capsNode = FileTransferManager.getCapsNode(p);
            Set<String> features = capsCache != null ? capsCache.getFeatures(capsNode) : null;
            return true;
        }
        catch (XMLException ex) {
            return true;
        }
    }

    @Override
    public void onConnectionEstablished(SessionObject sessionObject, ConnectionSession connectionSession, Socket socket) throws JaxmppException {
        FileTransfer ft = (FileTransfer)connectionSession;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "got ft incoming = {0} with packet id = {1}", new Object[]{ft.isIncoming(), ft.getData("packet-id")});
        }
        if (ft.isIncoming() && ft.getData("packet-id") != null) {
            this.connectionManager.sendStreamhostUsed(ft, (String)ft.getData("packet-id"));
        }
        if (socket != null) {
            this.fireOnSuccess(ft);
        }
    }

    public void onFileTransferRequest(SessionObject sessionObject, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer fts, String id, List<String> streamMethods) {
        FileTransfer ft = new FileTransfer(fts.getSessionObject(), fts.getPeer(), fts.getSid());
        ft.setFileInfo(fts.getFilename(), fts.getFileSize(), fts.getFileModification(), fts.getFileMimeType());
        ft.setData("session-initiation-packet-id", id);
        ft.setData("session-stream-method", streamMethods.get(0));
        this.fireOnRequest(sessionObject, ft);
    }

    @Override
    public void registerListeners(JaxmppCore jaxmpp) {
        ((FileTransferModule)jaxmpp.getModule(FileTransferModule.class)).addFileTransferRequestHandler((FileTransferModule.FileTransferRequestHandler)this);
    }

    @Override
    public void rejectFile(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) throws JaxmppException {
        FileTransferModule ftModule = (FileTransferModule)jaxmpp.getModule(FileTransferModule.class);
        if (ftModule != null) {
            String packetId = (String)ft.getData("session-initiation-packet-id");
            if (packetId == null) {
                this.fireOnFailure(ft, null);
            } else {
                ftModule.rejectStreamInitiation(ft, packetId);
            }
        }
    }

    @Override
    public void sendFile(JaxmppCore jaxmpp, tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer ft) throws JaxmppException {
        FileTransferModule ftModule = (FileTransferModule)jaxmpp.getModule(FileTransferModule.class);
        if (ftModule != null) {
            this.connectionManager.initConnection(jaxmpp, (ConnectionSession)ft, new ConnectionManager.InitializedCallback(){

                @Override
                public void initialized(JaxmppCore jaxmpp, ConnectionSession session) {
                    try {
                        Socks5FileTransferNegotiator.this.sendFile2(jaxmpp, (FileTransfer)session);
                    }
                    catch (JaxmppException ex) {
                        Socks5FileTransferNegotiator.this.fireOnFailure((FileTransfer)session, ex);
                    }
                }
            });
            return;
        }
        this.fireOnFailure(ft, null);
    }

    public void sendFile2(final JaxmppCore jaxmpp, final FileTransfer ft) throws JaxmppException {
        FileTransferModule ftModule = (FileTransferModule)jaxmpp.getModule(FileTransferModule.class);
        if (ftModule != null) {
            ftModule.sendStreamInitiationOffer((tigase.jaxmpp.core.client.xmpp.modules.filetransfer.FileTransfer)ft, new String[]{"http://jabber.org/protocol/bytestreams"}, (AsyncCallback)new StreamInitiationOfferAsyncCallback(ft.getSid()){

                public void onAccept(String sid) {
                    try {
                        Socks5FileTransferNegotiator.this.connectionManager.connectTcp(jaxmpp, (ConnectionSession)ft);
                    }
                    catch (JaxmppException ex) {
                        Socks5FileTransferNegotiator.this.fireOnFailure(ft, ex);
                    }
                }

                public void onError() {
                    Socks5FileTransferNegotiator.this.fireOnFailure(ft, null);
                }

                public void onReject() {
                    Socks5FileTransferNegotiator.this.fireOnReject(ft);
                }
            });
        }
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.connectionManager.setContext(context);
        context.getEventBus().addHandler(ConnectionManager.ConnectionEstablishedHandler.ConnectionEstablishedEvent.class, (EventHandler)this);
    }

    @Override
    public void unregisterListeners(JaxmppCore jaxmpp) {
        ((FileTransferModule)jaxmpp.getModule(FileTransferModule.class)).removeFileTransferRequestHandler((FileTransferModule.FileTransferRequestHandler)this);
    }
}

