/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import tigase.http.api.HttpServerIfc;
import tigase.io.SSLContextContainer;
import tigase.io.SSLContextContainerIfc;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBeanWithDefaultBeanClass;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;
import tigase.net.SocketType;

public abstract class AbstractHttpServer
implements HttpServerIfc {
    private static final ConcurrentHashMap<String, AbstractHttpServer> SERVERS = new ConcurrentHashMap();
    protected List<Integer> httpPorts = new CopyOnWriteArrayList<Integer>();
    protected List<Integer> httpsPorts = new CopyOnWriteArrayList<Integer>();
    protected Kernel kernel;
    @ConfigField(desc="Name of the bean")
    private String name;
    @Inject
    protected PortsConfigBean portsConfigBean;
    @Inject(bean="sslContextContainer")
    protected SSLContextContainerIfc sslContextContainer;

    public static Optional<PortConfigBean> getPortConfig(String name, int port) {
        return Optional.ofNullable(SERVERS.get(name)).flatMap(server -> Arrays.stream(server.portsConfigBean.portsBeans).filter(config -> port == ((PortConfigBean)config).name).findFirst());
    }

    @Override
    public List<Integer> getHTTPPorts() {
        return Collections.unmodifiableList(this.httpPorts);
    }

    @Override
    public List<Integer> getHTTPSPorts() {
        return Collections.unmodifiableList(this.httpsPorts);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void register(Kernel kernel) {
        this.kernel = kernel;
        kernel.registerBean(SSLContextContainer.class).exec();
    }

    public void unregister(Kernel kernel) {
        this.kernel = null;
    }

    public void initialize() {
        SERVERS.put(this.name, this);
    }

    public void beforeUnregister() {
        SERVERS.remove(this.name);
    }

    public static abstract class PortConfigBean
    implements ConfigurationChangedAware,
    UnregisterAware,
    Initializable {
        @ConfigField(desc="Certificate for domain is SSL or TLS is enabled")
        private String domain;
        @ConfigField(desc="Port")
        private Integer name;
        @ConfigField(desc="Socket type")
        private SocketType socket = SocketType.plain;
        @ConfigField(desc="Redirect URI")
        private String redirectUri;
        @ConfigField(desc="Redirection condition")
        private RedirectionCondition redirectCondition = RedirectionCondition.never;

        public int getPort() {
            return this.name;
        }

        public SocketType getSocket() {
            return this.socket;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public RedirectionCondition getRedirectCondition() {
            return this.redirectCondition;
        }

        public static enum RedirectionCondition {
            never,
            http,
            https,
            always;

        }
    }

    public static abstract class PortsConfigBean
    implements RegistrarBeanWithDefaultBeanClass,
    Initializable {
        private Kernel kernel;
        @ConfigField(desc="Ports to enable", alias="ports")
        private HashSet<Integer> ports;
        @Inject(nullAllowed=true)
        private PortConfigBean[] portsBeans;

        public void register(Kernel kernel) {
            this.kernel = kernel;
            String connManagerBean = kernel.getParent().getName();
            this.kernel.getParent().ln("service", kernel, connManagerBean);
        }

        public void unregister(Kernel kernel) {
            this.kernel = null;
        }

        public void initialize() {
            if (this.ports == null) {
                this.ports = new HashSet<Integer>(Arrays.asList(8080));
            }
            for (Integer port : this.ports) {
                String name = String.valueOf(port);
                if (this.kernel.getDependencyManager().getBeanConfig(name) != null) continue;
                this.kernel.registerBean(name).asClass(this.getDefaultBeanClass()).exec();
            }
            this.register(this.kernel);
        }
    }
}

