/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import tigase.db.Repository;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.server.xmppclient.SeeOtherHostDualIP;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"})
public class MongoDualIPRepository
implements SeeOtherHostDualIP.DualIPRepository<MongoDataSource> {
    private static final Logger log = Logger.getLogger(MongoDualIPRepository.class.getCanonicalName());
    private static final String CLUSTER_NODES = "tig_cluster_nodes";
    private MongoCollection<Document> clusterNodes;
    private MongoDatabase db;

    public Map<BareJID, BareJID> queryAllDB() throws SQLException {
        ConcurrentSkipListMap<BareJID, BareJID> result = new ConcurrentSkipListMap<BareJID, BareJID>();
        try {
            for (Document dto : this.clusterNodes.find().batchSize(100)) {
                String user_jid = (String)dto.get((Object)"_id");
                String node_jid = (String)dto.get((Object)"secondary");
                try {
                    BareJID hostname_hid = BareJID.bareJIDInstance((String)user_jid);
                    BareJID secondary = BareJID.bareJIDInstance((String)node_jid);
                    result.put(hostname_hid, secondary);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Invalid host or secondary hostname JID: " + user_jid + ", " + node_jid);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", ex);
        }
        log.info("Loaded " + result.size() + " redirect definitions from database.");
        return result;
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, CLUSTER_NODES)) {
            this.db.createCollection(CLUSTER_NODES);
        }
        this.clusterNodes = this.db.getCollection(CLUSTER_NODES);
        this.clusterNodes.createIndex((Bson)new BasicDBObject("hostname", (Object)1));
    }
}

