/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.PresenceStore;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.cluster.MUCComponentClustered;
import tigase.muc.cluster.Occupant;
import tigase.muc.cluster.StrategyIfc;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class RoomClustered<ID>
extends RoomWithId<ID> {
    private final ConcurrentMap<JID, String> a = new ConcurrentHashMap<JID, String>();
    private final ConcurrentMap<String, Occupant> b = new ConcurrentHashMap<String, Occupant>();
    private final Predicate<BareJID> c;

    protected RoomClustered(ID id, RoomConfig rc, Date creationDate, BareJID creatorJid, Predicate<BareJID> isJidForLocalClusterNode) {
        super(id, rc, creationDate, creatorJid);
        this.c = isJidForLocalClusterNode;
    }

    public Collection<Occupant> getRemoteOccupants() {
        return this.b.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteOccupant(String nickname, JID occupantJID, Role role, Affiliation affiliation, Element presence) {
        Occupant occupant;
        Occupant occupant2;
        if (this.a.containsKey(occupantJID) && !nickname.equals(this.a.get(occupantJID))) {
            this.removeRemoteOccupant(occupantJID);
        }
        if ((occupant2 = (Occupant)this.b.get(nickname)) == null) {
            occupant2 = new Occupant(nickname, occupantJID, role, affiliation, presence);
            occupant = this.b.putIfAbsent(nickname, occupant2);
            if (occupant != null) {
                occupant2 = occupant;
            } else {
                this.a.put(occupantJID, nickname);
                return;
            }
        }
        occupant2.addOccupant(occupantJID, presence);
        occupant = occupant2;
        synchronized (occupant) {
            if (!this.b.containsKey(nickname)) {
                this.b.put(nickname, occupant2);
            }
        }
        occupant2.setRole(role);
        occupant2.setAffiliation(affiliation);
        this.a.put(occupantJID, nickname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteOccupant(JID occupantJID) {
        String string = (String)this.a.remove(occupantJID);
        if (string == null) {
            return;
        }
        Occupant occupant = (Occupant)this.b.get(string);
        if (occupant == null) {
            return;
        }
        occupant.removeOccupant(occupantJID);
        if (occupant.isEmpty()) {
            Occupant occupant2 = occupant;
            synchronized (occupant2) {
                if (occupant.isEmpty()) {
                    this.b.remove(string, occupant);
                }
            }
        }
    }

    public Optional<JID> getOccupantJidForIqRequestForward(String recipientNickname) {
        return Optional.ofNullable(this.getOccupantsJidByNickname(recipientNickname)).map(bareJID -> this.presences.getBestPresenceInt(bareJID)).map(PresenceStore.Presence::getFrom).or(() -> Optional.ofNullable((Occupant)this.b.get(recipientNickname)).map(Occupant::getBestPresenceInt).map(Occupant.Presence::getFrom));
    }

    public Optional<JID> getOccupantJidForIqResponseForward(String recipientNickname, Predicate<JID> filter) {
        return Stream.concat(this.getLocalOccupantsJidsByNickname(recipientNickname).stream(), Optional.ofNullable((Occupant)this.b.get(recipientNickname)).map(occupant -> occupant.getOccupants().stream()).orElse(Stream.empty())).filter(filter).findFirst();
    }

    public boolean isOccupantOnline(BareJID jid) {
        if (!super.isOccupantOnline(jid)) {
            return this.b.values().stream().filter(occupant -> occupant.getOccupantJID().equals((Object)jid)).findAny().isPresent();
        }
        return true;
    }

    protected Predicate<BareJID> createAvailableFilter() {
        Set set = Stream.concat(this.getOccupantsBareJids(), this.b.values().stream().map(occupant -> occupant.getOccupantJID())).collect(Collectors.toSet());
        return bareJID -> !set.contains(bareJID) && this.c.test((BareJID)bareJID);
    }

    public int getOccupantsCount() {
        return super.getOccupantsCount() + this.b.size();
    }

    public Collection<JID> getOccupantsJidsByNickname(String nickname) {
        if (nickname == null) {
            return Collections.emptyList();
        }
        Collection collection = this.getLocalOccupantsJidsByNickname(nickname);
        if (!collection.isEmpty()) {
            return collection;
        }
        Occupant occupant = (Occupant)this.b.get(nickname);
        if (occupant != null) {
            return Collections.unmodifiableCollection(occupant.getOccupants());
        }
        return this.getPersistentOccupantsJidsByNickname(nickname);
    }

    public boolean removeOccupant(JID jid) {
        String string = this.getOccupantsNickname(jid);
        Occupant occupant = string == null ? null : (Occupant)this.b.get(string);
        return super.removeOccupant(jid) && (occupant == null || occupant.isEmpty());
    }

    public RoomAffiliation getAffiliation(String nickname) {
        Occupant occupant;
        RoomAffiliation roomAffiliation = super.getAffiliation(nickname);
        if (roomAffiliation == RoomAffiliation.none && (occupant = (Occupant)this.b.get(nickname)) != null) {
            roomAffiliation = RoomAffiliation.from((Affiliation)occupant.getAffiliation(), (boolean)false, null);
        }
        return roomAffiliation;
    }

    public Role getRole(String nickname) {
        Occupant occupant;
        Role role = super.getRole(nickname);
        if (role == Role.none && nickname != null && (occupant = (Occupant)this.b.get(nickname)) != null) {
            role = occupant.getRole();
        }
        return role;
    }

    public Element getLastPresenceCopy(BareJID occupantJid, String nickname) {
        Element element;
        int n;
        PresenceStore.Presence presence = this.presences.getBestPresenceInt(occupantJid);
        Occupant occupant = (Occupant)this.b.get(nickname);
        Occupant.Presence presence2 = occupant != null ? occupant.getBestPresenceInt() : null;
        int n2 = presence == null ? -1 : presence.getPriority();
        int n3 = n = presence2 == null ? -1 : presence2.getPriority();
        Element element2 = presence == null && presence2 == null ? null : (element = n2 < n ? presence2.getElement() : presence.getElement());
        if (element != null) {
            return element.clone();
        }
        return super.getLastPresenceCopy(occupantJid, nickname);
    }

    @Bean(name="roomFactory", parent=MUCComponentClustered.class, active=true, exportable=true)
    public static class RoomFactoryImpl
    implements Room.RoomFactory {
        @Inject
        private StrategyIfc strategy;

        public <T> RoomWithId<T> newInstance(T id, RoomConfig rc, Date creationDate, BareJID creatorJid) {
            return new RoomClustered<T>(id, rc, creationDate, creatorJid, this::a);
        }

        private boolean a(BareJID bareJID) {
            return this.strategy.shouldSendMessageOfflineToJidFromLocalNode(bareJID);
        }
    }
}

