/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.AwsLogsAppender;
import ca.pjer.logback.Worker;
import ca.pjer.logback.metrics.AwsLogsMetricsHolder;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.amazonaws.services.logs.model.InputLogEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class AsyncWorker
extends Worker
implements Runnable {
    private final int maxBatchLogEvents;
    private final int discardThreshold;
    private final AtomicBoolean running;
    private final BlockingQueue<InputLogEvent> queue;
    private final AtomicLong lostCount;
    private Thread thread;
    private static final int MAX_BATCH_SIZE = 0x100000;

    AsyncWorker(AwsLogsAppender awsLogsAppender) {
        super(awsLogsAppender);
        this.maxBatchLogEvents = awsLogsAppender.getMaxBatchLogEvents();
        this.discardThreshold = (int)Math.ceil((double)this.maxBatchLogEvents * 1.5);
        this.running = new AtomicBoolean(false);
        this.queue = new ArrayBlockingQueue<InputLogEvent>(this.maxBatchLogEvents * 2);
        this.lostCount = new AtomicLong(0L);
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.running.compareAndSet(false, true)) {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.setName(this.getAwsLogsAppender().getName() + " Async Worker");
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.running.compareAndSet(true, false)) {
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                this.running.notifyAll();
            }
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException e) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
            this.queue.clear();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(ILoggingEvent event) {
        if (this.queue.size() >= this.discardThreshold && !event.getLevel().isGreaterOrEqual(Level.WARN)) {
            this.lostCount.incrementAndGet();
            AwsLogsMetricsHolder.get().incrementLostCount();
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                this.running.notifyAll();
            }
            return;
        }
        InputLogEvent logEvent = this.asInputLogEvent(event);
        if (this.getAwsLogsAppender().getMaxBlockTimeMillis() > 0L) {
            boolean interrupted = false;
            long until = System.currentTimeMillis() + this.getAwsLogsAppender().getMaxBlockTimeMillis();
            try {
                long now = System.currentTimeMillis();
                while (now < until) {
                    try {
                        if (this.queue.offer(logEvent, until - now, TimeUnit.MILLISECONDS)) break;
                        this.lostCount.incrementAndGet();
                        AwsLogsMetricsHolder.get().incrementLostCount();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        now = System.currentTimeMillis();
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else if (!this.queue.offer(logEvent)) {
            this.lostCount.incrementAndGet();
            AwsLogsMetricsHolder.get().incrementLostCount();
        }
        if (this.queue.size() >= this.maxBatchLogEvents) {
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                this.running.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running.get()) {
            this.flush(false);
            try {
                AtomicBoolean atomicBoolean = this.running;
                synchronized (atomicBoolean) {
                    if (this.running.get()) {
                        this.running.wait(this.getAwsLogsAppender().getMaxFlushTimeMillis());
                    }
                }
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.flush(true);
    }

    private void flush(boolean all) {
        block5: {
            try {
                long lostCount = this.lostCount.getAndSet(0L);
                if (lostCount > 0L && this.getAwsLogsAppender().getVerbose()) {
                    this.getAwsLogsAppender().addWarn(lostCount + " events lost");
                }
                if (!this.queue.isEmpty()) {
                    do {
                        Collection<InputLogEvent> batch = this.drainBatchFromQueue();
                        this.getAwsLogsAppender().getAwsLogsStub().logEvents(batch);
                    } while (this.queue.size() >= this.maxBatchLogEvents || all && !this.queue.isEmpty());
                }
            }
            catch (Exception e) {
                AwsLogsMetricsHolder.get().incrementFlushFailed(e);
                if (!this.getAwsLogsAppender().getVerbose()) break block5;
                this.getAwsLogsAppender().addError("Unable to flush events to AWS", e);
            }
        }
    }

    private Collection<InputLogEvent> drainBatchFromQueue() {
        int batchSize;
        InputLogEvent removed;
        ArrayDeque<InputLogEvent> batch = new ArrayDeque<InputLogEvent>(this.maxBatchLogEvents);
        this.queue.drainTo(batch, 10000);
        for (batchSize = AsyncWorker.batchSize(batch); batchSize > 0x100000; batchSize -= AsyncWorker.eventSize(removed)) {
            removed = (InputLogEvent)batch.removeLast();
            if (this.queue.offer(removed)) continue;
            AwsLogsMetricsHolder.get().incrementBatchRequeueFailed();
            if (!this.getAwsLogsAppender().getVerbose()) continue;
            this.getAwsLogsAppender().addWarn("Failed requeuing message from too big batch");
        }
        AwsLogsMetricsHolder.get().incrementBatch(batchSize);
        return batch;
    }

    private static int batchSize(Collection<InputLogEvent> batch) {
        int size = 0;
        for (InputLogEvent event : batch) {
            size += AsyncWorker.eventSize(event);
        }
        return size;
    }
}

