/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.xml.DefaultElementFactory;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.SimpleHandler;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPParserException;

public class XMPPDomBuilderHandler<RefObject>
implements SimpleHandler {
    private static final Logger log = Logger.getLogger(XMPPDomBuilderHandler.class.getName());
    private static final String ELEM_STREAM_STREAM = "stream:stream";
    private static ElementFactory defaultFactory = new DefaultElementFactory();
    private ArrayDeque<Element> all_roots = new ArrayDeque(1);
    private ElementFactory customFactory = null;
    private ArrayDeque<Element> el_stack = new ArrayDeque(10);
    private int elements_number_limit;
    private int elements_number_limit_count = 0;
    private boolean error = false;
    private Map<String, String> namespaces = new TreeMap<String, String>();
    private Object parserState = null;
    private XMPPIOService<RefObject> service = null;
    private boolean streamClosed = false;
    private String top_xmlns = null;

    public XMPPDomBuilderHandler(XMPPIOService<RefObject> ioserv) {
        this.customFactory = defaultFactory;
        this.service = ioserv;
    }

    public XMPPDomBuilderHandler(XMPPIOService<RefObject> ioserv, ElementFactory factory) {
        this.customFactory = factory;
        this.service = ioserv;
    }

    public void elementCData(StringBuilder cdata) {
        Element elem;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Element CDATA: " + cdata);
        }
        if ((elem = this.el_stack.peek()) != null) {
            elem.addCData(cdata.toString());
        }
    }

    public boolean endElement(StringBuilder name) {
        String tmp_name_prefix;
        String tmp_name;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("End element name: " + name);
        }
        if ((tmp_name = name.toString()).equals(ELEM_STREAM_STREAM)) {
            this.streamClosed = true;
            return true;
        }
        if (this.el_stack.isEmpty()) {
            this.el_stack.push(this.newElement(tmp_name, null, null, null));
        }
        Element elem = this.el_stack.pop();
        int idx = tmp_name.indexOf(58);
        String tmp_xmlns = null;
        if (idx > 0 && (tmp_name_prefix = tmp_name.substring(0, idx)) != null) {
            for (String pref : this.namespaces.keySet()) {
                if (!tmp_name_prefix.equals(pref)) continue;
                tmp_xmlns = this.namespaces.get(pref);
                tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("new_xmlns = " + tmp_xmlns);
            }
        }
        if (elem.getName() != tmp_name.intern() || tmp_xmlns != null && !tmp_xmlns.equals(elem.getXMLNS())) {
            return false;
        }
        if (this.el_stack.isEmpty()) {
            this.elements_number_limit_count = 0;
            this.all_roots.offer(elem);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Adding new request: " + elem.toString());
            }
        } else {
            this.el_stack.peek().addChild((XMLNodeIfc)elem);
        }
        return true;
    }

    public void error(String errorMessage) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(errorMessage);
        }
        this.error = true;
    }

    public Queue<Element> getParsedElements() {
        return this.all_roots;
    }

    public boolean isStreamClosed() {
        return this.streamClosed;
    }

    public void otherXML(StringBuilder other) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Other XML content: " + other);
        }
    }

    public boolean parseError() {
        return this.error;
    }

    public Object restoreParserState() {
        return this.parserState;
    }

    public void saveParserState(Object state) {
        this.parserState = state;
    }

    public void setElementsLimit(int limit) {
        this.elements_number_limit = limit;
    }

    public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
        Element elem;
        String ns;
        String tmp_name;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Start element name: " + name);
            log.finest("Element attributes names: " + Arrays.toString(attr_names));
            log.finest("Element attributes values: " + Arrays.toString(attr_values));
        }
        if (attr_names != null) {
            for (int i = 0; i < attr_names.length && attr_names[i] != null; ++i) {
                if (!attr_names[i].toString().startsWith("xmlns:")) continue;
                this.namespaces.put(attr_names[i].substring("xmlns:".length(), attr_names[i].length()).intern(), attr_values[i].toString());
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Namespace found: " + attr_values[i].toString());
            }
        }
        if ((tmp_name = name.toString()).equals(ELEM_STREAM_STREAM)) {
            this.streamClosed = false;
            HashMap<String, String> attribs = new HashMap<String, String>();
            if (attr_names != null) {
                for (int i = 0; i < attr_names.length && attr_names[i] != null && attr_values[i] != null; ++i) {
                    attribs.put(attr_names[i].toString(), attr_values[i].toString());
                }
            }
            this.service.xmppStreamOpened(attribs);
            return;
        }
        String new_xmlns = null;
        String prefix = null;
        String tmp_name_prefix = null;
        int idx = tmp_name.indexOf(58);
        if (idx > 0) {
            tmp_name_prefix = tmp_name.substring(0, idx);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found prefixed element name, prefix: " + tmp_name_prefix);
            }
        }
        if (tmp_name_prefix != null) {
            for (String pref : this.namespaces.keySet()) {
                if (!tmp_name_prefix.equals(pref)) continue;
                new_xmlns = this.namespaces.get(pref);
                tmp_name = tmp_name.substring(pref.length() + 1, tmp_name.length());
                prefix = pref;
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("new_xmlns = " + new_xmlns);
            }
        }
        if ((ns = (elem = this.newElement(tmp_name, null, attr_names, attr_values)).getXMLNS()) == null && !this.el_stack.isEmpty() && this.el_stack.peek().getXMLNS() != null) {
            elem.setDefXMLNS(this.el_stack.peek().getXMLNS());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("DefXMLNS assigned: " + elem.toString());
            }
        }
        if (new_xmlns != null) {
            elem.setXMLNS(new_xmlns);
            elem.removeAttribute("xmlns:" + prefix);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("new_xmlns assigned: " + elem.toString());
            }
        }
        this.el_stack.push(elem);
    }

    private Element newElement(String name, String cdata, StringBuilder[] attnames, StringBuilder[] attvals) {
        ++this.elements_number_limit_count;
        Element el = this.customFactory.elementInstance(name, cdata, attnames, attvals);
        if (this.elements_number_limit_count > this.elements_number_limit) {
            throw new XMPPParserException("Too many elements for staza, possible DoS attack.Current service " + this.service.getClass() + " limit of elements: " + this.elements_number_limit);
        }
        return el;
    }
}

