/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import tigase.io.IOInterface;
import tigase.io.JcaTLSWrapper;
import tigase.io.SSLContextContainerIfc;
import tigase.io.SampleSocketThread;
import tigase.io.SocketIO;
import tigase.io.TLSIO;
import tigase.io.TLSUtil;
import tigase.util.log.LogFormatter;

public class TelnetClient
implements SampleSocketThread.SocketHandler {
    private static final Logger log = Logger.getLogger("tigase.io.TelnetClient");
    private static final Charset coder = Charset.forName("UTF-8");
    private static boolean continuous = false;
    private static boolean debug = false;
    private static long delay = 100L;
    private static String file = null;
    private static String hostname = "localhost";
    private static int port = 7777;
    private static boolean ssl = false;
    private IOInterface iosock = null;
    private SampleSocketThread reader = new SampleSocketThread(this);

    public static String help() {
        return "\nParameters:\n -?                this help message\n -h hostname       host name\n -p port           port number\n -ssl              turn SSL on for all connections\n -f file           file with content to send to remote host\n -c                continuous sending file content\n -t millis         delay between sending file content\n -v                prints server version info\n -d [true|false]   turn on|off debug mode\n";
    }

    public static void main(String[] args) throws Exception {
        TelnetClient.parseParams(args);
        if (debug) {
            TelnetClient.turnDebugOn();
        }
        if (ssl) {
            LinkedHashMap<String, Object> tls_params = new LinkedHashMap<String, Object>();
            tls_params.put("keys-store", "certs/keystore");
            tls_params.put("keys-store-password", "keystore");
            TLSUtil.configureSSLContext(tls_params);
        }
        TelnetClient client = new TelnetClient(hostname, port);
        InputStreamReader str_reader = new InputStreamReader(System.in);
        if (file != null) {
            FileReader fr = new FileReader(file);
            char[] file_buff = new char[65536];
            int res = -1;
            while ((res = fr.read(file_buff)) != -1) {
                client.writeData(new String(file_buff, 0, res));
            }
            fr.close();
        }
        char[] buff = new char[1024];
        while (true) {
            int res = str_reader.read(buff);
            client.writeData(new String(buff, 0, res));
        }
    }

    public static void parseParams(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-?")) {
                    System.out.print(TelnetClient.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(TelnetClient.version());
                    System.exit(0);
                }
                if (args[i].equals("-f")) {
                    if (i + 1 == args.length) {
                        System.out.print(TelnetClient.help());
                        System.exit(1);
                    } else {
                        file = args[++i];
                    }
                }
                if (args[i].equals("-h")) {
                    if (i + 1 == args.length) {
                        System.out.print(TelnetClient.help());
                        System.exit(1);
                    } else {
                        hostname = args[++i];
                    }
                }
                if (args[i].equals("-p")) {
                    if (i + 1 == args.length) {
                        System.out.print(TelnetClient.help());
                        System.exit(1);
                    } else {
                        port = Integer.decode(args[++i]);
                    }
                }
                if (args[i].equals("-d")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        debug = true;
                    } else {
                        boolean bl = debug = args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
                    }
                }
                if (args[i].equals("-c")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        continuous = true;
                    } else {
                        boolean bl = continuous = args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
                    }
                }
                if (!args[i].equals("-ssl")) continue;
                ssl = i + 1 == args.length || args[i + 1].startsWith("-") ? true : args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
            }
        }
    }

    public static void turnDebugOn() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(".level", "ALL");
        properties.put("handlers", "java.util.logging.ConsoleHandler");
        properties.put("java.util.logging.ConsoleHandler.formatter", LogFormatter.class.getName());
        properties.put("java.util.logging.ConsoleHandler.level", "ALL");
        Set entries = properties.entrySet();
        StringBuilder buff = new StringBuilder();
        for (Map.Entry entry : entries) {
            buff.append((String)entry.getKey() + "=" + (String)entry.getValue() + "\n");
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buff.toString().getBytes());
            LogManager.getLogManager().readConfiguration(bis);
            bis.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Can not configure logManager", e);
        }
    }

    public static String version() {
        return "\n-- \nTigase XMPP Telnet, version: " + TelnetClient.class.getPackage().getImplementationVersion() + "\nAuthor:  Artur Hefczyc <artur.hefczyc@tigase.org>\n-- \n";
    }

    public TelnetClient(String hostname, int port) throws Exception {
        this.reader.start();
        SocketChannel sc = SocketChannel.open(new InetSocketAddress(hostname, port));
        this.iosock = new SocketIO(sc);
        if (ssl) {
            SSLContextContainerIfc sslContextContainer = TLSUtil.getRootSslContextContainer();
            this.iosock = new TLSIO(this.iosock, new JcaTLSWrapper(sslContextContainer.getSSLContext("SSL", null, true), null, null, 0, true, false), ByteOrder.BIG_ENDIAN);
        }
        this.reader.addIOInterface(this.iosock);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Registered new client socket: " + sc);
        }
    }

    @Override
    public void handleIOInterface(IOInterface ioifc) throws IOException {
        ByteBuffer socketInput = ByteBuffer.allocate(ioifc.getSocketChannel().socket().getReceiveBufferSize());
        ByteBuffer tmpBuffer = ioifc.read(socketInput);
        if (ioifc.bytesRead() > 0) {
            tmpBuffer.flip();
            CharBuffer cb = coder.decode(tmpBuffer);
            tmpBuffer.clear();
            if (cb != null) {
                System.out.print(new String(cb.array()));
            }
        }
        if (!ioifc.isConnected()) {
            throw new EOFException("Channel has been closed.");
        }
        this.reader.addIOInterface(ioifc);
    }

    @Override
    public void handleSocketAccept(SocketChannel sc) {
    }

    public void writeData(String data) throws IOException {
        ByteBuffer dataBuffer = null;
        if (data != null && data.length() > 0) {
            dataBuffer = coder.encode(CharBuffer.wrap(data));
            this.iosock.write(dataBuffer);
        }
    }
}

