/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tigase.kernel.beans.config.AbstractBeanConfigurator;

public class ConfigReader {
    private static Pattern DOUBLE_PATTERN = Pattern.compile("(\\-?[0-9]+\\.[0-9]+)([dDfF]*)");
    private static Pattern INTEGER_PATTERN = Pattern.compile("(\\-?[0-9]+)([lL]*)");
    private static double x = 2.1f;
    private StateHolder holder = new StateHolder();

    public static Map<String, Object> flatTree(Map<String, Object> props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigReader.flatTree(result, null, props);
        return result;
    }

    private static void flatTree(Map<String, Object> result, String prefix, Map<String, Object> props) {
        props.forEach((k, v) -> {
            String key;
            String string = key = prefix == null ? k : prefix + "/" + k;
            if (v instanceof AbstractBeanConfigurator.BeanDefinition) {
                AbstractBeanConfigurator.BeanDefinition beanDefinition = (AbstractBeanConfigurator.BeanDefinition)v;
                if (beanDefinition.getClazzName() != null) {
                    result.put(key + "/class", beanDefinition.getClazzName());
                }
                if (beanDefinition.isActive()) {
                    result.put(key + "/active", "true");
                } else {
                    result.put(key + "/active", "false");
                }
            }
            if (v instanceof Map) {
                ConfigReader.flatTree(result, key, (Map)v);
            } else {
                result.put(key, v);
            }
        });
    }

    public Map<String, Object> read(Reader reader) throws IOException, ConfigException {
        BufferedReader buffReader = new BufferedReader(reader);
        Map<String, Object> props = this.process(buffReader);
        return props;
    }

    public Map<String, Object> read(File f) throws IOException, ConfigException {
        Map<String, Object> props;
        try (FileReader reader = new FileReader(f);){
            props = this.read(reader);
        }
        return props;
    }

    protected Object decodeValue(String string_in) {
        String string = string_in.trim();
        Matcher matcher = DOUBLE_PATTERN.matcher(string);
        if (matcher.matches()) {
            String value = matcher.group(1);
            String type = matcher.group(2);
            if (type.isEmpty() || "D".equals(type) || "d".equals(type)) {
                return Double.parseDouble(value);
            }
            return Float.valueOf(Float.parseFloat(value));
        }
        matcher = INTEGER_PATTERN.matcher(string);
        if (matcher.matches()) {
            String value = matcher.group(1);
            String type = matcher.group(2);
            if ("l".equals(type) || "L".equals(type)) {
                return Long.parseLong(value);
            }
            return Integer.parseInt(value);
        }
        switch (string) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "null": {
                return null;
            }
        }
        return string_in;
    }

    protected void setBeanDefinitionValue(Object val) {
        if (this.holder.key == null || this.holder.key.isEmpty()) {
            return;
        }
        switch (this.holder.key) {
            case "class": {
                this.holder.bean.setClazzName((String)val);
                break;
            }
            case "active": {
                this.holder.bean.setActive((Boolean)val);
                break;
            }
            case "exportable": {
                this.holder.bean.setExportable((Boolean)val);
                break;
            }
            default: {
                throw new RuntimeException("Error in configuration file - unknown bean definition field: " + this.holder.key);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> process(Reader reader) throws IOException, ConfigException {
        this.holder.map = new HashMap<String, Object>();
        int line = 1;
        int pos = 0;
        int read = 0;
        StringBuilder lineContent = new StringBuilder();
        try {
            block34: while ((read = reader.read()) != -1) {
                char c = (char)read;
                if (c != '\n') {
                    lineContent.append(c);
                } else {
                    lineContent = new StringBuilder();
                }
                ++pos;
                if (this.holder.state == State.QUOTE) {
                    if (this.holder.quoteChar == c) {
                        this.holder.parent.value = this.holder.sb.toString();
                        this.holder = this.holder.parent;
                    } else {
                        this.holder.sb.append(c);
                    }
                    if (c != '\n') continue;
                    ++line;
                    pos = 0;
                    continue;
                }
                if (this.holder.state == State.COMMENT) {
                    if (c != '\n') continue;
                    this.holder = this.holder.parent;
                }
                switch (c) {
                    case '#': {
                        StateHolder tmp = new StateHolder();
                        tmp.state = State.COMMENT;
                        tmp.parent = this.holder;
                        this.holder = tmp;
                        continue block34;
                    }
                    case ':': 
                    case '=': {
                        if (this.holder.key != null) {
                            this.holder.sb.append(c);
                            continue block34;
                        }
                        this.holder.key = this.holder.value != null ? this.holder.value.toString() : this.holder.sb.toString().trim();
                        this.holder.value = null;
                        this.holder.sb = new StringBuilder();
                        continue block34;
                    }
                    case '[': {
                        StateHolder tmp = new StateHolder();
                        tmp.state = State.LIST;
                        tmp.parent = this.holder;
                        tmp.list = new ArrayList();
                        this.holder = tmp;
                        continue block34;
                    }
                    case ']': {
                        Object value;
                        Object value2;
                        if (this.holder.variable != null && this.holder.state != State.PROPERTY && this.holder.state != State.ENVIRONMENT) {
                            if (this.holder.variable instanceof CompositeVariable) {
                                value2 = this.holder.value;
                                if (value2 == null) {
                                    value2 = this.decodeValue(this.holder.sb.toString());
                                }
                                ((CompositeVariable)this.holder.variable).add(value2);
                            }
                            this.holder.value = this.holder.variable;
                            this.holder.variable = null;
                        }
                        Object val = this.holder.list;
                        if (this.holder.value == null) {
                            String valueStr = this.holder.sb.toString().trim();
                            if (!valueStr.isEmpty()) {
                                value = this.decodeValue(valueStr);
                                this.holder.list.add(value);
                            }
                        } else {
                            this.holder.list.add(this.holder.value);
                        }
                        this.holder = this.holder.parent;
                        this.holder.value = val;
                        continue block34;
                    }
                    case '\"': 
                    case '\'': {
                        StateHolder tmp = new StateHolder();
                        tmp.state = State.QUOTE;
                        tmp.parent = this.holder;
                        this.holder = tmp;
                        this.holder.quoteChar = c;
                        continue block34;
                    }
                    case '{': {
                        if (this.holder.key == null) {
                            this.holder.key = this.holder.value != null && this.holder.value instanceof String ? ((String)this.holder.value).trim() : this.holder.sb.toString().trim();
                        }
                        this.holder.sb = new StringBuilder();
                        StateHolder tmp = new StateHolder();
                        tmp.state = State.MAP;
                        tmp.parent = this.holder;
                        tmp.map = this.holder.value instanceof AbstractBeanConfigurator.BeanDefinition ? (Map)this.holder.value : new HashMap();
                        this.holder = tmp;
                        continue block34;
                    }
                    case '}': {
                        Object val = this.holder.map;
                        if (this.holder.parent == null) {
                            throw new java.lang.UnsupportedOperationException("Unexpected char: '}'");
                        }
                        this.holder = this.holder.parent;
                        this.holder.value = val;
                        continue block34;
                    }
                    case '(': {
                        String key = this.holder.value != null && this.holder.value instanceof String ? ((String)this.holder.value).trim() : this.holder.sb.toString().trim();
                        StateHolder tmp = new StateHolder();
                        switch (key) {
                            case "env": {
                                tmp.state = State.ENVIRONMENT;
                                tmp.variable = new EnvironmentVariable();
                                break;
                            }
                            case "prop": {
                                tmp.state = State.PROPERTY;
                                tmp.variable = new PropertyVariable();
                                break;
                            }
                            default: {
                                this.holder.key = key;
                                tmp.state = State.BEAN;
                                tmp.bean = new AbstractBeanConfigurator.BeanDefinition();
                                tmp.bean.setBeanName(this.holder.key);
                            }
                        }
                        tmp.parent = this.holder;
                        this.holder = tmp;
                        continue block34;
                    }
                    case ')': {
                        Object value;
                        Object val = null;
                        switch (this.holder.state) {
                            case ENVIRONMENT: 
                            case PROPERTY: {
                                AbstractEnvironmentPropertyVariable prop = (AbstractEnvironmentPropertyVariable)this.holder.variable;
                                value = this.holder.value.toString().trim();
                                if (prop.getName() == null) {
                                    prop.setName((String)value);
                                } else {
                                    prop.setDefValue((String)value);
                                }
                                val = this.holder.variable;
                                break;
                            }
                            case BEAN: {
                                val = this.holder.bean;
                                Object val1 = this.holder.value != null ? this.holder.value : this.decodeValue(this.holder.sb.toString().trim());
                                this.setBeanDefinitionValue(val1);
                                break;
                            }
                        }
                        this.holder = this.holder.parent;
                        this.holder.value = val;
                        continue block34;
                    }
                    case '\n': {
                        ++line;
                        pos = 0;
                    }
                    case ',': {
                        Object val;
                        Object value2;
                        if (this.holder.variable != null && this.holder.state != State.PROPERTY && this.holder.state != State.ENVIRONMENT) {
                            if (this.holder.variable instanceof CompositeVariable) {
                                value2 = this.holder.value;
                                if (value2 == null) {
                                    value2 = this.decodeValue(this.holder.sb.toString());
                                }
                                ((CompositeVariable)this.holder.variable).add(value2);
                            }
                            this.holder.value = this.holder.variable;
                            this.holder.variable = null;
                        }
                        switch (this.holder.state) {
                            case MAP: {
                                if (this.holder.key == null || this.holder.key.isEmpty()) break;
                                this.holder.map.put(this.holder.key, this.holder.value != null ? this.holder.value : this.decodeValue(this.holder.sb.toString().trim()));
                                break;
                            }
                            case LIST: {
                                if (this.holder.value == null) {
                                    String valueStr = this.holder.sb.toString().trim();
                                    if (valueStr.isEmpty()) break;
                                    Object value = this.decodeValue(valueStr);
                                    this.holder.list.add(value);
                                    break;
                                }
                                this.holder.list.add(this.holder.value);
                                break;
                            }
                            case BEAN: {
                                val = this.holder.value != null ? this.holder.value : this.decodeValue(this.holder.sb.toString().trim());
                                this.setBeanDefinitionValue(val);
                                break;
                            }
                            case ENVIRONMENT: 
                            case PROPERTY: {
                                ((AbstractEnvironmentPropertyVariable)this.holder.variable).setName(this.holder.value.toString().trim());
                                this.holder.value = this.holder.variable;
                                break;
                            }
                        }
                        this.holder.key = null;
                        this.holder.sb = new StringBuilder();
                        this.holder.value = null;
                        continue block34;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': {
                        CompositeVariable var;
                        Object value2;
                        if (this.holder.state == State.LIST) {
                            value2 = this.holder.value;
                            if (value2 == null) {
                                if (c == '-' && this.holder.sb.toString().trim().isEmpty()) {
                                    this.holder.sb.append(c);
                                    continue block34;
                                }
                                value2 = this.decodeValue(this.holder.sb.toString());
                            }
                            this.holder.value = null;
                            this.holder.sb = new StringBuilder();
                            if (this.holder.variable == null) {
                                var = new CompositeVariable();
                                this.holder.variable = var;
                            }
                            ((CompositeVariable)this.holder.variable).add(c, value2);
                            continue block34;
                        }
                        value2 = this.holder.value;
                        if (value2 == null) {
                            if (c == '-' && this.holder.sb.toString().trim().isEmpty()) {
                                this.holder.sb.append(c);
                                continue block34;
                            }
                            value2 = this.decodeValue(this.holder.sb.toString());
                        }
                        if (this.holder.key == null || value2 == null) break;
                        this.holder.value = null;
                        this.holder.sb = new StringBuilder();
                        if (this.holder.variable == null) {
                            var = new CompositeVariable();
                            this.holder.variable = var;
                        }
                        ((CompositeVariable)this.holder.variable).add(c, value2);
                        continue block34;
                    }
                }
                this.holder.sb.append(c);
            }
        }
        catch (java.lang.UnsupportedOperationException ex) {
            char c;
            while ((read = reader.read()) != -1 && (c = (char)read) != '\n') {
                lineContent.append(c);
            }
            throw new UnsupportedOperationException(ex.getMessage(), line, pos, lineContent.toString(), ex);
        }
        if (this.holder.state != State.MAP || this.holder.parent != null) {
            throw new InvalidFormatException("Parsing error - invalid file structure, state = " + this.holder.state + ", parent = " + this.holder.parent);
        }
        if (this.holder.key != null && !this.holder.key.isEmpty()) {
            this.holder.map.put(this.holder.key, this.holder.value != null ? this.holder.value : this.decodeValue(this.holder.sb.toString().trim()));
        }
        return this.holder.map;
    }

    public class StateHolder {
        public AbstractBeanConfigurator.BeanDefinition bean;
        public String key;
        public List list;
        public Map<String, Object> map;
        public StateHolder parent = null;
        public char quoteChar = (char)39;
        public StringBuilder sb = new StringBuilder();
        public State state = State.MAP;
        public Object value;
        public Variable variable;
    }

    public static class UnsupportedOperationException
    extends ConfigException {
        private final int line;
        private final String lineContent;
        private final int position;

        public UnsupportedOperationException(String msg, int line, int position, String lineContent, Throwable cause) {
            super(msg, cause);
            this.line = line;
            this.position = position;
            this.lineContent = lineContent;
        }

        public int getLine() {
            return this.line;
        }

        public int getPosition() {
            return this.position;
        }

        public String getLineContent() {
            return this.lineContent;
        }
    }

    public static class PropertyVariable
    extends AbstractEnvironmentPropertyVariable {
        public PropertyVariable() {
        }

        public PropertyVariable(String name, String defValue) {
            super(name, defValue);
        }

        @Override
        public Object calculateValue() {
            return System.getProperty(this.getName(), this.getDefValue());
        }
    }

    public static class InvalidFormatException
    extends ConfigException {
        public InvalidFormatException(String msg) {
            super(msg);
        }
    }

    public static class EnvironmentVariable
    extends AbstractEnvironmentPropertyVariable {
        public EnvironmentVariable() {
        }

        public EnvironmentVariable(String name, String defValue) {
            super(name, defValue);
        }

        @Override
        public Object calculateValue() {
            String val = System.getenv(this.getName());
            if (val == null) {
                val = this.getDefValue();
            }
            return val;
        }
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(String msg) {
            super(msg);
        }

        public ConfigException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class CompositeVariable
    implements Variable {
        private final List<Operation> operations = new ArrayList<Operation>();
        private final List<Object> values = new ArrayList<Object>();

        @Override
        public Object calculateValue() {
            if (this.values.isEmpty()) {
                return null;
            }
            List values = this.values.stream().map(val -> val instanceof Variable ? ((Variable)val).calculateValue() : val).collect(Collectors.toList());
            int j = 0;
            Object first = values.get(j);
            ++j;
            while (first == null && j < values.size()) {
                first = values.get(j);
                ++j;
            }
            if (first instanceof EnvironmentVariable || first instanceof PropertyVariable) {
                first = "String";
            } else if (first instanceof CompositeVariable) {
                first = this.calculateValue();
            }
            if (first instanceof String) {
                if (!this.operations.stream().allMatch(o -> o == Operation.add)) {
                    throw new java.lang.UnsupportedOperationException("Invalid operation for String!");
                }
                return values.stream().collect(Collectors.joining());
            }
            if (first instanceof Number) {
                ArrayList<Operation> operations = new ArrayList<Operation>(this.operations);
                for (Operation operation : Operation.values()) {
                    Iterator it = operations.iterator();
                    int pos = 0;
                    while (it.hasNext()) {
                        Operation o2 = (Operation)((Object)it.next());
                        if (!operation.equals((Object)o2)) {
                            ++pos;
                            continue;
                        }
                        Number arg1 = (Number)values.remove(pos);
                        Number arg2 = (Number)values.remove(pos);
                        Number result = operation.execute(arg1, arg2);
                        values.add(pos, result);
                        it.remove();
                    }
                }
                if (values.size() > 1) {
                    throw new RuntimeException("Variable calculation exception");
                }
                return values.stream().findFirst().get();
            }
            throw new java.lang.UnsupportedOperationException("Cannot calculate composite variable!");
        }

        public void add(Object value) {
            this.values.add(value);
        }

        public void add(char operation, Object value) {
            Operation o = null;
            switch (operation) {
                case '+': {
                    o = Operation.add;
                    break;
                }
                case '-': {
                    o = Operation.substract;
                    break;
                }
                case '*': {
                    o = Operation.multiply;
                    break;
                }
                case '/': {
                    o = Operation.divide;
                    break;
                }
                default: {
                    throw new java.lang.UnsupportedOperationException();
                }
            }
            if (value instanceof String && o != Operation.add) {
                throw new java.lang.UnsupportedOperationException("Cannot " + o.name() + " a String");
            }
            this.operations.add(o);
            this.values.add(value);
        }

        public List<Object> getArguments() {
            return this.values;
        }

        public List<Operation> getOperations() {
            return this.operations;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompositeVariable) {
                int i;
                CompositeVariable v = (CompositeVariable)obj;
                if (v.values.size() != this.values.size()) {
                    return false;
                }
                if (v.operations.size() != this.operations.size()) {
                    return false;
                }
                for (i = 0; i < this.values.size(); ++i) {
                    if (this.values.get(i).equals(v.values.get(i))) continue;
                    return false;
                }
                for (i = 0; i < this.operations.size(); ++i) {
                    if (this.operations.get(i).equals((Object)v.operations.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static enum Operation {
            multiply,
            divide,
            add,
            substract;


            public Number execute(Number arg1, Number arg2) {
                if (arg1 instanceof Double || arg2 instanceof Double) {
                    double a1 = arg1.doubleValue();
                    double a2 = arg2.doubleValue();
                    switch (this) {
                        case multiply: {
                            return a1 * a2;
                        }
                        case divide: {
                            return a1 / a2;
                        }
                        case add: {
                            return a1 + a2;
                        }
                        case substract: {
                            return a1 - a2;
                        }
                    }
                } else if (arg1 instanceof Float || arg2 instanceof Float) {
                    float a1 = arg1.floatValue();
                    float a2 = arg2.floatValue();
                    switch (this) {
                        case multiply: {
                            return Float.valueOf(a1 * a2);
                        }
                        case divide: {
                            return Float.valueOf(a1 / a2);
                        }
                        case add: {
                            return Float.valueOf(a1 + a2);
                        }
                        case substract: {
                            return Float.valueOf(a1 - a2);
                        }
                    }
                } else if (arg1 instanceof Long || arg2 instanceof Long) {
                    long a1 = arg1.longValue();
                    long a2 = arg2.longValue();
                    switch (this) {
                        case multiply: {
                            return a1 * a2;
                        }
                        case divide: {
                            return a1 / a2;
                        }
                        case add: {
                            return a1 + a2;
                        }
                        case substract: {
                            return a1 - a2;
                        }
                    }
                } else if (arg1 instanceof Integer || arg2 instanceof Integer) {
                    int a1 = arg1.intValue();
                    int a2 = arg2.intValue();
                    switch (this) {
                        case multiply: {
                            return a1 * a2;
                        }
                        case divide: {
                            return a1 / a2;
                        }
                        case add: {
                            return a1 + a2;
                        }
                        case substract: {
                            return a1 - a2;
                        }
                    }
                }
                throw new RuntimeException("Invalid argument exception");
            }
        }
    }

    public static abstract class AbstractEnvironmentPropertyVariable
    implements Variable {
        private String defValue;
        private String name;

        protected AbstractEnvironmentPropertyVariable() {
        }

        protected AbstractEnvironmentPropertyVariable(String name, String defValue) {
            this.setName(name);
            this.setDefValue(defValue);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AbstractEnvironmentPropertyVariable) {
                AbstractEnvironmentPropertyVariable v = (AbstractEnvironmentPropertyVariable)obj;
                if ((v.name == this.name || v.name != null && v.name.equals(this.name)) && (v.defValue == this.defValue || v.defValue != null && v.defValue.equals(this.defValue))) {
                    return true;
                }
            }
            return false;
        }

        protected String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected String getDefValue() {
            return this.defValue;
        }

        protected void setDefValue(String defValue) {
            this.defValue = defValue;
        }
    }

    public static interface Variable {
        public Object calculateValue();
    }

    public static enum State {
        MAP,
        QUOTE,
        LIST,
        COMMENT,
        BEAN,
        ENVIRONMENT,
        PROPERTY;

    }
}

