/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.SSL3Constants;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Arrays;

public class CombinedHash
implements TlsHash {
    protected TlsContext context;
    protected TlsCrypto crypto;
    protected TlsHash md5;
    protected TlsHash sha1;

    CombinedHash(TlsContext tlsContext, TlsHash tlsHash, TlsHash tlsHash2) {
        this.context = tlsContext;
        this.crypto = tlsContext.getCrypto();
        this.md5 = tlsHash;
        this.sha1 = tlsHash2;
    }

    public CombinedHash(TlsCrypto tlsCrypto) {
        this.crypto = tlsCrypto;
        this.md5 = tlsCrypto.createHash((short)1);
        this.sha1 = tlsCrypto.createHash((short)2);
    }

    public CombinedHash(CombinedHash combinedHash) {
        this.context = combinedHash.context;
        this.crypto = combinedHash.crypto;
        this.md5 = (TlsHash)combinedHash.md5.clone();
        this.sha1 = (TlsHash)combinedHash.sha1.clone();
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md5.update(byArray, n, n2);
        this.sha1.update(byArray, n, n2);
    }

    public byte[] calculateHash() {
        if (this.context != null && TlsUtils.isSSL(this.context)) {
            byte[] byArray = SSL3Constants.getInputPad();
            byte[] byArray2 = SSL3Constants.getOutputPad();
            this.ssl3Complete(this.md5, byArray, byArray2, 48);
            this.ssl3Complete(this.sha1, byArray, byArray2, 40);
        }
        return Arrays.concatenate((byte[])this.md5.calculateHash(), (byte[])this.sha1.calculateHash());
    }

    public Object clone() {
        return new CombinedHash(this);
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }

    protected void ssl3Complete(TlsHash tlsHash, byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = this.crypto.adoptSecret(this.context.getSecurityParameters().getMasterSecret()).extract();
        tlsHash.update(byArray3, 0, byArray3.length);
        tlsHash.update(byArray, 0, n);
        byte[] byArray4 = tlsHash.calculateHash();
        tlsHash.update(byArray3, 0, byArray3.length);
        tlsHash.update(byArray2, 0, n);
        tlsHash.update(byArray4, 0, byArray4.length);
    }
}

