/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import groovy.lang.Closure;
import java.util.Optional;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.ClosureCallback;
import tigase.http.PacketWriter;
import tigase.http.api.Service;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.Module;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

public class ServiceImpl<T extends Module>
implements Service<T>,
tigase.http.rest.Service<T> {
    private final T module;

    public ServiceImpl(String moduleUUID) {
        this(AbstractBareModule.getModuleByUUID(moduleUUID));
    }

    public ServiceImpl(T module) {
        this.module = module;
    }

    @Override
    public void sendPacket(Packet packet, Long timeout, PacketWriter.Callback closure) {
        if (closure != null) {
            this.module.addOutPacket(packet, timeout == null ? null : Integer.valueOf(timeout.intValue()), closure);
        } else {
            this.module.addOutPacket(packet);
        }
    }

    @Override
    public void sendPacket(Packet packet, Long timeout, Closure closure) {
        if (closure != null) {
            this.module.addOutPacket(packet, timeout == null ? null : Integer.valueOf(timeout.intValue()), new ClosureCallback(closure));
        } else {
            this.module.addOutPacket(packet);
        }
    }

    @Override
    public UserRepository getUserRepository() {
        return this.module.getUserRepository();
    }

    @Override
    public AuthRepository getAuthRepository() {
        return this.module.getAuthRepository();
    }

    @Override
    public boolean isAdmin(BareJID user) {
        return this.module.isAdmin(user);
    }

    @Override
    public boolean isAllowed(String key, String domain, String path) {
        return this.module.isRequestAllowed(key, domain, path);
    }

    @Override
    public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException, AuthorizationException {
        BareJID jid = BareJID.bareJIDInstance((String)user);
        Credentials credentials = this.module.getAuthRepository().getCredentials(jid, "default");
        if (credentials == null) {
            return false;
        }
        return Optional.ofNullable(credentials.getFirst()).map(e -> e.verifyPlainPassword(password)).orElse(false);
    }

    @Override
    public T getModule() {
        return this.module;
    }
}

