/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Map;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixLogic;
import tigase.mix.modules.RoomPresenceModule;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.ISubscriptions;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="channelLeaveModule", parent=IMixComponent.class, active=true)
public class ChannelLeaveModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_LEAVE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"leave", (String)"urn:xmpp:mix:core:1"));
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;
    @Inject(nullAllowed=true)
    private RoomPresenceModule roomPresenceModule;

    public Criteria getModuleCriteria() {
        return CRIT_LEAVE;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            if (packet.getStanzaTo().getLocalpart() == null) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            BareJID channelJID = packet.getStanzaTo().getBareJID();
            BareJID senderJID = packet.getStanzaFrom().getBareJID();
            Map userSubscriptions = this.getRepository().getUserSubscriptions(channelJID, senderJID);
            for (String node : userSubscriptions.keySet()) {
                ISubscriptions subscriptions = this.getRepository().getNodeSubscriptions(channelJID, node);
                subscriptions.changeSubscription(senderJID, Subscription.none);
                this.getRepository().update(channelJID, node, subscriptions);
            }
            IParticipant participant = this.roomPresenceModule != null ? this.mixRepository.getParticipant(channelJID, senderJID) : null;
            this.mixRepository.removeParticiapnt(channelJID, senderJID);
            this.packetWriter.write(packet.okResult((Element)null, 1));
            if (this.roomPresenceModule != null && participant != null) {
                this.roomPresenceModule.participantLeft(channelJID, null, participant.getNick());
            }
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

