/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.operation.BaseWriteOperation;
import com.mongodb.operation.OperationHelper;
import java.util.List;

public class DeleteOperation
extends BaseWriteOperation {
    private final List<DeleteRequest> deleteRequests;

    public DeleteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deleteRequests) {
        super(namespace, ordered, writeConcern);
        this.deleteRequests = Assertions.notNull("removes", deleteRequests);
        Assertions.isTrueArgument("deleteRequests not empty", !deleteRequests.isEmpty());
    }

    public List<DeleteRequest> getDeleteRequests() {
        return this.deleteRequests;
    }

    @Override
    protected WriteConcernResult executeProtocol(Connection connection) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern());
        return connection.delete(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests);
    }

    @Override
    protected void executeProtocolAsync(AsyncConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern(), new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.deleteAsync(DeleteOperation.this.getNamespace(), DeleteOperation.this.isOrdered(), DeleteOperation.this.getWriteConcern(), DeleteOperation.this.deleteRequests, callback);
                }
            }
        });
    }

    @Override
    protected BulkWriteResult executeCommandProtocol(Connection connection) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern());
        return connection.deleteCommand(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests);
    }

    @Override
    protected void executeCommandProtocolAsync(AsyncConnection connection, final SingleResultCallback<BulkWriteResult> callback) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern(), new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.deleteCommandAsync(DeleteOperation.this.getNamespace(), DeleteOperation.this.isOrdered(), DeleteOperation.this.getWriteConcern(), DeleteOperation.this.deleteRequests, callback);
                }
            }
        });
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.DELETE;
    }

    @Override
    protected int getCount(BulkWriteResult bulkWriteResult) {
        return bulkWriteResult.getDeletedCount();
    }
}

