/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Date;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.DataSource;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.HistoryProvider;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;
import tigase.xmpp.rsm.RSM;

public abstract class AbstractHistoryProvider<DS extends DataSource>
implements HistoryProvider<DS> {
    protected static final SimpleParser parser = SingletonFactory.getParserInstance();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final TimestampHelper timestampHelper = new TimestampHelper();

    protected static <Q extends Query> void calculateOffsetAndPosition(Q query, int count, Integer before, Integer after) {
        RSM rsm = query.getRsm();
        int index = rsm.getIndex() == null ? 0 : rsm.getIndex();
        int limit = rsm.getMax();
        if (after != null) {
            index = after + 1;
        } else if (before != null) {
            index = before - rsm.getMax();
            if (index < 0) {
                index = 0;
                limit = before;
            }
        } else if (rsm.hasBefore() && (index = count - rsm.getMax()) < 0) {
            index = 0;
        }
        rsm.setIndex(Integer.valueOf(index));
        rsm.setMax(limit);
        rsm.setCount(Integer.valueOf(count));
    }

    public Packet createMessage(BareJID roomJID, JID senderJID, String msgSenderNickname, String originalMessage, String body, String msgSenderJid, boolean addRealJids, Date msgTimestamp) throws TigaseStringprepException {
        Packet message = Packet.packetInstance((Element)this.createMessageElement(roomJID, senderJID, msgSenderNickname, originalMessage, body));
        Element delay = new Element("delay", new String[]{"xmlns", "from", "stamp"}, new String[]{"urn:xmpp:delay", roomJID.toString(), this.timestampHelper.formatWithMs(msgTimestamp)});
        message.getElement().addChild((XMLNodeIfc)delay);
        return message;
    }

    public Element createMessageElement(BareJID roomJID, JID senderJID, String msgSenderNickname, String originalMessage, String body) throws TigaseStringprepException {
        Element message = null;
        if (originalMessage != null) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, originalMessage.toCharArray(), 0, originalMessage.length());
            Queue queue = domHandler.getParsedElements();
            message = (Element)queue.poll();
            if (message != null) {
                message.setAttribute("type", "groupchat");
                message.setAttribute("from", JID.jidInstance((BareJID)roomJID, (String)msgSenderNickname).toString());
                message.setAttribute("to", senderJID.toString());
                message.setXMLNS("jabber:client");
            }
        }
        if (message == null) {
            message = new Element("message", new String[]{"type", "from", "to", "xmlns"}, new String[]{"groupchat", JID.jidInstance((BareJID)roomJID, (String)msgSenderNickname).toString(), senderJID.toString(), "jabber:client"});
            message.addChild((XMLNodeIfc)new Element("body", body));
        }
        return message;
    }

    protected boolean isAllowedToSeeJIDs(BareJID jid, Room room) {
        Affiliation aff = room.getAffiliation(jid).getAffiliation();
        RoomConfig.WhoisPrivilege whois = room.getConfig().getWhois();
        if (whois == RoomConfig.WhoisPrivilege.anyone) {
            return true;
        }
        return aff.isViewOccupantsJid();
    }
}

