/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.RegistrarBeanWithDefaultBeanClass;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.IOServiceListener;
import tigase.net.SocketThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.socks5.ServiceChecker;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;

public abstract class AbstractConnectionManager<IO extends IOService<?>>
extends AbstractMessageReceiver
implements IOServiceListener<IO>,
RegistrarBean {
    protected static final int NET_BUFFER_HT_PROP_VAL = 65536;
    protected static final int NET_BUFFER_ST_PROP_VAL = 2048;
    protected static final String PORT_CLASS_PROP_KEY = "class";
    protected static final String PORT_IFC_PROP_KEY = "ifc";
    protected static final String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    protected static final String PORT_KEY = "port-no";
    protected static final String PORT_SOCKET_PROP_KEY = "socket";
    protected static final String PORT_TYPE_PROP_KEY = "type";
    protected static final String PROP_KEY = "connections/";
    protected static final String PORTS_PROP_KEY = "connections/ports";
    private static final Logger log = Logger.getLogger(AbstractConnectionManager.class.getCanonicalName());
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    @ConfigField(desc="Size of a network buffer", alias="net-buffer")
    protected int net_buffer = 2048;
    protected Map<String, IO> services = new ConcurrentHashMap<String, IO>();
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private boolean initializationCompleted = false;
    private IOServiceStatisticsGetter ioStatsGetter = new IOServiceStatisticsGetter();
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    @Inject
    private PortsConfigBean portsConfigBean = null;
    private long socketOverflow = 0L;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();

    public synchronized void everyMinute() {
        this.doForAllServices(this.ioStatsGetter);
        super.everyMinute();
    }

    public void initializationCompleted() {
        this.initializationCompleted = true;
        super.initializationCompleted();
    }

    public void serviceStarted(IO serv) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connection {0} started", serv.getUniqueId());
        }
        serv.setIOServiceListener((IOServiceListener)this);
        this.services.put(serv.getUniqueId(), serv);
    }

    public boolean serviceStopped(IO serv) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "connection {0} stopped", serv.getUniqueId());
        }
        this.services.remove(serv.getUniqueId());
        return true;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Open connections", this.services.size(), Level.INFO);
        if (list.checkLevel(Level.FINEST) || this.services.size() < 1000) {
            int waitingToSendSize = 0;
            for (IOService serv : this.services.values()) {
                waitingToSendSize += serv.waitingToSendSize();
            }
            list.add(this.getName(), "Waiting to send", waitingToSendSize, Level.FINE);
        }
        list.add(this.getName(), "Bytes sent", this.bytesSent, Level.FINE);
        list.add(this.getName(), "Bytes received", this.bytesReceived, Level.FINE);
        list.add(this.getName(), "Socket overflow", this.socketOverflow, Level.FINE);
    }

    public void register(Kernel kernel) {
    }

    public void start() {
        super.start();
        this.connectWaitingTasks();
    }

    public void stop() {
        this.portsConfigBean.stop();
        super.stop();
    }

    public void unregister(Kernel kernel) {
    }

    protected void connectWaitingTasks() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Connecting waitingTasks: {0}", new Object[]{this.waitingTasks});
        }
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, 2000L);
        }
        this.waitingTasks.clear();
        this.portsConfigBean.start();
    }

    protected void doForAllServices(ServiceChecker<IO> checker) {
        for (IOService service : this.services.values()) {
            checker.check(service);
        }
    }

    protected abstract int[] getDefaultPorts();

    protected abstract IO getIOServiceInstance() throws IOException;

    protected int[] getPorts() {
        Set<Integer> ports = this.portsConfigBean.getPorts();
        if (ports == null) {
            return new int[0];
        }
        return ports.stream().mapToInt(i -> i).toArray();
    }

    protected boolean isHighThroughput() {
        return false;
    }

    protected void releaseListener(ConnectionOpenListener toStop) {
        this.pending_open.remove(toStop);
        connectThread.removeConnectionOpenListener(toStop);
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        if (log.isLoggable(Level.FINER)) {
            String cid = "" + port_props.get("local-hostname") + "@" + port_props.get("remote-hostname");
            log.log(Level.FINER, "Reconnecting service for: {0}, scheduling next try in {1}secs, cid: {2}", new Object[]{this.getName(), delay / 1000L, cid});
        }
        this.addTimerTask(new TimerTask(){

            public void run() {
                int port = (Integer)port_props.get(AbstractConnectionManager.PORT_KEY);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Reconnecting service for component: {0}, on port: {1}", new Object[]{AbstractConnectionManager.this.getName(), port});
                }
                AbstractConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener((ConnectionOpenListener)cli);
        }
        this.pending_open.clear();
    }

    private ConnectionListenerImpl startService(Map<String, Object> port_props) {
        if (port_props == null) {
            throw new NullPointerException("port_props cannot be null.");
        }
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener((ConnectionOpenListener)cli);
        return cli;
    }

    private class IOServiceStatisticsGetter
    implements ServiceChecker<IO> {
        private StatisticsList list = new StatisticsList(Level.ALL);

        private IOServiceStatisticsGetter() {
        }

        @Override
        public synchronized void check(IO service) {
            service.getStatistics(this.list, true);
            AbstractConnectionManager.this.bytesReceived = AbstractConnectionManager.this.bytesReceived + this.list.getValue("socketio", "Bytes received", -1L);
            AbstractConnectionManager.this.bytesSent = AbstractConnectionManager.this.bytesSent + this.list.getValue("socketio", "Bytes sent", -1L);
            AbstractConnectionManager.this.socketOverflow = AbstractConnectionManager.this.socketOverflow + this.list.getValue("socketio", "Buffers overflow", -1L);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        public ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        public void accept(SocketChannel sc) {
            block2: {
                IOService conn = null;
                try {
                    conn = (IOService)AbstractConnectionManager.this.getIOServiceInstance();
                    conn.setIOServiceListener(null);
                    conn.accept(sc);
                    AbstractConnectionManager.this.serviceStarted(conn);
                    SocketThread.addSocketService(conn);
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Can not accept connection.", ex);
                    if (conn == null) break block2;
                    conn.stop();
                }
            }
        }

        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(AbstractConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(AbstractConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(AbstractConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(AbstractConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf((String)type);
        }

        public String[] getIfcs() {
            return (String[])this.port_props.get(AbstractConnectionManager.PORT_IFC_PROP_KEY);
        }

        public int getPort() {
            return (Integer)this.port_props.get(AbstractConnectionManager.PORT_KEY);
        }

        public int getReceiveBufferSize() {
            return AbstractConnectionManager.this.net_buffer;
        }

        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.port_props.get("remote-address");
        }

        public String getRemoteHostname() {
            return (String)this.port_props.get("remote-hostname");
        }

        public SocketType getSocketType() {
            return SocketType.valueOf((String)this.port_props.get(AbstractConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        public String getSRVType() {
            return "_socks5._tcp";
        }

        public int getTrafficClass() {
            if (AbstractConnectionManager.this.isHighThroughput()) {
                return 8;
            }
            return 2;
        }
    }

    @Bean(name="connections", parent=AbstractConnectionManager.class, active=true, exportable=true)
    public static class PortsConfigBean
    implements RegistrarBeanWithDefaultBeanClass,
    Initializable {
        @Inject
        private AbstractConnectionManager connectionManager;
        private Kernel kernel;
        @ConfigField(desc="Ports to enable", alias="ports")
        private HashSet<Integer> ports;
        @Inject(nullAllowed=true)
        private PortConfigBean[] portsBeans;

        public Class<?> getDefaultBeanClass() {
            return PortConfigBean.class;
        }

        public Set<Integer> getPorts() {
            return this.ports;
        }

        public void register(Kernel kernel) {
            this.kernel = kernel;
            if (kernel.getParent() != null) {
                String connManagerBean = kernel.getParent().getName();
                this.kernel.getParent().ln("service", kernel, connManagerBean);
            }
        }

        public void unregister(Kernel kernel) {
            this.kernel = null;
        }

        public void initialize() {
            int[] tmp;
            if (this.ports == null && (tmp = this.connectionManager.getDefaultPorts()) != null) {
                this.ports = new HashSet();
                for (int i = 0; i < tmp.length; ++i) {
                    this.ports.add(tmp[i]);
                }
            }
            for (Integer port : this.ports) {
                String name = String.valueOf(port);
                if (this.kernel.getDependencyManager().getBeanConfig(name) != null) continue;
                Class<?> cls = this.getDefaultBeanClass();
                this.kernel.registerBean(name).asClass(cls).exec();
            }
        }

        public void start() {
            if (this.portsBeans != null) {
                Arrays.stream(this.portsBeans).forEach(portBean -> portBean.initialize());
            }
        }

        public void stop() {
        }
    }

    public static class PortConfigBean
    implements ConfigurationChangedAware,
    Initializable,
    UnregisterAware {
        @ConfigField(desc="Interface to listen on")
        protected String[] ifc = null;
        @ConfigField(desc="Socket type")
        protected SocketType socket = SocketType.plain;
        @ConfigField(desc="Port type")
        protected ConnectionType type = ConnectionType.accept;
        @Inject
        private AbstractConnectionManager connectionManager;
        private ConnectionOpenListener connectionOpenListener = null;
        @ConfigField(desc="Port")
        private Integer name;

        public void beanConfigurationChanged(Collection<String> changedFields) {
            if (this.connectionManager == null || !this.connectionManager.isInitializationComplete()) {
                return;
            }
            if (this.connectionOpenListener != null) {
                this.connectionManager.releaseListener(this.connectionOpenListener);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "connectionManager: {0}, changedFields: {1}, props: {2}", new Object[]{this.connectionManager, changedFields, this.getProps()});
            }
            this.connectionOpenListener = this.connectionManager.startService(this.getProps());
        }

        public void beforeUnregister() {
            if (this.connectionOpenListener != null) {
                this.connectionManager.releaseListener(this.connectionOpenListener);
            }
        }

        public void initialize() {
            this.beanConfigurationChanged(Collections.emptyList());
        }

        protected Map<String, Object> getProps() {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(AbstractConnectionManager.PORT_KEY, this.name);
            props.put(AbstractConnectionManager.PORT_TYPE_PROP_KEY, this.type);
            props.put(AbstractConnectionManager.PORT_SOCKET_PROP_KEY, this.socket);
            if (this.ifc == null) {
                props.put(AbstractConnectionManager.PORT_IFC_PROP_KEY, PORT_IFC_PROP_VAL);
            } else {
                props.put(AbstractConnectionManager.PORT_IFC_PROP_KEY, this.ifc);
            }
            return props;
        }
    }
}

