/*
 * Decompiled with CFR 0.152.
 */
package tigase.management;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.snmp.IPAcl.JdmkAcl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibAgent;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import tigase.conf.MonitoringBeanIfc;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;

@Bean(name="monitoring", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class MonitoringBean
implements MonitoringBeanIfc,
RegistrarBean {
    @Inject(nullAllowed=true)
    private MonitorBean[] monitors;

    public void register(Kernel kernel) {
    }

    public void unregister(Kernel kernel) {
    }

    @Bean(name="snmp", parent=MonitoringBean.class, active=false)
    public static class SnmpMonitor
    extends MonitorBeanAbstract {
        private static final Logger log = Logger.getLogger(SnmpMonitor.class.getCanonicalName());
        private SnmpMib mib = null;
        private ObjectName mibObjName;
        private ObjectName snmpName;
        private SnmpAdaptorServer snmpadaptor = null;

        @Override
        public void start() throws Exception {
            log.config("Loading SNMP monitor.");
            this.snmpName = new ObjectName("localhost:class=SnmpAdaptorServer,protocol=snmp,port=" + this.port);
            JdmkAcl acl = new JdmkAcl("tigase", this.configDir + File.separator + "snmp.acl");
            this.snmpadaptor = new SnmpAdaptorServer((InetAddressAcl)acl, this.port);
            this.server.registerMBean(this.snmpadaptor, this.snmpName);
            this.snmpadaptor.start();
            String className = "tigase.management.TIGASE_MANAGEMENT_MIB";
            String objName = "snmp:class=TIGASE_MANAGEMENT_MIB";
            log.config("Initializing Tiase MIB MXBean");
            this.mibObjName = new ObjectName(objName);
            this.mib = (SnmpMib)Class.forName(className).newInstance();
            this.server.registerMBean(this.mib, this.mibObjName);
            this.snmpadaptor.addMib((SnmpMibAgent)this.mib);
        }

        @Override
        public void stop() throws Exception {
            if (this.snmpadaptor != null) {
                this.snmpadaptor.stop();
            }
            if (this.mibObjName != null) {
                this.server.unregisterMBean(this.mibObjName);
            }
            if (this.snmpName != null) {
                this.server.unregisterMBean(this.snmpName);
            }
        }
    }

    public static abstract class MonitorBeanAbstract
    implements MonitorBean {
        private static final Logger log = Logger.getLogger(MonitorBeanAbstract.class.getCanonicalName());
        @ConfigField(desc="Config directory", alias="configDir")
        protected String configDir = "etc";
        @ConfigField(desc="Port for monitor")
        protected int port;
        protected MBeanServer server = ManagementFactory.getPlatformMBeanServer();

        public void beforeUnregister() {
            try {
                this.stop();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Cound not stop monitor: " + this.getClass().getCanonicalName(), ex);
            }
        }

        public void initialize() {
            try {
                this.start();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Cound not start monitor: " + this.getClass().getCanonicalName(), ex);
                this.beforeUnregister();
            }
        }
    }

    @Bean(name="jmx", parent=MonitoringBean.class, active=false)
    public static class JMXMonitor
    extends MonitorBeanAbstract {
        private static final Logger log = Logger.getLogger(JMXMonitor.class.getCanonicalName());
        private JMXConnectorServer connector;
        private ObjectName objectName;

        @Override
        public void start() throws Exception {
            log.config("Loading JMX monitor.");
            this.objectName = new ObjectName("system:name=rmiconnector");
            LocateRegistry.createRegistry(this.port);
            String serviceURL = "service:jmx:rmi://localhost:" + this.port + "/jndi/rmi://localhost:" + this.port + "/jmxrmi";
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            map.put("jmx.remote.jndi.rebind", "true");
            map.put("jmx.remote.x.password.file", this.configDir + File.separator + "jmx.password");
            map.put("jmx.remote.x.access.file", this.configDir + File.separator + "jmx.access");
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(serviceURL), map, this.server);
            this.server.registerMBean(this.connector, this.objectName);
            this.connector.start();
        }

        @Override
        public void stop() throws Exception {
            if (this.connector != null) {
                this.connector.stop();
            }
            if (this.objectName != null) {
                this.server.unregisterMBean(this.objectName);
            }
        }
    }

    @Bean(name="http", parent=MonitoringBean.class, active=false)
    public static class HttpMonitor
    extends MonitorBeanAbstract {
        private static final Logger log = Logger.getLogger(HttpMonitor.class.getCanonicalName());
        private HtmlAdaptorServer adaptor;
        private ObjectName httpName;

        @Override
        public void start() throws Exception {
            log.config("Loading HTTP monitor.");
            this.adaptor = new HtmlAdaptorServer();
            this.httpName = new ObjectName("localhost:class=HtmlAdaptorServer,protocol=html,port=" + this.port);
            this.server.registerMBean(this.adaptor, this.httpName);
            this.adaptor.setPort(this.port);
            this.adaptor.start();
        }

        @Override
        public void stop() throws Exception {
            if (this.adaptor != null) {
                this.adaptor.stop();
            }
            if (this.httpName != null) {
                this.server.unregisterMBean(this.httpName);
            }
        }
    }

    public static interface MonitorBean
    extends UnregisterAware,
    Initializable {
        public void stop() throws Exception;

        public void start() throws Exception;
    }
}

