/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.archive;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import tigase.archive.QueryCriteria;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.xep0136.Query;
import tigase.component.exceptions.ComponentException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.util.Version;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.rsm.RSM;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="message-archiving", name="Tigase Message Archiving Component", external=false)
@RepositoryVersionAware.SchemaVersion
public class MongoMessageArchiveRepository
extends AbstractMessageArchiveRepository<QueryCriteria, MongoDataSource, MongoDBAddMessageAdditionalDataProvider>
implements MongoRepositoryVersionAware {
    private static final Logger log = Logger.getLogger(MongoMessageArchiveRepository.class.getCanonicalName());
    private static final int DEF_BATCH_SIZE = 100;
    private static final String HASH_ALG = "SHA-256";
    private static final String[] MSG_BODY_PATH = new String[]{"message", "body"};
    private static final String MSGS_COLLECTION = "tig_ma_msgs";
    private static final String STORE_PLAINTEXT_BODY_KEY = "store-plaintext-body";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoDatabase db;
    private MongoCollection<Document> msgsCollection;
    @ConfigField(desc="Store plaintext body in database", alias="store-plaintext-body")
    private boolean storePlaintextBody = true;

    private static byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    private static byte[] generateId(BareJID user) throws TigaseDBException {
        return MongoMessageArchiveRepository.calculateHash(user.toString().toLowerCase());
    }

    protected void archiveMessage(BareJID ownerJid, BareJID buddyJid, Date timestamp, Element msg, String stableIdStr, String stanzaId, String refStableId, Set<String> tags, MongoDBAddMessageAdditionalDataProvider additionParametersProvider) {
        try {
            String body;
            byte[] oid = MongoMessageArchiveRepository.generateId(ownerJid);
            byte[] bid = MongoMessageArchiveRepository.generateId(buddyJid);
            byte[] odid = MongoMessageArchiveRepository.calculateHash(ownerJid.getDomain());
            String type = msg.getAttributeStaticStr("type");
            Date date = new Date(timestamp.getTime() - timestamp.getTime() % 86400000L);
            UUID stableId = UUID.fromString(stableIdStr);
            Document crit = new Document("owner_id", (Object)oid).append("stable_id", (Object)stableId);
            Document dto = new Document("owner", (Object)ownerJid.toString()).append("owner_id", (Object)oid).append("owner_domain_id", (Object)odid).append("stable_id", (Object)stableId).append("buddy", (Object)buddyJid.toString()).append("buddy_id", (Object)bid).append("date", (Object)date).append("ts", (Object)timestamp).append("msg", (Object)msg.toString());
            if (stableId != null) {
                dto.append("stanza_id", (Object)stableId);
            }
            if (refStableId != null) {
                dto.append("ref_stable_id", (Object)refStableId);
            }
            if (this.storePlaintextBody && (body = msg.getChildCData(MSG_BODY_PATH)) != null) {
                dto.append("body", (Object)body);
            }
            if (tags != null && !tags.isEmpty()) {
                dto.append("tags", new ArrayList<String>(tags));
            }
            this.msgsCollection.updateOne((Bson)crit, (Bson)new Document("$set", (Object)dto), new UpdateOptions().upsert(true));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: " + msg, ex);
        }
    }

    public Document createCriteriaDocument(QueryCriteria query) throws TigaseDBException {
        BareJID owner = query.getQuestionerJID().getBareJID();
        byte[] oid = MongoMessageArchiveRepository.generateId(owner);
        Document crit = new Document("owner_id", (Object)oid);
        if (query.getWith() != null) {
            byte[] wid = MongoMessageArchiveRepository.generateId(query.getWith().getBareJID());
            crit.append("buddy_id", (Object)wid);
        }
        Document dateCrit = null;
        if (query.getStart() != null) {
            if (dateCrit == null) {
                dateCrit = new Document();
            }
            dateCrit.append("$gte", (Object)query.getStart());
        }
        if (query.getEnd() != null) {
            if (dateCrit == null) {
                dateCrit = new Document();
            }
            dateCrit.append("$lte", (Object)query.getEnd());
        }
        if (dateCrit != null) {
            crit.append("ts", (Object)dateCrit);
        }
        if (!query.getTags().isEmpty()) {
            crit.append("tags", (Object)new Document("$all", new ArrayList(query.getTags())));
        }
        if (!query.getContains().isEmpty()) {
            StringBuilder containsSb = new StringBuilder();
            for (String contains : query.getContains()) {
                if (containsSb.length() > 0) {
                    containsSb.append(" ");
                }
                if (contains.contains(" ")) {
                    containsSb.append("\"");
                    containsSb.append(contains);
                    containsSb.append("\"");
                    continue;
                }
                containsSb.append(contains);
            }
            crit.append("$text", (Object)new Document("$search", (Object)containsSb.toString()));
        }
        return crit;
    }

    public void archiveMessage(BareJID owner, JID buddy, Date timestamp, Element msg, String stableId, Set tags) {
        super.archiveMessage(owner, buddy.getBareJID(), timestamp, msg, stableId, tags, null);
    }

    public void deleteExpiredMessages(BareJID owner, LocalDateTime before) throws TigaseDBException {
        try {
            byte[] odid = MongoMessageArchiveRepository.calculateHash(owner.getDomain());
            long timestamp_long = before.toEpochSecond(ZoneOffset.UTC) * 1000L;
            Document crit = new Document("owner_domain_id", (Object)odid).append("ts", (Object)new Document("$lt", (Object)new Date(timestamp_long)));
            this.msgsCollection.deleteMany((Bson)crit);
        }
        catch (Exception ex) {
            throw new TigaseDBException("Cound not remove expired messages", (Throwable)ex);
        }
    }

    public String getStableId(BareJID owner, BareJID buddy, String stanzaId) throws TigaseDBException {
        return null;
    }

    private Integer getColletionPosition(String uid) {
        if (uid == null || uid.isEmpty()) {
            return null;
        }
        return Integer.parseInt(uid);
    }

    private Integer getItemPosition(String uid, QueryCriteria query, Document crit) throws TigaseDBException, ComponentException {
        if (uid == null || uid.isEmpty()) {
            return null;
        }
        System.out.println("getting position for " + uid);
        if (!query.getUseMessageIdInRsm()) {
            return Integer.parseInt(uid);
        }
        byte[] ownerId = MongoMessageArchiveRepository.generateId(query.getQuestionerJID().getBareJID());
        Bson idCrit = Filters.and((Bson[])new Bson[]{Filters.eq((String)"owner_id", (Object)ownerId), Filters.eq((String)"stable_id", (Object)UUID.fromString("uid"))});
        FindIterable cursor = this.msgsCollection.find(idCrit).projection(Projections.include((String[])new String[]{"ts"}));
        Document doc = (Document)cursor.first();
        if (doc == null) {
            System.out.println("item with " + uid + " not found");
            return null;
        }
        Date ts = doc.getDate((Object)"ts");
        Document positionCrit = new Document((Map)crit);
        positionCrit.append("ts", (Object)new Document("$lt", (Object)ts));
        long position = this.msgsCollection.count((Bson)positionCrit);
        System.out.println("got position " + position + " for " + uid);
        if (position < 0L) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Item with " + uid + " not found");
        }
        return (int)position;
    }

    public List<String> getTags(BareJID owner, String startsWith, QueryCriteria criteria) throws TigaseDBException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            byte[] oid = MongoMessageArchiveRepository.generateId(owner);
            Pattern tagPattern = Pattern.compile(startsWith + ".*");
            ArrayList<Document> pipeline = new ArrayList<Document>();
            Document crit = new Document("owner_id", (Object)oid);
            Document matchCrit = new Document("$match", (Object)crit);
            pipeline.add(matchCrit);
            pipeline.add(new Document("$unwind", (Object)"$tags"));
            pipeline.add(new Document("$match", (Object)new Document("tags", (Object)tagPattern)));
            pipeline.add(new Document("$group", (Object)new Document("_id", (Object)"$tags")));
            pipeline.add(new Document("$group", (Object)new Document("_id", (Object)1).append("count", (Object)new Document("$sum", (Object)1))));
            AggregateIterable cursor = this.msgsCollection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).useCursor(Boolean.valueOf(true));
            Document countDoc = (Document)cursor.first();
            int count = countDoc != null ? countDoc.getInteger((Object)"count") : null;
            String beforeStr = criteria.getRsm().getBefore();
            String afterStr = criteria.getRsm().getAfter();
            this.calculateOffsetAndPosition((Query)criteria, count, beforeStr == null ? null : Integer.valueOf(Integer.parseInt(beforeStr)), afterStr == null ? null : Integer.valueOf(Integer.parseInt(afterStr)));
            if (count > 0) {
                pipeline.remove(pipeline.size() - 1);
                pipeline.add(new Document("$sort", (Object)new Document("_id", (Object)1)));
                if (criteria.getRsm().getIndex() > 0) {
                    pipeline.add(new Document("$skip", (Object)criteria.getRsm().getIndex()));
                }
                pipeline.add(new Document("$limit", (Object)criteria.getRsm().getMax()));
                cursor = this.msgsCollection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).useCursor(Boolean.valueOf(true)).batchSize(this.batchSize);
                for (Document dto : cursor) {
                    results.add((String)dto.get((Object)"_id"));
                }
                RSM rsm = criteria.getRsm();
                rsm.setResults(Integer.valueOf(count), rsm.getIndex());
                if (results != null && !results.isEmpty()) {
                    rsm.setFirst(String.valueOf(rsm.getIndex()));
                    rsm.setLast(String.valueOf(rsm.getIndex() + (results.size() - 1)));
                }
            }
        }
        catch (Exception ex) {
            throw new TigaseDBException("Could not retrieve list of used tags", (Throwable)ex);
        }
        return results;
    }

    public QueryCriteria newQuery() {
        return new QueryCriteria();
    }

    public void queryCollections(QueryCriteria query, MessageArchiveRepository.CollectionHandler<QueryCriteria, MessageArchiveRepository.Collection> collectionHandler) throws TigaseDBException {
        try {
            List collections;
            Document crit = this.createCriteriaDocument(query);
            ArrayList results = new ArrayList();
            ArrayList<Bson> pipeline = new ArrayList<Bson>();
            Bson matchCrit = Aggregates.match((Bson)crit);
            pipeline.add(matchCrit);
            Bson groupCrit = Aggregates.group((Object)new Document("ts", (Object)"$date").append("buddy", (Object)"$buddy"), (BsonField[])new BsonField[]{Accumulators.min((String)"ts", (Object)"$ts"), Accumulators.min((String)"buddy", (Object)"$buddy")});
            pipeline.add(groupCrit);
            Bson countCrit = Aggregates.group((Object)1, (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)});
            pipeline.add(countCrit);
            AggregateIterable cursor = this.msgsCollection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).useCursor(Boolean.valueOf(true));
            Document countDoc = (Document)cursor.first();
            int count = countDoc != null ? countDoc.getInteger((Object)"count") : 0;
            Integer after = this.getColletionPosition(query.getRsm().getAfter());
            Integer before = this.getColletionPosition(query.getRsm().getBefore());
            this.calculateOffsetAndPosition((Query)query, count, before, after);
            if (count > 0) {
                pipeline.clear();
                pipeline.add(matchCrit);
                pipeline.add(groupCrit);
                Bson sort = Aggregates.sort((Bson)Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"ts", "buddy"})}));
                pipeline.add(sort);
                if (query.getRsm().getIndex() > 0) {
                    pipeline.add(Aggregates.skip((int)query.getRsm().getIndex()));
                }
                pipeline.add(Aggregates.limit((int)query.getRsm().getMax()));
                cursor = this.msgsCollection.aggregate(pipeline).allowDiskUse(Boolean.valueOf(true)).useCursor(Boolean.valueOf(true)).batchSize(this.batchSize);
                for (Document dto : cursor) {
                    final String buddy = (String)dto.get((Object)"buddy");
                    final Date ts = (Date)dto.get((Object)"ts");
                    collectionHandler.collectionFound((tigase.xmpp.mam.Query)query, new MessageArchiveRepository.Collection(){

                        public Date getStartTs() {
                            return ts;
                        }

                        public String getWith() {
                            return buddy;
                        }
                    });
                }
            }
            if ((collections = query.getCollections()) != null) {
                int first = query.getRsm().getIndex();
                query.getRsm().setFirst(String.valueOf(first));
                query.getRsm().setLast(String.valueOf(first + collections.size() - 1));
            }
        }
        catch (Exception ex) {
            throw new TigaseDBException("Cound not retrieve collections", (Throwable)ex);
        }
    }

    public void queryItems(QueryCriteria query, MAMRepository.ItemHandler<QueryCriteria, MAMRepository.Item> itemHandler) throws TigaseDBException {
        try {
            MongoCursor iter;
            Document crit = this.createCriteriaDocument(query);
            ArrayList results = new ArrayList();
            int count = (int)this.msgsCollection.count((Bson)crit);
            Integer after = this.getItemPosition(query.getRsm().getAfter(), query, crit);
            Integer before = this.getItemPosition(query.getRsm().getBefore(), query, crit);
            this.calculateOffsetAndPosition((Query)query, count, before, after);
            FindIterable cursor = this.msgsCollection.find((Bson)crit);
            if (query.getRsm().getIndex() > 0) {
                cursor = cursor.skip(query.getRsm().getIndex().intValue());
            }
            if ((iter = (cursor = cursor.batchSize(this.batchSize).limit(query.getRsm().getMax()).sort((Bson)new Document("ts", (Object)1))).iterator()).hasNext()) {
                int idx = query.getRsm().getIndex();
                int i = 0;
                Date startTimestamp = query.getStart();
                DomBuilderHandler domHandler = new DomBuilderHandler();
                while (iter.hasNext()) {
                    Item item = new Item();
                    item.owner = query.getQuestionerJID().getBareJID();
                    Document dto = (Document)iter.next();
                    String msgStr = (String)dto.get((Object)"msg");
                    item.timestamp = (Date)dto.get((Object)"ts");
                    String string = item.with = crit.containsKey((Object)"buddy") ? null : (String)dto.get((Object)"buddy");
                    if (query.getUseMessageIdInRsm()) {
                        item.id = ((UUID)dto.get((Object)"stable_id")).toString();
                    }
                    parser.parse((SimpleHandler)domHandler, msgStr.toCharArray(), 0, msgStr.length());
                    if (startTimestamp == null) {
                        startTimestamp = item.timestamp;
                    }
                    Queue queue = domHandler.getParsedElements();
                    Element msg = null;
                    while ((msg = (Element)queue.poll()) != null) {
                        if (!query.getUseMessageIdInRsm()) {
                            item.id = String.valueOf(idx + i);
                        }
                        item.messageEl = msg;
                        itemHandler.itemFound((tigase.xmpp.mam.Query)query, item);
                    }
                    ++i;
                }
                query.setStart(startTimestamp);
            }
        }
        catch (Exception ex) {
            throw new TigaseDBException("Cound not retrieve collections", (Throwable)ex);
        }
    }

    public void removeItems(BareJID owner, String with, Date start, Date end) throws TigaseDBException {
        try {
            byte[] oid = MongoMessageArchiveRepository.generateId(owner);
            ArrayList<Bson> crit = new ArrayList<Bson>();
            crit.add(Filters.eq((String)"owner_id", (Object)oid));
            if (with != null) {
                byte[] wid = MongoMessageArchiveRepository.calculateHash(with.toLowerCase());
                crit.add(Filters.eq((String)"buddy_id", (Object)wid));
            }
            if (start != null) {
                crit.add(Filters.gte((String)"ts", (Object)start));
            }
            if (end != null) {
                crit.add(Filters.lte((String)"ts", (Object)end));
            }
            this.msgsCollection.deleteMany(Filters.and(crit));
        }
        catch (Exception ex) {
            throw new TigaseDBException("Cound not remove items", (Throwable)ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        MongoDatabase db = dataSource.getDatabase();
        if (!Helper.collectionExists(db, MSGS_COLLECTION)) {
            db.createCollection(MSGS_COLLECTION);
        }
        this.msgsCollection = db.getCollection(MSGS_COLLECTION);
        this.msgsCollection.createIndex((Bson)new Document("owner_id", (Object)1).append("date", (Object)1));
        this.msgsCollection.createIndex((Bson)new Document("owner_id", (Object)1).append("buddy_id", (Object)1).append("ts", (Object)1));
        this.msgsCollection.createIndex((Bson)new Document("owner_id", (Object)1).append("ts", (Object)1));
        this.msgsCollection.createIndex((Bson)new Document("body", (Object)"text"));
        this.msgsCollection.createIndex((Bson)new Document("owner_id", (Object)1).append("tags", (Object)1));
        this.msgsCollection.createIndex((Bson)new Document("owner_id", (Object)1).append("stable_id", (Object)1));
        this.msgsCollection.createIndex((Bson)new Document("owner_domain_id", (Object)1).append("ts", (Object)1));
        this.db = db;
    }

    public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws TigaseDBException {
        List<Bson> ownerAggregation = Arrays.asList(Aggregates.group((Object)"$owner_id", (BsonField[])new BsonField[]{Accumulators.first((String)"owner", (Object)"$owner")}));
        for (Document doc : this.msgsCollection.aggregate(ownerAggregation).allowDiskUse(Boolean.valueOf(true)).batchSize(1000)) {
            byte[] newOwnerId;
            String owner = (String)doc.get((Object)"owner");
            byte[] oldOwnerId = ((Binary)doc.get((Object)"_id")).getData();
            if (Arrays.equals(oldOwnerId, newOwnerId = MongoMessageArchiveRepository.calculateHash(owner.toLowerCase()))) continue;
            Document update = new Document("owner_id", (Object)newOwnerId);
            this.msgsCollection.updateMany((Bson)new Document("owner_id", (Object)oldOwnerId), (Bson)new Document("$set", (Object)update));
        }
        List<Bson> buddyAggregation = Arrays.asList(Aggregates.group((Object)"$buddy_id", (BsonField[])new BsonField[]{Accumulators.first((String)"buddy", (Object)"$buddy")}));
        for (Document doc : this.msgsCollection.aggregate(buddyAggregation).allowDiskUse(Boolean.valueOf(true)).batchSize(1000)) {
            byte[] newBuddyId;
            String buddy = (String)doc.get((Object)"buddy");
            byte[] oldBuddyId = ((Binary)doc.get((Object)"_id")).getData();
            if (Arrays.equals(oldBuddyId, newBuddyId = MongoMessageArchiveRepository.calculateHash(buddy.toLowerCase()))) continue;
            Document update = new Document("buddy_id", (Object)newBuddyId);
            this.msgsCollection.updateMany((Bson)new Document("buddy_id", (Object)oldBuddyId), (Bson)new Document("$set", (Object)update));
        }
        FindIterable msgsWithoutStableId = this.msgsCollection.find(Filters.exists((String)"stable_id", (boolean)false)).projection(Projections.include((String[])new String[0]));
        for (Document doc : msgsWithoutStableId) {
            Document update = new Document("stable_id", (Object)UUID.randomUUID());
            this.msgsCollection.updateOne((Bson)doc, (Bson)new Document("$set", (Object)update));
        }
        return SchemaLoader.Result.ok;
    }

    public static class MongoDBAddMessageAdditionalDataProvider
    implements AbstractMessageArchiveRepository.AddMessageAdditionalDataProvider {
    }

    public static class Item<Q extends QueryCriteria>
    implements MessageArchiveRepository.Item {
        BareJID owner;
        String id;
        Element messageEl;
        Date timestamp;
        String with;

        public MessageArchiveRepository.Direction getDirection() {
            JID jid = JID.jidInstanceNS((String)this.getMessage().getAttributeStaticStr("to"));
            if (jid == null || !this.owner.equals((Object)jid.getBareJID())) {
                return MessageArchiveRepository.Direction.outgoing;
            }
            return MessageArchiveRepository.Direction.incoming;
        }

        public String getId() {
            return this.id;
        }

        public Element getMessage() {
            return this.messageEl;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getWith() {
            return this.with;
        }
    }
}

