/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.LastActivityAbstract;
import tigase.xmpp.impl.LastActivityRetriever;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;

@Id(value="jabber:iq:last-marker")
@DiscoFeatures(value={"jabber:iq:last"})
@Handles(value={@Handle(path={"presence"}, xmlns="jabber:client"), @Handle(path={"message"}, xmlns="jabber:client")})
@Bean(name="jabber:iq:last-marker", parent=SessionManager.class, active=false)
public class LastActivityMarker
extends LastActivityAbstract
implements XMPPStopListenerIfc,
RegistrarBean {
    protected static final String ID = "jabber:iq:last-marker";
    private static final Logger log = Logger.getLogger(LastActivityMarker.class.getName());
    private Kernel kernel;
    @ConfigField(desc="To persist all updates to repository")
    private boolean persistAllToRepository = true;
    @Inject
    private LastActivityRetriever[] retrievers;
    @ConfigField(desc="Whether to update last activity information on message packets", alias="message")
    private boolean updateOnMessage = false;
    @ConfigField(desc="Whether to update last activity information on presence packets", alias="presence")
    private boolean updateOnPresence = true;

    private static void setLastActivity(XMPPResourceConnection session, Long last, Element presence, boolean repository) {
        session.putCommonSessionData("LAST_ACTIVITY_KEY", last);
        session.putSessionData("LAST_ACTIVITY_KEY", last);
        if (repository) {
            LastActivityMarker.persistLastActivity(session, presence);
        }
    }

    public void setRetrievers(LastActivityRetriever[] retrievers) {
        this.retrievers = retrievers;
        if (this.kernel != null) {
            for (LastActivityRetriever retriever : retrievers) {
                Bean bean = retriever.getClass().getAnnotation(Bean.class);
                if (bean == null) continue;
                this.kernel.ln(bean.name(), this.kernel.getParent(), bean.name());
            }
        }
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet);
        }
        if (session != null && packet.getStanzaFrom() != null && session.isUserId(packet.getStanzaFrom().getBareJID())) {
            long time = System.currentTimeMillis();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Updating last:activity of user " + session.getUserName() + " to " + time);
            }
            if (this.updateOnMessage && packet.getElemName() == "message" || this.updateOnPresence && packet.getElemName() == "presence") {
                LastActivityMarker.setLastActivity(session, time, packet.getElement(), this.persistAllToRepository);
            }
        }
    }

    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Session stoppped for " + session.getjid() + ", persisting last activity");
        }
        if (session != null && session.isAuthorized()) {
            Element presence = session.getPresence();
            LastActivityMarker.persistLastActivity(session, presence);
        }
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void unregister(Kernel kernel) {
    }
}

