/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Optional;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.jid.BareJID;

public abstract class LastActivityAbstract
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    protected static final String XMLNS = "jabber:iq:last";
    public static final String LAST_ACTIVITY_KEY = "LAST_ACTIVITY_KEY";
    public static final String LAST_STATUS_KEY = "LAST_STATUS_KEY";
    public static final String LAST_SHOW_KEY = "LAST_SHOW_KEY";
    public static final String LAST_PRESENCE_KEY = "LAST_PRESENCE_KEY";
    private static final Logger log = Logger.getLogger(LastActivityAbstract.class.getName());
    public static final String[] STATUS_PATH = new String[]{"presence", "status"};
    public static final String[] SHOW_PATH = new String[]{"presence", "show"};
    private SimpleParser parser = SingletonFactory.getParserInstance();

    protected static long getLastActivity(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        String result = repo.getPublicData(requestedJid, XMLNS, LAST_ACTIVITY_KEY, "-1");
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "last-activity for: {0}, result: {1}", new String[]{String.valueOf(requestedJid), String.valueOf(result)});
        }
        if (result != null) {
            return Long.parseLong(result);
        }
        throw new UserNotFoundException(requestedJid + " doesn't exist");
    }

    public static long getLastActivity(XMPPResourceConnection session, boolean global) {
        Long result = null;
        result = global ? (Long)session.getCommonSessionData(LAST_ACTIVITY_KEY) : (Long)session.getSessionData(LAST_ACTIVITY_KEY);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "last-activity for: {0}, result: {1}", new String[]{String.valueOf(session.getjid()), String.valueOf(result)});
        }
        return result == null ? -1L : result;
    }

    protected static long getLastActivity(XMPPResourceConnection session, Packet packet) {
        return LastActivityAbstract.getLastActivity(session, packet.getStanzaTo().getResource() == null || packet.getStanzaTo().getResource().length() == 0);
    }

    protected static String getStatus(XMPPResourceConnection session) {
        return session.getPresence() == null ? null : session.getPresence().getChildCDataStaticStr(STATUS_PATH);
    }

    protected static String getShow(XMPPResourceConnection session) {
        return session.getPresence() == null ? null : session.getPresence().getChildCDataStaticStr(SHOW_PATH);
    }

    protected static String getShow(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        return repo.getPublicData(requestedJid, XMLNS, LAST_SHOW_KEY, null);
    }

    protected static String getType(XMPPResourceConnection session) {
        return session.getPresence() == null ? null : session.getPresence().getAttributeStaticStr("type");
    }

    protected static String getType(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        return repo.getPublicData(requestedJid, XMLNS, LAST_SHOW_KEY, null);
    }

    protected Optional<Element> getPresence(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        String publicData = repo.getPublicData(requestedJid, XMLNS, LAST_PRESENCE_KEY, null);
        if (publicData != null) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            char[] data = publicData.toCharArray();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue parsedElements = domHandler.getParsedElements();
            return parsedElements.peek() != null ? Optional.of((Element)parsedElements.poll()) : Optional.empty();
        }
        return Optional.empty();
    }

    protected static String getStatus(NonAuthUserRepository repo, BareJID requestedJid) throws UserNotFoundException {
        return repo.getPublicData(requestedJid, XMLNS, LAST_STATUS_KEY, null);
    }

    protected static void persistLastActivity(XMPPResourceConnection session, Element presence) {
        long last = LastActivityAbstract.getLastActivity(session, false);
        String status = LastActivityAbstract.getStatus(session);
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Persiting last:activity of user " + session.getUserName() + " in storage (value=" + last + ", presence=" + presence + ").");
            }
            session.setPublicData(XMLNS, LAST_ACTIVITY_KEY, String.valueOf(last));
            if (presence != null) {
                session.setPublicData(XMLNS, LAST_PRESENCE_KEY, String.valueOf(presence));
            }
            session.setPublicData(XMLNS, LAST_STATUS_KEY, status);
        }
        catch (NotAuthorizedException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("session isn't authorized" + session);
            }
        }
        catch (TigaseDBException e) {
            log.warning("Tigase Db Exception");
        }
    }

    static enum ProtectionLevel {
        ALL,
        BUDDIES;

    }
}

