/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionType;

public class ConnectionOpenThread
implements Runnable {
    public static final long def_5222_throttling = 200L;
    public static final long def_5223_throttling = 50L;
    public static final long def_5269_throttling = 100L;
    public static final long def_5280_throttling = 1000L;
    private static final Logger log = Logger.getLogger(ConnectionOpenThread.class.getName());
    public static Map<Integer, PortThrottlingData> throttling = new ConcurrentHashMap<Integer, PortThrottlingData>(10);
    private static ConnectionOpenThread acceptThread = null;
    protected long accept_counter = 0L;
    private Selector selector = null;
    private boolean stopping = false;
    private Timer timer = null;
    private ConcurrentLinkedQueue<Task> waiting = new ConcurrentLinkedQueue();

    public static ConnectionOpenThread getInstance() {
        if (acceptThread == null) {
            acceptThread = new ConnectionOpenThread();
            Thread thrd = new Thread(acceptThread);
            thrd.setName("ConnectionOpenThread");
            thrd.start();
            if (log.isLoggable(Level.FINER)) {
                log.finer("ConnectionOpenThread started.");
            }
        }
        return acceptThread;
    }

    private ConnectionOpenThread() {
        this.timer = new Timer("Connections open timer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (PortThrottlingData portData : throttling.values()) {
                    portData.lastSecondConnections = 0L;
                }
            }
        }, 1000L, 1000L);
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Server I/O error, can''t continue my work.", e);
            this.stopping = true;
        }
    }

    public void addConnectionOpenListener(ConnectionOpenListener al) {
        this.waiting.offer(new Task(al, Task.Action.Add));
        this.selector.wakeup();
    }

    public void removeConnectionOpenListener(ConnectionOpenListener al) {
        this.waiting.offer(new Task(al, Task.Action.Remove));
        this.selector.wakeup();
    }

    @Override
    public void run() {
        while (!this.stopping) {
            try {
                int select = this.selector.select();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Selected: " + select + " from selector: " + this.selector);
                }
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey sk = i.next();
                    i.remove();
                    SocketChannel sc = null;
                    boolean throttled = false;
                    int port_no = 0;
                    if ((sk.readyOps() & 0x10) != 0) {
                        PortThrottlingData port_throttling;
                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                        port_no = nextReady.socket().getLocalPort();
                        sc = nextReady.accept();
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("OP_ACCEPT");
                        }
                        if ((port_throttling = throttling.get(port_no)) != null) {
                            ++port_throttling.lastSecondConnections;
                            if (port_throttling.lastSecondConnections > port_throttling.throttling) {
                                if (log.isLoggable(Level.INFO)) {
                                    log.log(Level.INFO, "New connections throttling level {0} exceeded limit of {1}, closing: {2}", new Object[]{port_throttling.lastSecondConnections, port_throttling.throttling, sc});
                                }
                                sc.close();
                                sc = null;
                                throttled = true;
                            }
                        } else {
                            log.log(Level.WARNING, "Throttling not configured for port: {0}", port_no);
                        }
                    }
                    if ((sk.readyOps() & 8) != 0) {
                        sk.cancel();
                        sc = (SocketChannel)sk.channel();
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("OP_CONNECT");
                        }
                    }
                    if (sc != null) {
                        try {
                            sc.configureBlocking(false);
                            sc.socket().setSoLinger(false, 0);
                            sc.socket().setReuseAddress(true);
                            if (log.isLoggable(Level.FINER)) {
                                log.log(Level.FINER, "Registered new client socket: {0}", sc);
                            }
                            ConnectionOpenListener al = (ConnectionOpenListener)sk.attachment();
                            sc.socket().setTrafficClass(al.getTrafficClass());
                            sc.socket().setReceiveBufferSize(al.getReceiveBufferSize());
                            al.accept(sc);
                        }
                        catch (SocketException e) {
                            log.log(Level.INFO, "Socket closed instantly after it had been opened?", e);
                            ConnectionOpenListener al = (ConnectionOpenListener)sk.attachment();
                            al.accept(sc);
                        }
                    } else {
                        log.log(Level.INFO, "Can not obtain socket channel from selection key, throttling activated = {0}, for port: {1}", new Object[]{throttled, port_no});
                    }
                    ++this.accept_counter;
                }
                this.processWaiting();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Server I/O error.", e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Other service exception.", e);
            }
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setName("ConnectionOpenThread");
        t.start();
    }

    public void stop() {
        this.stopping = true;
        this.selector.wakeup();
    }

    private void processWaiting() throws IOException {
        Task task = null;
        while ((task = this.waiting.poll()) != null) {
            ConnectionOpenListener al = task.openListener;
            block2 : switch (task.action) {
                case Add: {
                    try {
                        this.addPort(al);
                    }
                    catch (Exception e) {
                        if ((e instanceof SocketException && e.getMessage() != null && e.getMessage().contains("Network is unreachable") || e instanceof NoRouteToHostException && e.getMessage() != null && e.getMessage().equals("No route to host")) && al.getConnectionType() == ConnectionType.connect && al.getIfcs() != null && Arrays.stream(al.getIfcs()).filter(ifc -> ifc.contains(":")).findFirst().isPresent()) {
                            log.log(Level.FINEST, "Error: creating IPv6 connection (" + e + ") for: " + al);
                        } else {
                            log.log(Level.WARNING, "Error: creating connection for: " + al, e);
                            for (SelectionKey key : this.selector.keys()) {
                                ConnectionOpenListener al1 = (ConnectionOpenListener)key.attachment();
                                if (al == null || al.getPort() != al1.getPort()) continue;
                                log.log(Level.FINEST, "port " + al.getPort() + " still bound!!");
                            }
                        }
                        al.accept(null);
                    }
                    break;
                }
                case Remove: {
                    for (SelectionKey key : this.selector.keys()) {
                        if (al != key.attachment()) continue;
                        try {
                            SelectableChannel channel = key.channel();
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "removing binding for port:" + al.getPort());
                            }
                            channel.close();
                            key.cancel();
                            this.selector.selectNow();
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Exception during removing connection listener.", e);
                        }
                        break block2;
                    }
                    break;
                }
            }
        }
    }

    private void addISA(InetSocketAddress isa, ConnectionOpenListener al) throws IOException {
        switch (al.getConnectionType()) {
            case accept: {
                long port_throttling = al.getNewConnectionsThrottling();
                throttling.put(isa.getPort(), new PortThrottlingData(port_throttling));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Setting up throttling for the port {0} to {1} connections per second. isa: {2}", new Object[]{isa.getPort(), port_throttling, isa});
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Setting up 'accept' channel...");
                }
                ServerSocketChannel ssc = ServerSocketChannel.open();
                ssc.socket().setReceiveBufferSize(al.getReceiveBufferSize());
                ssc.configureBlocking(false);
                ssc.bind(isa, (int)port_throttling);
                ssc.register(this.selector, 16, al);
                break;
            }
            case connect: {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Setting up ''connect'' channel for: {0}/{1}", new Object[]{isa.getAddress(), isa.getPort()});
                }
                SocketChannel sc = SocketChannel.open();
                sc.socket().setReceiveBufferSize(al.getReceiveBufferSize());
                sc.socket().setTrafficClass(al.getTrafficClass());
                sc.configureBlocking(false);
                sc.connect(isa);
                sc.register(this.selector, 8, al);
                break;
            }
            default: {
                log.log(Level.WARNING, "Unknown connection type: {0}", (Object)al.getConnectionType());
            }
        }
    }

    private void addPort(ConnectionOpenListener al) throws IOException {
        if (al.getConnectionType() == ConnectionType.connect && al.getRemoteAddress() != null) {
            this.addISA(al.getRemoteAddress(), al);
        } else if (al.getIfcs() == null || al.getIfcs().length == 0 || al.getIfcs()[0].equals("ifc") || al.getIfcs()[0].equals("*")) {
            this.addISA(new InetSocketAddress(al.getPort()), al);
        } else {
            for (String ifc : al.getIfcs()) {
                this.addISA(new InetSocketAddress(ifc, al.getPort()), al);
            }
        }
    }

    private class PortThrottlingData {
        protected long lastSecondConnections = 0L;
        protected long throttling;

        private PortThrottlingData(long throttling_prop) {
            this.throttling = throttling_prop;
        }
    }

    private static class Task {
        private final ConnectionOpenListener openListener;
        private final Action action;

        private Task(ConnectionOpenListener openListener, Action action) {
            this.action = action;
            this.openListener = openListener;
        }

        private static enum Action {
            Add,
            Remove;

        }
    }
}

