/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.NamedCurve;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

public class DefaultTlsECConfigVerifier
implements TlsECConfigVerifier {
    protected int minimumCurveBits;
    protected int[] namedCurves;

    public DefaultTlsECConfigVerifier(int n, int[] nArray) {
        this.minimumCurveBits = n;
        this.namedCurves = Arrays.clone((int[])nArray);
    }

    public boolean accept(TlsECConfig tlsECConfig) {
        int n = tlsECConfig.getNamedCurve();
        if (NamedCurve.getCurveBits(n) < this.minimumCurveBits) {
            return false;
        }
        return this.namedCurves == null || Arrays.contains((int[])this.namedCurves, (int)n);
    }
}

