/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

class ProvX509TrustManager
implements X509TrustManager {
    private final Provider pkixProvider;
    private final Set trustAnchors;
    private final PKIXParameters baseParameters;

    public ProvX509TrustManager(Provider provider, Set set) throws InvalidAlgorithmParameterException {
        this.pkixProvider = provider;
        this.trustAnchors = set;
        this.baseParameters = new PKIXBuilderParameters(set, (CertSelector)new X509CertSelector());
        this.baseParameters.setRevocationEnabled(false);
    }

    public ProvX509TrustManager(Provider provider, PKIXParameters pKIXParameters) throws InvalidAlgorithmParameterException {
        this.pkixProvider = provider;
        this.trustAnchors = pKIXParameters.getTrustAnchors();
        if (pKIXParameters instanceof PKIXBuilderParameters) {
            this.baseParameters = pKIXParameters;
        } else {
            this.baseParameters = new PKIXBuilderParameters(pKIXParameters.getTrustAnchors(), pKIXParameters.getTargetCertConstraints());
            this.baseParameters.setCertStores(pKIXParameters.getCertStores());
            this.baseParameters.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
            this.baseParameters.setCertPathCheckers(pKIXParameters.getCertPathCheckers());
            this.baseParameters.setDate(pKIXParameters.getDate());
            this.baseParameters.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
            this.baseParameters.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
            this.baseParameters.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.validatePath(x509CertificateArray);
    }

    public X509Certificate[] getAcceptedIssuers() {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[this.trustAnchors.size()];
            int n = 0;
            Iterator iterator = this.trustAnchors.iterator();
            while (iterator.hasNext()) {
                x509CertificateArray[n++] = ((TrustAnchor)iterator.next()).getTrustedCert();
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            return new X509Certificate[0];
        }
    }

    protected void validatePath(X509Certificate[] x509CertificateArray) throws CertificateException {
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(x509CertificateArray)), this.pkixProvider);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", this.pkixProvider);
            X509CertSelector x509CertSelector = (X509CertSelector)this.baseParameters.getTargetCertConstraints().clone();
            x509CertSelector.setCertificate(x509CertificateArray[0]);
            PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)this.baseParameters.clone();
            pKIXBuilderParameters.addCertStore(certStore);
            pKIXBuilderParameters.setTargetCertConstraints(x509CertSelector);
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)((Object)certPathBuilder.build(pKIXBuilderParameters));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("unable to process certificates: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

