/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Stream;
import tigase.pubsub.utils.Cache;
import tigase.stats.Counter;
import tigase.stats.StatisticsList;

public class LRUCache<K, V>
implements Cache<K, V> {
    private final Map<K, Node<K, V>> cache;
    private final AtomicInteger size = new AtomicInteger(0);
    private int maxSize;
    private final Node<K, V> head;
    private final Node<K, V> tail;
    private Counter hitsCounter = new Counter("cache/hits", Level.FINEST);
    private Counter requestsCounter = new Counter("cache/requests", Level.FINEST);

    public LRUCache() {
        this(2000);
    }

    public LRUCache(int maxSize) {
        this.cache = new LinkedHashMap<K, Node<K, V>>(maxSize, 0.1f);
        this.head = new Node();
        this.tail = new Node();
        this.head.next = this.tail;
        this.tail.prev = this.head;
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Cache.CacheSupplier<V> supplier) throws Cache.CacheException {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            Node<K, V> node = this.cache.get(key);
            if (node != null) {
                this.removeFromQueue(node);
                this.appendToQueue(node);
                this.hitsCounter.inc();
                return node.value;
            }
            Node<K, V> newNode = this.newNode(key, supplier.get());
            this.cache.put(key, newNode);
            this.appendToQueue(newNode);
            this.size.incrementAndGet();
            while (this.size.get() > this.maxSize) {
                this.removeFirst();
            }
            return newNode.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.requestsCounter.inc();
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            Node<K, V> node = this.cache.get(key);
            if (node != null) {
                this.removeFromQueue(node);
                this.appendToQueue(node);
                this.hitsCounter.inc();
                return node.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Node<K, V> newNode = this.newNode(key, value);
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            Node<K, V> oldNode = this.cache.put(key, newNode);
            if (oldNode != null) {
                this.removeFromQueue(oldNode);
            } else {
                this.size.incrementAndGet();
            }
            this.appendToQueue(newNode);
            while (this.size.get() > this.maxSize) {
                this.removeFirst();
            }
            return oldNode == null ? null : (V)oldNode.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        Node<K, V> newNode = this.newNode(key, value);
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            Node<K, V> oldNode = this.cache.putIfAbsent(key, newNode);
            if (oldNode == null) {
                this.appendToQueue(newNode);
                this.size.incrementAndGet();
                while (this.size.get() > this.maxSize) {
                    this.removeFirst();
                }
                return null;
            }
            return oldNode.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            Node<K, V> node = this.cache.remove(key);
            if (node != null) {
                this.removeFromQueue(node);
                this.size.decrementAndGet();
            }
            return node == null ? null : (V)node.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            Node<K, V> node = this.cache.get(key);
            if (node != null && node.value == value) {
                this.cache.remove(key, node);
                this.removeFromQueue(node);
                this.size.decrementAndGet();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            return new HashSet<K>(this.cache.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<V> values() {
        ArrayList<Node<K, V>> list;
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            list = new ArrayList<Node<K, V>>(this.cache.values());
        }
        return list.stream().map(Node::getValue);
    }

    @Override
    public int size() {
        return this.size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSize(int size) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            this.maxSize = size;
            while (this.size.get() > this.maxSize) {
                this.removeFirst();
            }
        }
    }

    public void everyHour() {
        this.requestsCounter.everyHour();
        this.hitsCounter.everyHour();
    }

    public void everyMinute() {
        this.requestsCounter.everyMinute();
        this.hitsCounter.everyMinute();
    }

    public void everySecond() {
        this.requestsCounter.everySecond();
        this.hitsCounter.everySecond();
    }

    public void getStatistics(String compName, StatisticsList list) {
        this.requestsCounter.getStatistics(compName, list);
        this.hitsCounter.getStatistics(compName, list);
        list.add(compName, "cache/hit-miss ratio per minute", this.requestsCounter.getPerMinute() == 0L ? 0.0f : (float)this.hitsCounter.getPerMinute() / (float)this.requestsCounter.getPerMinute(), Level.FINE);
        list.add(compName, "cache/hit-miss ratio per second", this.requestsCounter.getPerSecond() == 0L ? 0.0f : (float)this.hitsCounter.getPerSecond() / (float)this.requestsCounter.getPerSecond(), Level.FINE);
    }

    public void setStatisticsPrefix(String prefix) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void statisticExecutedIn(long executionTime) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void appendToQueue(Node<K, V> newNode) {
        newNode.prev = this.tail.prev;
        this.tail.prev.next = newNode;
        this.tail.prev = newNode;
        newNode.next = this.tail;
    }

    private void removeFromQueue(Node<K, V> node) {
        Node next;
        if (node.prev == null || node.next == null) {
            return;
        }
        Node prev = node.prev;
        prev.next = next = node.next;
        next.prev = prev;
    }

    private void removeFirst() {
        Node node = this.head.next;
        if (node == this.tail) {
            return;
        }
        this.removeFromQueue(node);
        this.cache.remove(node.key);
        this.size.decrementAndGet();
    }

    private Node<K, V> newNode(K key, V value) {
        Node node = new Node();
        node.key = key;
        node.value = value;
        return node;
    }

    private static class Node<K, V> {
        Node<K, V> prev;
        Node<K, V> next;
        K key;
        V value;

        private Node() {
        }

        V getValue() {
            return this.value;
        }
    }
}

