/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLoadRunner
implements Runnable {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final long delay;
    private final long testTime;
    private int counter = 0;
    private long testEndTime;
    private long testStartTime;

    public AbstractLoadRunner(long time, long frequency) {
        this.delay = (long)(1.0 / (double)frequency * 1000.0);
        this.testTime = time;
        this.log.info("Preparing load test: testTime=" + this.testTime + ", frequency=" + frequency + "/sec; calculatedDelay=" + this.delay + " ms");
    }

    public int getCounter() {
        return this.counter;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getTestEndTime() {
        return this.testEndTime;
    }

    public long getTestStartTime() {
        return this.testStartTime;
    }

    @Override
    public void run() {
        try {
            long cst;
            this.testStartTime = System.currentTimeMillis();
            this.testEndTime = this.testStartTime + this.testTime * 1000L;
            while (this.testEndTime >= (cst = System.currentTimeMillis())) {
                long fix;
                ++this.counter;
                this.doWork();
                long now = System.currentTimeMillis();
                long dt = now - cst;
                long sleepTime = this.delay - dt + (fix = this.testStartTime + this.delay * (long)(this.counter - 1) - now);
                if (sleepTime <= 0L) continue;
                Thread.sleep(sleepTime);
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "LoadTest generator stopped", e);
        }
        this.onTestFinish();
    }

    protected abstract void doWork() throws Exception;

    protected void onTestFinish() {
    }
}

