/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import tigase.auth.credentials.Credentials;
import tigase.db.beans.AuthRepositoryMDPoolBean;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.xmpp.jid.BareJID;

@Bean(name="credentialEncoders", parent=AuthRepositoryMDPoolBean.AuthRepositoryConfigBean.class, active=true)
public class CredentialsEncoderBean
implements RegistrarBean {
    @Inject
    private List<Credentials.Encoder> encoders;

    public List<String> getSupportedMechanisms() {
        return this.encoders.stream().map(enc -> enc.getName()).collect(Collectors.toList());
    }

    public String encode(BareJID user, String mechanism, String password) throws NoSuchAlgorithmException {
        for (Credentials.Encoder encoder : this.encoders) {
            if (!mechanism.equals(encoder.getName())) continue;
            return encoder.encode(user, password);
        }
        throw new NoSuchAlgorithmException("No password encoder for mechanism " + mechanism);
    }

    public List<String[]> encodeForAllMechanisms(BareJID user, String password) {
        ArrayList<String[]> entries = new ArrayList<String[]>();
        for (Credentials.Encoder enc : this.encoders) {
            entries.add(new String[]{enc.getName(), enc.encode(user, password)});
        }
        return entries;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }
}

