/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tigase.auditlog.AuditLogComponent;
import tigase.auditlog.Entry;
import tigase.auditlog.LogRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.Authorization;

@Bean(name="slf4jRepositoryOld", parent=AuditLogComponent.class, active=false)
public class SLF4JRepositoryOld
implements LogRepository {
    private static final Logger a = LoggerFactory.getLogger(SLF4JRepositoryOld.class);
    private static final Set<String> b;
    @ConfigField(desc="Repository name")
    private String name;

    protected static String escapeJsonString(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("'", "\\'");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void append(Entry entry) {
        String string;
        if (a.isDebugEnabled() && (string = this.toJson(this.toMap(entry))) != null) {
            a.debug(string);
        }
    }

    @Override
    public List<Entry> getCachedEntries(int offset, int limit) {
        return null;
    }

    protected Map<String, String> toMap(Entry entry) {
        HashMap<String, String> hashMap;
        String string = (String)(hashMap = new HashMap<String, String>(entry.getValues())).get("errorCondition");
        hashMap.put("allowed", string == null || b.contains(string) ? "true" : "false");
        String string2 = (String)hashMap.remove("clusterNode");
        if (string2 != null) {
            hashMap.put("serverName", string2);
        }
        if ((string2 = (String)hashMap.get("type")) != null && string2.startsWith("auth.")) {
            string2 = (String)hashMap.remove("errorMessage");
            if (string2 != null) {
                hashMap.put("cause", string2);
            }
            hashMap.remove("errorCode");
            hashMap.remove("errorCondition");
        }
        if ((string2 = (String)hashMap.get("subtype")) != null) {
            hashMap.put("type", (String)hashMap.get("type") + "." + string2);
        }
        if ((string2 = (String)hashMap.remove("conversationId")) != null) {
            hashMap.put("callId", string2);
        }
        return hashMap;
    }

    protected String toJson(Map<String, String> values) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(values.keySet());
        Collections.sort(arrayList);
        stringBuilder.append("{ ");
        boolean bl = true;
        for (String string : arrayList) {
            String string2 = values.get(string);
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            string = SLF4JRepositoryOld.escapeJsonString(string);
            string2 = SLF4JRepositoryOld.escapeJsonString(string2);
            stringBuilder.append("'").append(string).append("'").append(":");
            if (string2 != null) {
                stringBuilder.append("'").append(string2).append("'");
                continue;
            }
            stringBuilder.append("null");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    static {
        CopyOnWriteArraySet<String> copyOnWriteArraySet = new CopyOnWriteArraySet<String>();
        copyOnWriteArraySet.add(Authorization.NOT_AUTHORIZED.getCondition());
        copyOnWriteArraySet.add(Authorization.FORBIDDEN.getCondition());
        copyOnWriteArraySet.add(Authorization.NOT_ALLOWED.getCondition());
        copyOnWriteArraySet.add(Authorization.PAYMENT_REQUIRED.getCondition());
        copyOnWriteArraySet.add(Authorization.POLICY_VIOLATION.getCondition());
        copyOnWriteArraySet.add(Authorization.RESOURCE_CONSTRAINT.getCondition());
        copyOnWriteArraySet.add(Authorization.SUBSCRIPTION_REQUIRED.getCondition());
        b = Collections.unmodifiableSet(copyOnWriteArraySet);
    }
}

