/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster.commands;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.cluster.ClusteredNodeStrategy;
import tigase.pubsub.cluster.PresenceCollectorRepositoryClustered;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="response-caps-sync", parent=ClusteredNodeStrategy.class, active=true)
public class ResponseCapsSyncCommand
extends CommandListenerAbstract {
    public static final String RESPONSE_CAPS_SYNC_CMD = "response-caps-sync";
    @Inject(nullAllowed=true)
    private PresenceCollectorRepositoryClustered presenceCollectorRepository;

    public ResponseCapsSyncCommand() {
        super(RESPONSE_CAPS_SYNC_CMD, Priority.HIGH);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        if (packets != null && !packets.isEmpty()) {
            for (Element element2 : packets) {
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)element2.getAttributeStaticStr("jid"));
                for (Element element3 : element2.getChildren()) {
                    BareJID bareJID2 = BareJID.bareJIDInstanceNS((String)element3.getAttributeStaticStr("jid"));
                    List list = element3.getChildren();
                    if (list == null) continue;
                    for (Element element4 : list) {
                        String string = element4.getAttributeStaticStr("name");
                        List list2 = element4.mapChildren(element -> element.getAttributeStaticStr("node"));
                        this.presenceCollectorRepository.addNoEvent(bareJID, JID.jidInstanceNS((BareJID)bareJID2, (String)string), list2 == null || list2.isEmpty() ? null : (String)list2.get(0));
                    }
                }
            }
        }
    }

    public void nodeDisconnected(JID nodeJID) {
        if (this.presenceCollectorRepository != null) {
            this.presenceCollectorRepository.nodeDisconnected(nodeJID);
        }
    }
}

