/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Iterator;
import java.util.List;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.mix.modules.RoomPresenceModule;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="channelJoinModule", parent=IMixComponent.class, active=true)
public class ChannelJoinModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_JOIN = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"join", (String)"urn:xmpp:mix:core:1"));
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;
    @Inject
    private PublishItemModule publishItemModule;
    @Inject(nullAllowed=true)
    private RoomPresenceModule roomPresenceModule;

    public Criteria getModuleCriteria() {
        return CRIT_JOIN;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            if (packet.getStanzaTo().getLocalpart() == null) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            BareJID channelJID = packet.getStanzaTo().getBareJID();
            BareJID senderJID = packet.getStanzaFrom().getBareJID();
            Element joinEl = packet.getElemChild("join", "urn:xmpp:mix:core:1");
            ChannelConfiguration config = this.mixRepository.getChannelConfiguration(channelJID);
            if (config == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            this.mixLogic.checkPermission(channelJID, senderJID, MixAction.join);
            String nick = joinEl.getCData(new String[]{"join", "nick"});
            if (config.isNickMandator() && (nick == null || nick.trim().isEmpty())) {
                throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Nick is required!");
            }
            IParticipant participant = this.mixRepository.updateParticipant(channelJID, senderJID, nick);
            List nodes = joinEl.mapChildren(el -> el.getName() == "subscribe", el -> el.getAttributeStaticStr("node"));
            if (nodes != null) {
                Iterator it = nodes.iterator();
                while (it.hasNext()) {
                    try {
                        String node2 = (String)it.next();
                        this.mixLogic.checkPermission(channelJID, node2, packet.getStanzaFrom(), PubSubLogic.Action.subscribe);
                        ISubscriptions subscriptions = this.getRepository().getNodeSubscriptions(channelJID, node2);
                        if (subscriptions == null) {
                            it.remove();
                            break;
                        }
                        if (subscriptions.getSubscription(senderJID) != Subscription.none) continue;
                        subscriptions.addSubscriberJid(senderJID, Subscription.subscribed);
                        this.getRepository().update(channelJID, node2, subscriptions);
                    }
                    catch (Throwable ex) {
                        it.remove();
                    }
                }
            }
            Element responseContent = new Element("join", new String[]{"xmlns", "id"}, new String[]{"urn:xmpp:mix:core:1", participant.getParticipantId()});
            if (nodes != null) {
                nodes.stream().map(node -> new Element("subscribe", new String[]{"node"}, new String[]{node})).forEach(arg_0 -> ((Element)responseContent).addChild(arg_0));
            }
            if (nick != null) {
                responseContent.addChild((XMLNodeIfc)new Element("nick", nick));
            }
            this.packetWriter.write(packet.okResult(responseContent, 0));
            if (this.roomPresenceModule != null) {
                this.roomPresenceModule.participantJoined(channelJID, null, nick);
            }
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

