/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.j2se.connectors.socket.Reader;

public class WebSocketReader
implements Reader {
    private static final Logger log = Logger.getLogger(WebSocketReader.class.getCanonicalName());
    private final ByteBuffer buf = ByteBuffer.allocate(2048);
    private final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    private final InputStream inputStream;
    private FrameType frameType = FrameType.Pong;
    private long remaining = 0L;

    public WebSocketReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        byte[] arr = this.buf.array();
        boolean closed = false;
        int startBufPos = this.buf.position();
        int read = this.inputStream.read(arr, startBufPos, this.buf.remaining());
        if (read == 0) {
            return 0;
        }
        if (read == -1) {
            closed = true;
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            read = 0;
        }
        this.buf.position(startBufPos + read);
        this.buf.flip();
        CharBuffer cb = CharBuffer.wrap(cbuf);
        while (this.buf.hasRemaining() && cb.hasRemaining()) {
            if (this.remaining == 0L) {
                boolean reset = false;
                int position = this.buf.position();
                byte type = this.buf.get();
                byte frameType = (byte)(type & 0xF);
                switch (frameType) {
                    case 8: {
                        if (this.buf.hasRemaining()) {
                            byte len = this.buf.get();
                            if (this.buf.remaining() < len) {
                                if (!closed) {
                                    this.buf.position(position);
                                    break;
                                }
                            } else if (len > 0) {
                                log.log(Level.FINE, "received WebSocket close with status = " + this.buf.getShort());
                            }
                        }
                        return -1;
                    }
                    case 10: {
                        this.frameType = FrameType.Pong;
                        log.log(Level.FINEST, "got PONG frame");
                        break;
                    }
                    default: {
                        this.frameType = FrameType.Text;
                    }
                }
                if (this.buf.hasRemaining()) {
                    long len = this.buf.get() & 0x7F;
                    if (len == 126L) {
                        if (this.buf.remaining() >= 2) {
                            this.remaining = this.buf.getShort() & 0xFFFF;
                        } else {
                            reset = true;
                        }
                    } else if (len == 127L) {
                        if (this.buf.remaining() >= 8) {
                            this.remaining = this.buf.getLong();
                        } else {
                            reset = true;
                        }
                    } else {
                        this.remaining = len;
                    }
                } else {
                    reset = true;
                }
                if (reset) {
                    this.buf.position(position);
                    break;
                }
                log.log(Level.FINEST, "got frame of type = " + type + " with length = " + this.remaining);
            }
            if (this.remaining <= 0L) continue;
            long waiting = this.remaining <= (long)this.buf.remaining() ? this.remaining : (long)this.buf.remaining();
            int limit = this.buf.limit();
            int rem = this.buf.remaining();
            this.buf.limit((int)((long)this.buf.position() + waiting));
            switch (this.frameType) {
                case Text: {
                    this.decoder.decode(this.buf, cb, false);
                    break;
                }
                case Pong: {
                    this.buf.position((int)((long)this.buf.position() + this.remaining));
                }
            }
            this.buf.limit(limit);
            this.remaining -= (long)(rem - this.buf.remaining());
            if (this.remaining >= 0L) continue;
            this.remaining = 0L;
        }
        this.buf.compact();
        cb.flip();
        if (log.isLoggable(Level.FINEST) && cb.hasRemaining()) {
            char[] tmp = new char[cb.remaining()];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = cb.get(cb.position() + i);
            }
            log.log(Level.FINEST, "read data = " + new String(tmp) + ", still remaining = " + this.remaining + " and in buffer " + this.buf.remaining());
        }
        return cb.remaining();
    }

    public static enum FrameType {
        Text,
        Ping,
        Pong;

    }
}

