/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.archive.unified.UnifiedArchiveComponent;
import tigase.db.DataRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.Repository;
import tigase.db.UserNotFoundException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.amp.db.JDBCMsgRepository;
import tigase.server.amp.db.MsgRepository;
import tigase.xml.Element;
import tigase.xmpp.ElementMatcher;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.SchemaId(id="unified-archive", name="Tigase Unified Archive Component")
public class JDBCFlexibleOfflineMessageRetrievalRepository
extends JDBCMsgRepository
implements RepositoryVersionAware {
    private static final Logger a = Logger.getLogger(JDBCFlexibleOfflineMessageRetrievalRepository.class.getCanonicalName());
    private static final String b = "{ call Tig_UA_FOR_GetMessagesCount(?) }";
    private static final String c = "{ call Tig_UA_FOR_GetMessagesList(?) }";
    private static final String d = "{ call Tig_UA_FOR_GetMessages(?,?) }";
    private static final String e = "{ call Tig_UA_FOR_RemoveMessages(?,?) }";
    private static final String f = "{ call Tig_UA_FOR_UnmarkOfflineMessages(?,?) }";
    private final SimpleDateFormat g;
    @ConfigField(desc="Delete offline messages query", alias="delete-messages-query")
    private String DELETE_MESSAGES_QUERY = "{ call Tig_UA_FOR_RemoveMessages(?,?) }";
    @ConfigField(desc="Get offline messages count query", alias="get-messages-count-query")
    private String GET_MESSAGES_COUNT_QUERY = "{ call Tig_UA_FOR_GetMessagesCount(?) }";
    @ConfigField(desc="Get offline messages list query", alias="get-messages-list-query")
    private String GET_MESSAGES_LIST_QUERY = "{ call Tig_UA_FOR_GetMessagesList(?) }";
    @ConfigField(desc="Get offline messages query", alias="get-messages-query")
    private String GET_MESSAGES_QUERY = "{ call Tig_UA_FOR_GetMessages(?,?) }";
    @ConfigField(desc="Unmark offline messages query", alias="unmark-offline-messages-query")
    private String UNMARK_OFFLINE_MESSAGES_QUERY = "{ call Tig_UA_FOR_UnmarkOfflineMessages(?,?) }";
    @ConfigField(desc="Matchers selecting messages that will be archived", alias="msg-archive-paths")
    private ElementMatcher[] archivingMatchers = new ElementMatcher[]{new ElementMatcher(new String[]{"message", "result"}, "urn:xmpp:mam:1", false), new ElementMatcher(new String[]{"message", "body"}, null, true)};
    @Inject
    private MessageArchivePlugin messageArchivePlugin;
    @Inject
    private UnifiedArchiveComponent unifiedArchiveComponent;

    public JDBCFlexibleOfflineMessageRetrievalRepository() {
        this.g = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.g.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setDataSource(DataRepository data_repo) {
        try {
            data_repo.initPreparedStatement(this.GET_MESSAGES_COUNT_QUERY, this.GET_MESSAGES_COUNT_QUERY);
            data_repo.initPreparedStatement(this.GET_MESSAGES_LIST_QUERY, this.GET_MESSAGES_LIST_QUERY);
            data_repo.initPreparedStatement(this.GET_MESSAGES_QUERY, this.GET_MESSAGES_QUERY);
            data_repo.initPreparedStatement(this.DELETE_MESSAGES_QUERY, this.DELETE_MESSAGES_QUERY);
            data_repo.initPreparedStatement(this.UNMARK_OFFLINE_MESSAGES_QUERY, this.UNMARK_OFFLINE_MESSAGES_QUERY);
            this.data_repo = data_repo;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Could not initialize repositiry", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Enum, Long> getMessagesCount(JID to) {
        try {
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = this.data_repo.getPreparedStatement(to.getBareJID(), this.GET_MESSAGES_COUNT_QUERY);
            HashMap<Enum, Long> hashMap = new HashMap<Enum, Long>();
            PreparedStatement preparedStatement2 = preparedStatement;
            synchronized (preparedStatement2) {
                try {
                    preparedStatement.setString(1, to.getBareJID().toString());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        Long l = resultSet.getLong(2);
                        hashMap.put(MSG_TYPES.getFromString(string), l);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, resultSet);
                    throw throwable;
                }
                this.data_repo.release(null, resultSet);
            }
            return hashMap;
        }
        catch (SQLException sQLException) {
            a.log(Level.SEVERE, "could not retrieve count of messages for user " + to, sQLException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> getMessagesList(JID to) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        try {
            PreparedStatement preparedStatement;
            ResultSet resultSet = null;
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(to.getBareJID(), this.GET_MESSAGES_LIST_QUERY);
            synchronized (preparedStatement2) {
                try {
                    preparedStatement.setString(1, to.getBareJID().toString());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        MSG_TYPES mSG_TYPES = MSG_TYPES.getFromString(resultSet.getString(4));
                        if (string3 == null || mSG_TYPES == MSG_TYPES.none || string == null) continue;
                        Element element = new Element("item", new String[]{"jid", "node", "type", "name"}, new String[]{to.getBareJID().toString(), string3, mSG_TYPES.name(), string2 != null ? string + "/" + string2 : string});
                        linkedList.add(element);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, resultSet);
                    throw throwable;
                }
                this.data_repo.release(null, resultSet);
            }
        }
        catch (SQLException sQLException) {
            a.log(Level.SEVERE, "could not retrieve count of messages for user " + to, sQLException);
        }
        return linkedList;
    }

    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        return this.loadMessagesToJID(null, session, delete, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Element> loadMessagesToJID(List<String> db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        LinkedList<Element> linkedList = null;
        BareJID bareJID = null;
        try {
            PreparedStatement preparedStatement;
            ResultSet resultSet = null;
            bareJID = session.getBareJID();
            linkedList = new LinkedList<Element>();
            String string = this.convertIdsToString(db_ids);
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(bareJID, this.GET_MESSAGES_QUERY);
            synchronized (preparedStatement2) {
                try {
                    preparedStatement.setString(1, bareJID.toString());
                    preparedStatement.setString(2, string);
                    resultSet = preparedStatement.executeQuery();
                    linkedList.addAll(this.parseLoadedMessages(proc, resultSet));
                    resultSet = null;
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, resultSet);
                    throw throwable;
                }
                this.data_repo.release(null, resultSet);
            }
            if (delete) {
                this.deleteMessagesToJID(db_ids, session);
            }
        }
        catch (SQLException sQLException) {
            a.log(Level.WARNING, "Problem getting offline messages for user: " + bareJID, sQLException);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.WARNING, "Session not authorized yet!", notAuthorizedException);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteMessagesToJID(List<String> db_ids, XMPPResourceConnection session) throws UserNotFoundException {
        int n = 0;
        BareJID bareJID = null;
        try {
            PreparedStatement preparedStatement;
            bareJID = session.getBareJID();
            boolean bl = this.a(session);
            String string = bl ? this.UNMARK_OFFLINE_MESSAGES_QUERY : this.DELETE_MESSAGES_QUERY;
            String string2 = this.convertIdsToString(db_ids);
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(bareJID, string);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, bareJID.toString());
                preparedStatement.setString(2, string2);
                n += preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            a.log(Level.WARNING, "Problem getting offline messages for user: " + bareJID, sQLException);
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.WARNING, "Session not authorized yet!", notAuthorizedException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
        Map<Enum, Long> map;
        long l = this.getMsgsStoreLimit(to.getBareJID(), userRepo);
        if (l != 0L && (map = this.getMessagesCount(to)) != null && map.containsKey((Object)MSG_TYPES.message) && map.get((Object)MSG_TYPES.message) >= l) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Message store limit ({0}) exceeded for message: {1}", new Object[]{l, Packet.elemToString((Element)msg)});
            }
            return false;
        }
        msg.addAttribute("tigase-offline", "true");
        boolean bl = false;
        try {
            for (ElementMatcher elementMatcher : this.archivingMatchers) {
                if (!elementMatcher.matches(Packet.packetInstance((Element)msg))) continue;
                bl = elementMatcher.getValue();
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!bl) {
            msg.addAttribute("tigase-offline-only", "true");
        }
        String string = msg.getChildAttributeStaticStr("delay", "stamp");
        Date date = null;
        if (string != null) {
            SimpleDateFormat simpleDateFormat = this.g;
            synchronized (simpleDateFormat) {
                try {
                    date = this.g.parse(string);
                }
                catch (ParseException parseException) {
                    a.log(Level.FINEST, "Failed to parse delay stamp = " + string);
                }
            }
        }
        if (date == null) {
            date = new Date();
        }
        this.unifiedArchiveComponent.archiveMessage(to.getBareJID(), from, date, msg, UUID.randomUUID().toString(), null);
        return true;
    }

    protected String convertIdsToString(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : ids) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private boolean a(XMPPResourceConnection xMPPResourceConnection) {
        try {
            return this.messageArchivePlugin.getSettings(xMPPResourceConnection.getBareJID(), xMPPResourceConnection).isAutoArchivingEnabled();
        }
        catch (NotAuthorizedException notAuthorizedException) {
            return false;
        }
    }

    public static enum MSG_TYPES {
        none(null),
        message("chat"),
        groupchat("groupchat"),
        presence("presence"),
        jingle("jingle"),
        call("call"),
        login("login"),
        logout("logout");

        private final String a;

        public static MSG_TYPES getFromString(String type) {
            if (type == null) {
                return none;
            }
            switch (type) {
                case "chat": {
                    return message;
                }
                case "groupchat": {
                    return groupchat;
                }
                case "presence": {
                    return presence;
                }
                case "call": {
                    return call;
                }
                case "jingle": {
                    return jingle;
                }
            }
            return none;
        }

        private MSG_TYPES(String value) {
            this.a = value;
        }

        public String getValue() {
            return this.a;
        }
    }
}

