/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified;

import java.util.Date;
import java.util.List;
import java.util.Set;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.archive.unified.db.UnifiedArchiveRepositoryPool;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="unified-archive", parent=Kernel.class, active=false)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
public class UnifiedArchiveComponent
extends MessageArchiveComponent {
    private static final String[] a = new String[]{"iq", "events"};
    @ConfigField(desc="Replace XMLNS in Jingle elements retrieved from repository with tigase:archive:jingle")
    private boolean omitJingleXMLNS = false;

    public UnifiedArchiveComponent() {
        this.setName("unified-archive");
    }

    public String getDiscoDescription() {
        return "Unified Archive Component";
    }

    public void register(Kernel kernel) {
        super.register(kernel);
        kernel.registerBean(UnifiedArchiveRepositoryPool.class).setActive(true).exec();
    }

    public void archiveMessage(BareJID owner, JID buddy, Date timestamp, Element msg, String stableId, Set<String> tags) {
        ((UnifiedArchiveRepository)this.msg_repo).archiveMessage(owner, buddy, timestamp, msg, stableId, tags);
    }

    protected boolean addOutPacket(Packet p) {
        List list;
        if (this.omitJingleXMLNS && p.getElemName() == "iq" && (list = p.getElement().getChildrenStaticStr(a)) != null) {
            for (Element element : list) {
                Element element2 = element.getChild("jingle", "urn:xmpp:jingle:1");
                if (element2 == null) continue;
                element2.setXMLNS("tigase:archive:jingle");
            }
        }
        return super.addOutPacket(p);
    }
}

