/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.UserRepository;
import tigase.db.UserRepositoryMDImpl;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.licence.Licence;
import tigase.licence.TOTP;
import tigase.licence.c;
import tigase.licence.utils.DataLoader;
import tigase.licence.utils.TooManyRequestsHTTPException;
import tigase.licence.utils.VHostsRetriever;
import tigase.server.XMPPServer;
import tigase.stats.collector.provider.HTTPException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class InstallationIdRetriever {
    private static final Logger a = Logger.getLogger(InstallationIdRetriever.class.getCanonicalName());
    private static final String b = "https://license.tigase.software/register";
    private static String c = null;
    private static InstallationIdRetriever d = null;
    private static long e = 0L;
    private final Path f;
    private final BareJID g;
    private DataLoader h;

    static InstallationIdRetriever a() {
        if (d == null) {
            d = new InstallationIdRetriever();
        }
        return d;
    }

    protected static String parseInstIdResponse(Element element) {
        if (element != null) {
            String string = element.getCDataStaticStr(new String[]{"command", "fields", "item", "var"});
            boolean bl = string != null && "installation-id".equals(string);
            String string2 = element.getCDataStaticStr(new String[]{"command", "fields", "item", "value"});
            if (!bl || string2 != null && string2.startsWith("Error")) {
                a.log(Level.WARNING, "There was an error obtaining installation-id! " + string2);
            }
            a.log(Level.FINE, "Retrieved installationId: {0} from request: {1}", new Object[]{string2, element});
            return string2;
        }
        return null;
    }

    private InstallationIdRetriever() {
        block3: {
            this.f = Paths.get("etc/installation-id", new String[0]);
            this.g = BareJID.bareJIDInstanceNS((String)"licence-library");
            this.h = new DataLoader();
            try {
                UserRepository userRepository = (UserRepository)((UserRepositoryMDImpl)XMPPServer.getComponent(UserRepositoryMDImpl.class)).getRepo(null);
                if (!userRepository.userExists(this.g)) {
                    userRepository.addUser(this.g);
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "There was a problem adding user {0} to the repository! Please make sure your database is configured correctly", new Object[]{this.g});
                if (!a.isLoggable(Level.FINEST)) break block3;
                a.log(Level.FINEST, "There was a problem adding user " + this.g + " to the repository! Please make sure your database is configured correctly", exception);
            }
        }
    }

    synchronized String b() {
        if ((System.currentTimeMillis() - e) / 1000L / 60L < 10L) {
            return c;
        }
        e = System.currentTimeMillis();
        if (c == null) {
            double d2 = 1.35;
            long l = 2L;
            int n = 1;
            int n2 = 0;
            do {
                try {
                    c = this.c();
                }
                catch (TooManyRequestsHTTPException tooManyRequestsHTTPException) {
                    n = 10;
                    l = tooManyRequestsHTTPException.getRetryAfter() + 5;
                    a.log(Level.WARNING, "Server returned error {0}: {1}; next retry in {2}s (retries left: {3})", new Object[]{tooManyRequestsHTTPException.getStatusCode(), tooManyRequestsHTTPException.getMessage(), l, n - n2});
                    try {
                        Thread.sleep(l * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        a.log(Level.FINE, "There was a problem delaying the subsequent request");
                    }
                }
                catch (IOException iOException) {
                    a.log(Level.WARNING, "Server returned error: {0}{1}; next retry in {2}s (retries left: {3})", new Object[]{iOException.getMessage(), iOException instanceof HTTPException ? ", code: " + ((HTTPException)iOException).getStatusCode() : "", l, n - n2});
                }
            } while (c == null && ++n2 < n);
        }
        return c;
    }

    protected Element loadData(String url, List<JID> managedVHosts, List<String> oldLicencesHashes) throws TooManyRequestsHTTPException, GeneralSecurityException, IOException {
        String string = this.a(managedVHosts, oldLicencesHashes);
        String string2 = url == null ? b : url;
        return this.h.loadData(string2, string);
    }

    private List<Licence> a(String string, boolean bl) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ArrayList<Licence> arrayList = new ArrayList<Licence>();
        Path path = Paths.get("./etc/", new String[0]);
        if (!path.toFile().exists()) {
            return null;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*.licence");){
            c c2 = new c();
            for (Path path2 : directoryStream) {
                Licence licence = c2.loadLicence(path2.toFile());
                String string2 = licence.getPropertyAsString(string);
                if (bl) {
                    if (string2 == null) continue;
                    arrayList.add(licence);
                    continue;
                }
                if (string2 != null) continue;
                arrayList.add(licence);
            }
        }
        catch (IOException iOException) {
            a.log(Level.WARNING, "There was a problem reading current licence files", iOException);
        }
        return arrayList;
    }

    private String a(List<JID> list, List<String> list2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<data><fields>");
        DataLoader.addRequestItems(stringBuffer, "vhosts", list);
        DataLoader.addRequestItems(stringBuffer, "legacy-hash", list2);
        TOTP tOTP = new TOTP();
        stringBuffer.append("<item><var>totp</var><value>").append(tOTP.generateTOTP()).append("</value></item>");
        stringBuffer.append("</fields></data>");
        return stringBuffer.toString();
    }

    private String c() throws TooManyRequestsHTTPException, IOException {
        String string;
        CharSequence charSequence;
        Object object;
        String string2 = null;
        try {
            object = (UserRepository)((UserRepositoryMDImpl)XMPPServer.getComponent(UserRepositoryMDImpl.class)).getRepo(null);
            string2 = object.getData(this.g, "installation-id");
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Retrieved installationID from database: {0}", new Object[]{string2});
            }
            if (this.a(string2)) {
                if (a.isLoggable(Level.WARNING)) {
                    a.log(Level.WARNING, "Retrieved installationID from database: {0}", new Object[]{string2});
                }
                return string2;
            }
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "There was a problem accessing repository to retrieve ID", exception.getMessage());
            if (a.isLoggable(Level.WARNING)) {
                a.log(Level.WARNING, "There was a problem accessing repository to retrieve ID", exception);
            }
            return null;
        }
        if (this.f.toFile().exists() && this.f.toFile().length() != 0L) {
            object = new Scanner(this.f);
            charSequence = new StringBuilder();
            while (((Scanner)object).hasNextLine()) {
                ((StringBuilder)charSequence).append(((Scanner)object).nextLine());
            }
            if (this.a(string2)) {
                a.log(Level.WARNING, "\n\n\n  =====================================\n  You already obtained installation-id: " + ((StringBuilder)charSequence).toString() + "\n  However it's not stored in the database which may result in cluster\n  not obtaining correct licences!\n  \n  Please make sure that database and cluster is working correctly!\n  =====================================\n\n");
                string2 = ((StringBuilder)charSequence).toString();
            }
        }
        object = (AbstractBeanConfigurator)XMPPServer.getComponent(AbstractBeanConfigurator.class);
        charSequence = (String)object.getProperties().get("installation-id");
        if (string2 == null && charSequence != null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Retrieved installationID from file: {0}", new Object[]{charSequence});
            }
            string2 = charSequence;
        }
        if (string2 == null) {
            try {
                string = this.d();
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Retrieved installationID from server: {0}", new Object[]{string});
                }
                if (string != null && !string.isEmpty()) {
                    string2 = string;
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                a.log(Level.WARNING, "There was a problem retrieving installation-id from the server", generalSecurityException);
            }
        }
        if (string2 == null) {
            boolean bl = false;
            String string3 = null;
            try {
                List<Licence> list = this.a("installation-id", true);
                if (list != null && !list.isEmpty()) {
                    for (Licence licence : list) {
                        String string4;
                        if (licence == null || (string4 = licence.getPropertyAsString("installation-id")) == null) continue;
                        if (string3 == null || string3.equals(string4)) {
                            string3 = string4;
                            bl = true;
                            continue;
                        }
                        if (string3.equals(string4)) continue;
                        bl = false;
                    }
                    if (bl && string3 != null) {
                        string2 = string3;
                    }
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
                a.log(Level.WARNING, "There was a problem retrieving installation-id from existing files", generalSecurityException);
            }
        }
        if (string2 != null) {
            try {
                string = (UserRepository)((UserRepositoryMDImpl)XMPPServer.getComponent(UserRepositoryMDImpl.class)).getRepo(null);
                string.setData(this.g, "installation-id", string2);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Stored installationID in database: {0}", string.getResourceUri());
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "There was a problem accessing repository to store ID", exception.getMessage());
            }
            try {
                if (!this.f.getParent().toFile().exists()) {
                    this.f.getParent().toFile().mkdirs();
                }
                Files.write(this.f, string2.getBytes(), new OpenOption[0]);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Stored installationID in file: {0}", new Object[]{this.f.toAbsolutePath()});
                }
            }
            catch (IOException iOException) {
                a.log(Level.WARNING, "There was a problem writing ID to a file", iOException);
            }
            a.log(Level.WARNING, "Your installation-id is: {0} and it has been written to database and to the file: {1}", new Object[]{string2, this.f.toAbsolutePath()});
        } else {
            a.log(Level.WARNING, "There was a problem obtaining installation-id! Please read 'Licensing' chapter from Tigase Administration Guide for more information how to obtain installation-id");
        }
        return string2;
    }

    private boolean a(String string) {
        return string != null && !string.startsWith("Error");
    }

    private String d() throws TooManyRequestsHTTPException, GeneralSecurityException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Licence> list = this.a("licence-nr", false);
        if (list != null && !list.isEmpty()) {
            list.forEach(licence -> arrayList.add(licence.getLicenceDigest()));
        }
        if (!arrayList.isEmpty()) {
            a.log(Level.WARNING, "Legacy licences present, if you want to obtain installation-id manually please include following digest codes in the form: {0})", arrayList);
        }
        Element element = this.loadData(null, VHostsRetriever.getManagedVHosts(), arrayList);
        return InstallationIdRetriever.parseInstIdResponse(element);
    }
}

