/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.RepositoryException;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.AffiliationChangedEvent;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.cluster.AbstractStrategy;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.StrategyIfc;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.PresenceModule;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class AbstractClusteredRoomStrategy
extends AbstractStrategy
implements Room.RoomListener,
InMemoryMucRepositoryClustered.RoomListener,
StrategyIfc {
    private static final Logger a = Logger.getLogger(AbstractClusteredRoomStrategy.class.getCanonicalName());
    private static final String b = "muc-sync-response";
    private static final String c = "muc-room-changed-cmd";
    private static final String d = "muc-room-created-cmd";
    private static final String e = "muc-room-destroyed-cmd";
    private static final String f = "muc-room-message-cmd";
    private static final String g = "muc-room-affiliation-cmd";
    private static final int h = 1000;
    protected final ConcurrentHashMap<BareJID, ConcurrentMap<JID, ConcurrentMap<BareJID, String>>> occupantsPerNode = new ConcurrentHashMap();
    @Inject
    private GroupchatMessageModule groupchatModule;

    @Override
    public void nodeDisconnected(JID nodeJid) {
        ConcurrentMap<JID, ConcurrentMap<BareJID, String>> concurrentMap = this.occupantsPerNode.remove(nodeJid.getBareJID());
        if (concurrentMap == null) {
            return;
        }
        List<JID> list = this.getNodesConnectedWithLocal();
        int n = list.indexOf(this.localNodeJid);
        int n2 = list.size();
        for (Map.Entry entry : concurrentMap.entrySet()) {
            JID jID = (JID)entry.getKey();
            boolean bl = !this.mucComponentClustered.isLocalDomain(jID.getDomain()) && jID.hashCode() % n2 == n;
            Map map = (Map)entry.getValue();
            if (map == null) continue;
            for (BareJID bareJID : map.keySet()) {
                try {
                    Room room = this.mucRepository.getRoom(bareJID);
                    if (room != null) {
                        this.sendRemoteOccupantRemovalOnDisconnect(room, jID, (String)map.get(bareJID), bl);
                        continue;
                    }
                    a.log(Level.FINER, "no room {0} in repository, while instance available in map of active rooms, propably room removed on other node but not yet synchronized?", bareJID);
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "exception retrieving occupants for room " + bareJID, exception);
                }
            }
        }
    }

    @Override
    public boolean processPacket(Packet packet) {
        JID jID = packet.getStanzaFrom();
        BareJID bareJID = this.getNodeForJID(jID);
        if (bareJID != null) {
            if (a.isLoggable(Level.FINER)) {
                a.log(Level.FINER, "forwarding packet to node = {1}", new Object[]{bareJID});
            }
            this.forwardPacketToNode(JID.jidInstance((BareJID)bareJID), packet);
            return true;
        }
        return false;
    }

    @Override
    public void setMucRepository(InMemoryMucRepositoryClustered mucRepository) {
        super.setMucRepository(mucRepository);
        mucRepository.setRoomListener(this);
        mucRepository.setRoomOccupantListener(this);
        try {
            RoomConfig roomConfig = mucRepository.getDefaultRoomConfig();
            roomConfig.setValue("muc#roomconfig_persistentroom", (Object)true);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void onRoomChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
        if (modifiedVars.isEmpty()) {
            return;
        }
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", roomConfig.getRoomJID().toString());
        for (String string : modifiedVars) {
            String[] stringArray = roomConfig.getConfigForm().getAsStrings(string);
            if (stringArray != null) {
                if (stringArray.length == 1) {
                    hashMap.put(string, stringArray[0]);
                    continue;
                }
                if (stringArray.length > 1) {
                    hashMap.put(string, Arrays.stream(stringArray).collect(Collectors.joining("|")));
                    continue;
                }
                hashMap.put(string, null);
                continue;
            }
            hashMap.put(string, null);
        }
        this.cl_controller.sendToNodes(c, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomCreated(Room room) {
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("creator", room.getCreatorJid().toString());
        hashMap.put("userId", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is created", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(d, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomDestroyed(Room room, Element destroyElement) {
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is destroyed", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(e, hashMap, destroyElement, this.localNodeJid, null, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onLeaveRoom(Room room) {
    }

    public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
    }

    public void onSetAffiliation(Room room, BareJID jid, RoomAffiliation oldAffiliation, RoomAffiliation newAffiliation) {
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", jid.toString());
        hashMap.put("newAffiliation", newAffiliation.getAffiliation().name());
        hashMap.put("newPersistent", String.valueOf(newAffiliation.isPersistentOccupant()));
        if (newAffiliation.getRegisteredNickname() != null) {
            hashMap.put("newNickname", newAffiliation.getRegisteredNickname());
        }
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] about new affiliation", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(g, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    public void onMessageToOccupants(Room room, JID from, Packet packet) {
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", from.toString());
        Element element = packet.getElement().clone();
        element.removeAttribute("from");
        element.removeAttribute("to");
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] about new message", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(f, hashMap, element, this.localNodeJid, null, list.toArray(new JID[list.size()]));
    }

    public BareJID getNodeForJID(JID jid) {
        if (this.mucComponentClustered.isLocalDomain(jid.getDomain())) {
            return null;
        }
        for (BareJID bareJID : this.occupantsPerNode.keySet()) {
            Map map = this.occupantsPerNode.get(bareJID);
            if (!map.containsKey(jid)) continue;
            if (bareJID.equals((Object)this.localNodeJid.getBareJID())) {
                return null;
            }
            return bareJID;
        }
        return null;
    }

    @Override
    protected boolean addOccupant(BareJID node, BareJID roomJid, JID occupantJid, String nickname) {
        Object object;
        Object object2;
        ConcurrentMap<JID, Object> concurrentMap = this.occupantsPerNode.get(node);
        if (concurrentMap == null && (concurrentMap = (ConcurrentMap<JID, Object>)this.occupantsPerNode.putIfAbsent(node, (ConcurrentMap<JID, ConcurrentMap<BareJID, String>>)(object2 = new ConcurrentHashMap()))) == null) {
            concurrentMap = object2;
        }
        if ((object2 = (ConcurrentMap)concurrentMap.get(occupantJid)) == null && (object2 = (ConcurrentMap)concurrentMap.putIfAbsent(occupantJid, object = new ConcurrentHashMap())) == null) {
            object2 = object;
        }
        return (object = object2.put(roomJid, nickname)) == null;
    }

    @Override
    protected boolean removeOccupant(BareJID node, BareJID roomJid, JID occupantJid) {
        Object object;
        Object object2;
        Map map = this.occupantsPerNode.get(node);
        if (map == null && (map = (ConcurrentMap)this.occupantsPerNode.putIfAbsent(node, (ConcurrentMap<JID, ConcurrentMap<BareJID, String>>)(object2 = new ConcurrentHashMap()))) == null) {
            map = object2;
        }
        if ((object2 = (Map)map.get(occupantJid)) == null && (object2 = (Map)map.putIfAbsent(occupantJid, object = new ConcurrentHashMap())) == null) {
            object2 = object;
        }
        object = (String)object2.remove(roomJid);
        if (object2.isEmpty()) {
            map.remove(occupantJid);
        }
        return object != null;
    }

    public boolean shouldSendOfflineMessageToJidFromLocalNode(BareJID jid) {
        return this.localNodeJid.equals((Object)this.getNodesConnectedWithLocal().get(jid.hashCode() % this.getNodesConnectedWithLocal().size()));
    }

    @Bean(name="muc-room-message-cmd", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class RoomMessageCmd
    extends CommandListenerAbstract {
        @Inject
        private GroupchatMessageModule groupchatModule;
        @Inject
        private InMemoryMucRepositoryClustered mucRepository;

        public RoomMessageCmd() {
            super(AbstractClusteredRoomStrategy.f, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("userId"));
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "executig RoomMessageCmd command for room = {0}, from = {1}, packets: {2}", new Object[]{bareJID, jID, packets});
            }
            try {
                Room room = this.mucRepository.getRoom(bareJID);
                Element element = packets.poll();
                Packet packet = Packet.packetInstance((Element)element);
                this.groupchatModule.sendMessagesToAllOccupantsJids(room, jID, packet);
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }

    @Bean(name="muc-room-destroyed-cmd", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class RoomDestroyedCmd
    extends CommandListenerAbstract {
        @Inject
        private InMemoryMucRepositoryClustered mucRepository;

        public RoomDestroyedCmd() {
            super(AbstractClusteredRoomStrategy.e, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "executig RoomDestroyedCmd command for room = {0}, packets: {1}", new Object[]{bareJID, packets});
            }
            try {
                Room room = this.mucRepository.getRoom(bareJID);
                Element element = packets.poll();
                for (JID jID : room.getAllOccupantsJID()) {
                    String string = room.getOccupantsNickname(jID);
                    Element element2 = new Element("presence");
                    element2.addAttribute("type", "unavailable");
                    PresenceModule.PresenceWrapper presenceWrapper = PresenceModule.PresenceWrapper.preparePresenceW((Room)room, (JID)jID, (Element)element2, (BareJID)jID.getBareJID(), Collections.singleton(jID), (String)string, (Affiliation)Affiliation.none, (Role)Role.none);
                    presenceWrapper.getX().addChild((XMLNodeIfc)element);
                }
                this.mucRepository.destroyRoomWithoutListener(room, element);
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }

    @Bean(name="muc-room-created-cmd", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class RoomCreatedCmd
    extends CommandListenerAbstract {
        @Inject
        private InMemoryMucRepositoryClustered mucRepository;

        public RoomCreatedCmd() {
            super(AbstractClusteredRoomStrategy.d, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            JID jID = JID.jidInstanceNS((String)data.get("creator"));
            try {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig RoomCreatedCmd command for room = {0}, creatorJid = {1}", new Object[]{bareJID, jID});
                }
                this.mucRepository.createNewRoomWithoutListener(bareJID, jID);
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
        }
    }

    @Bean(name="muc-room-changed-cmd", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class RoomChangedCmd
    extends CommandListenerAbstract {
        @Inject
        private InMemoryMucRepositoryClustered mucRepository;

        public RoomChangedCmd() {
            super(AbstractClusteredRoomStrategy.c, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.remove("room"));
            this.mucRepository.roomConfigChanged(bareJID, data);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was modified at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    @Bean(name="muc-room-affiliation-cmd", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class RoomAffiliationCmd
    extends CommandListenerAbstract {
        @Inject
        private InMemoryMucRepositoryClustered mucRepository;
        @Inject
        private EventBus eventBus;

        public RoomAffiliationCmd() {
            super(AbstractClusteredRoomStrategy.g, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            BareJID bareJID2 = BareJID.bareJIDInstanceNS((String)data.get("userId"));
            Affiliation affiliation = Affiliation.valueOf((String)data.get("newAffiliation"));
            boolean bl = Boolean.valueOf(data.get("newPersistent"));
            String string = data.get("newNickname");
            RoomAffiliation roomAffiliation = RoomAffiliation.from((Affiliation)affiliation, (boolean)bl, (String)string);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "executig RoomAffiliationCmd command for room = {0}, from = {1}, newAffiliation: {2}", new Object[]{bareJID, bareJID2, roomAffiliation});
            }
            try {
                Room room = this.mucRepository.getRoom(bareJID);
                if (room != null) {
                    RoomAffiliation roomAffiliation2 = room.getAffiliation(bareJID2);
                    room.setNewAffiliation(bareJID2, roomAffiliation);
                    this.eventBus.fire((Object)new AffiliationChangedEvent(room, bareJID2, roomAffiliation2, roomAffiliation));
                }
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
        }
    }

    @Bean(name="muc-sync-response", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class ResponseSyncCmd
    extends CommandListenerAbstract {
        @Inject
        private AbstractClusteredRoomStrategy strategy;

        public ResponseSyncCmd() {
            super(AbstractClusteredRoomStrategy.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig ResponseSyncCmd command fromNode = {0}, packets: {1}", new Object[]{fromNode, packets});
                }
                for (Element element : packets) {
                    if (element.getName() != "occupant") continue;
                    JID jID = JID.jidInstanceNS((String)element.getAttributeStaticStr("jid"));
                    List list = element.getChildren();
                    if (list == null || list.isEmpty()) continue;
                    for (Element element2 : list) {
                        BareJID bareJID = BareJID.bareJIDInstanceNS((String)element2.getAttributeStaticStr("jid"));
                        String string = element2.getAttributeStaticStr("nickname");
                        this.strategy.addOccupant(fromNode.getBareJID(), bareJID, jID, string);
                    }
                }
            }
        }
    }

    @Bean(name="muc-sync-request", parent=AbstractClusteredRoomStrategy.class, active=true)
    public static class RequestSyncCmd
    extends CommandListenerAbstract {
        @Inject
        private AbstractClusteredRoomStrategy strategy;

        public RequestSyncCmd() {
            super("muc-sync-request", Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            ConcurrentMap<JID, ConcurrentMap<BareJID, String>> concurrentMap = this.strategy.occupantsPerNode.get(this.strategy.localNodeJid.getBareJID());
            LinkedList<Element> linkedList = new LinkedList<Element>();
            if (concurrentMap != null) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig RequestSyncCmd command fromNode = {0}, nodeOccupants = {1}", new Object[]{fromNode, concurrentMap});
                }
                for (Map.Entry entry : concurrentMap.entrySet()) {
                    Element element = new Element("occupant", new String[]{"jid"}, new String[]{((JID)entry.getKey()).toString()});
                    Map map = (Map)entry.getValue();
                    for (Map.Entry entry2 : map.entrySet()) {
                        element.addChild((XMLNodeIfc)new Element("room", new String[]{"jid", "nickname"}, new String[]{((BareJID)entry2.getKey()).toString(), (String)entry2.getValue()}));
                    }
                    linkedList.add(element);
                    if (linkedList.size() <= 1000) continue;
                    this.strategy.cl_controller.sendToNodes(AbstractClusteredRoomStrategy.b, linkedList, this.strategy.localNodeJid, null, new JID[]{fromNode});
                    linkedList = new LinkedList();
                }
            }
            if (!linkedList.isEmpty()) {
                this.strategy.cl_controller.sendToNodes(AbstractClusteredRoomStrategy.b, linkedList, this.strategy.localNodeJid, null, new JID[]{fromNode});
            }
        }
    }
}

