/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashSet;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.server.amp.db.MsgBroadcastRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="server-offline-message-broadcast", name="Tigase XMPP Server (Offline Messages [broadcast])", external=false)
public class MongoMsgBroadcastRepository
extends MsgBroadcastRepository<ObjectId, MongoDataSource> {
    private static final Logger log = Logger.getLogger(MongoMsgBroadcastRepository.class.getCanonicalName());
    private static final String JID_HASH_ALG = "SHA-256";
    private static final int DEF_BATCH_SIZE = 100;
    private static final String MSG_BROADCAST_COLLECTION = "tig_broadcast_messages";
    private static final String MSG_BROADCAST_RECP_COLLECTION = "tig_broadcast_recipients";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoCollection<Document> broadcastMsgCollection;
    private MongoCollection<Document> broadcastMsgRecpCollection;
    private MongoDatabase db;

    protected void ensureBroadcastMessageRecipient(String id, BareJID recipient) {
        try {
            byte[] recipientId = this.generateId(recipient);
            Document crit = new Document("msg_id", (Object)id).append("recipient_id", (Object)recipientId).append("recipient", (Object)recipient.toString());
            this.broadcastMsgRecpCollection.updateOne((Bson)crit, Updates.set((String)"recipient_id", (Object)recipientId), new UpdateOptions().upsert(true));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem inserting messages recipients for broadcast to db: ", ex);
        }
    }

    private byte[] generateId(BareJID user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.toString().getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    protected void insertBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
        try {
            this.broadcastMsgCollection.updateOne((Bson)new Document("_id", (Object)id), (Bson)new Document("$setOnInsert", (Object)new Document("expire", (Object)expire).append("msg", (Object)msg.toString())), new UpdateOptions().upsert(true));
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, "Problem inserting messages for broadcast to db: ", ex);
        }
    }

    public void loadMessagesToBroadcast() {
        try {
            HashSet oldMessages = new HashSet(this.broadcastMessages.keySet());
            FindIterable cursor = this.broadcastMsgCollection.find((Bson)new Document("expire", (Object)new Document("$gt", (Object)new Date()))).batchSize(this.batchSize);
            DomBuilderHandler domHandler = new DomBuilderHandler();
            for (Document dto : cursor) {
                String id = dto.getString((Object)"_id");
                oldMessages.remove(id);
                if (this.broadcastMessages.containsKey(id)) continue;
                Date expire = (Date)dto.get((Object)"expire");
                char[] msgChars = ((String)dto.get((Object)"msg")).toCharArray();
                this.parser.parse((SimpleHandler)domHandler, msgChars, 0, msgChars.length);
                Queue elems = domHandler.getParsedElements();
                Element msg = (Element)elems.poll();
                if (msg == null) continue;
                this.broadcastMessages.put(id, new MsgBroadcastRepository.BroadcastMsg((MsgBroadcastRepository)this, null, msg, expire));
            }
            for (String key : oldMessages) {
                this.broadcastMessages.remove(key);
            }
            this.broadcastMessages.entrySet().forEach(e -> this.broadcastMsgRecpCollection.find((Bson)new Document("msg_id", e.getKey())).forEach(dto -> {
                JID recipient = JID.jidInstanceNS((String)dto.getString((Object)"recipient"));
                ((MsgBroadcastRepository.BroadcastMsg)e.getValue()).markAsSent(recipient);
            }));
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, "Problem loading messages for broadcast from db: ", ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, MSG_BROADCAST_COLLECTION)) {
            if (Helper.collectionExists(this.db, "msg_broadcast")) {
                this.db.getCollection("msg_broadcast").renameCollection(new MongoNamespace(this.db.getName(), MSG_BROADCAST_COLLECTION));
            } else {
                this.db.createCollection(MSG_BROADCAST_COLLECTION);
            }
        }
        this.broadcastMsgCollection = this.db.getCollection(MSG_BROADCAST_COLLECTION);
        this.broadcastMsgCollection.createIndex((Bson)new Document("_id", (Object)1).append("expire", (Object)1));
        if (!Helper.collectionExists(this.db, MSG_BROADCAST_RECP_COLLECTION)) {
            if (Helper.collectionExists(this.db, "msg_broadcast_recp")) {
                this.db.getCollection("msg_broadcast_recp").renameCollection(new MongoNamespace(this.db.getName(), MSG_BROADCAST_RECP_COLLECTION));
            } else {
                this.db.createCollection(MSG_BROADCAST_RECP_COLLECTION);
            }
        }
        this.broadcastMsgRecpCollection = this.db.getCollection(MSG_BROADCAST_RECP_COLLECTION);
        this.broadcastMsgRecpCollection.createIndex((Bson)new Document("msg_id", (Object)1));
        this.broadcastMsgRecpCollection.createIndex((Bson)new Document("msg_id", (Object)1).append("recipient_id", (Object)1), new IndexOptions().unique(true));
    }
}

