/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam.modules;

import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.Module;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.QueryParser;

@Bean(name="mamQueryModule", active=true)
public class QueryModule
implements Module {
    private static final String[] FEATURES = new String[]{"urn:xmpp:mam:1"};
    @Inject(bean="mamItemHandler")
    private MAMRepository.ItemHandler itemHandler;
    @Inject
    private MAMRepository mamRepository;
    @Inject
    private PacketWriter packetWriter;
    @Inject(bean="mamQueryParser")
    private QueryParser queryParser;
    private static final System.Logger log = System.getLogger(QueryModule.class.getName());

    @Override
    public String[] getFeatures() {
        return (String[])this.queryParser.getXMLNSs().toArray(String[]::new);
    }

    @Override
    public Criteria getModuleCriteria() {
        return null;
    }

    @Override
    public boolean canHandle(Packet packet) {
        return packet.getElement().findChild(child -> child.getName() == "query" && this.isXMLNSSupported(child.getXMLNS())) != null && packet.getType() == StanzaType.set;
    }

    protected boolean isXMLNSSupported(String xmlns) {
        return this.queryParser.getXMLNSs().contains(xmlns);
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Object query = this.queryParser.parseQuery(this.mamRepository.newQuery(), packet);
        log.log(System.Logger.Level.TRACE, () -> "Retrieving items for packet: " + packet + " using query: " + query);
        try {
            this.mamRepository.queryItems(query, this.itemHandler);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Error retrieving messages from database", ex);
        }
        Element fin = new Element("fin");
        fin.setXMLNS(query.getXMLNS());
        fin.addChild((XMLNodeIfc)query.getRsm().toElement());
        if (query.getRsm().getIndex() + query.getRsm().getMax() >= query.getRsm().getCount()) {
            fin.setAttribute("complete", "true");
        }
        Packet result = packet.okResult(fin, 0);
        result.setPacketFrom(null);
        result.setPriority(Priority.LOW);
        this.packetWriter.write(result);
    }
}

