/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.conf.ConfigReader;
import tigase.kernel.TypesConverter;
import tigase.kernel.beans.Bean;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.CmdAcl;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="defaultTypesConverter", active=true)
public class DefaultTypesConverter
implements TypesConverter {
    private static final String[] decoded = new String[]{","};
    private static final String[] encoded = new String[]{"\\,"};
    private static final String[] decoded_1 = new String[]{","};
    private static final String[] encoded_1 = new String[]{"\\,"};
    private static final String regex = "(?<!\\\\)" + Pattern.quote(",");

    public static String escape(String input) {
        if (input != null) {
            return XMLUtils.translateAll((String)input, (String[])decoded, (String[])encoded);
        }
        return null;
    }

    public static String unescape(String input) {
        if (input != null) {
            return XMLUtils.translateAll((String)input, (String[])encoded_1, (String[])decoded_1);
        }
        return null;
    }

    @Override
    public <T> T convert(Object value, Class<T> expectedType) {
        return this.convert(value, expectedType, null);
    }

    public <T> T convert(Object value, Type type) {
        ParameterizedType pt;
        if (type instanceof Class) {
            return this.convert(value, (Class)type);
        }
        if (type instanceof ParameterizedType && (pt = (ParameterizedType)type).getRawType() instanceof Class) {
            return this.convert(value, (Class)pt.getRawType(), pt);
        }
        throw new RuntimeException("Cannot convert to " + type);
    }

    @Override
    public <T> T convert(Object value, Class<T> expectedType, Type genericType) {
        try {
            Class<?> currentType;
            if (value == null) {
                return null;
            }
            if ("null".equals(value)) {
                return null;
            }
            if (value instanceof ConfigReader.Variable) {
                value = ((ConfigReader.Variable)value).calculateValue();
            }
            if (expectedType.isAssignableFrom(currentType = value.getClass()) && genericType == null) {
                return expectedType.cast(value);
            }
            T customResult = this.customConversion(value, expectedType, genericType);
            if (customResult != null) {
                return customResult;
            }
            if (expectedType.equals(Class.class)) {
                try {
                    return expectedType.cast(ModulesManagerImpl.getInstance().forName(value.toString().trim()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Cannot convert to " + expectedType, e);
                }
            }
            if (expectedType.equals(File.class)) {
                if (value instanceof Collection || value instanceof Map) {
                    throw new RuntimeException("Cannot convert " + value + " to " + expectedType);
                }
                return expectedType.cast(new File(value.toString().trim()));
            }
            if (expectedType.equals(Level.class)) {
                return expectedType.cast(Level.parse(value.toString().trim()));
            }
            if (expectedType.isEnum()) {
                String trimmedValue = value.toString().trim();
                Class<T> enumType = expectedType;
                try {
                    T theOneAndOnly = Enum.valueOf(enumType, trimmedValue);
                    return expectedType.cast(theOneAndOnly);
                }
                catch (IllegalArgumentException ex) {
                    Optional<Object> theOneAndOnly = EnumSet.allOf(enumType).stream().filter(val -> trimmedValue.equalsIgnoreCase(((Enum)val).name())).findFirst();
                    if (theOneAndOnly.isPresent()) {
                        return expectedType.cast(theOneAndOnly.get());
                    }
                    throw new RuntimeException("Cannot convert to " + expectedType, ex);
                }
            }
            if (expectedType.equals(JID.class)) {
                if (value instanceof Collection || value instanceof Map) {
                    throw new RuntimeException("Cannot convert " + value + " to " + expectedType);
                }
                return expectedType.cast(JID.jidInstance((String)value.toString().trim()));
            }
            if (expectedType.equals(BareJID.class)) {
                if (value instanceof Collection || value instanceof Map) {
                    throw new RuntimeException("Cannot convert " + value + " to " + expectedType);
                }
                return expectedType.cast(BareJID.bareJIDInstance((String)value.toString().trim()));
            }
            if (expectedType.equals(CmdAcl.class)) {
                return expectedType.cast(new CmdAcl(value.toString().trim()));
            }
            if (expectedType.equals(String.class)) {
                if (value instanceof Collection || value instanceof Map) {
                    throw new RuntimeException("Cannot convert " + value + " to " + expectedType);
                }
                return expectedType.cast(String.valueOf(value.toString().trim()));
            }
            if (expectedType.equals(Long.class)) {
                return expectedType.cast(Long.valueOf(value.toString().trim()));
            }
            if (expectedType.equals(Integer.class)) {
                return expectedType.cast(Integer.valueOf(value.toString().trim()));
            }
            if (expectedType.equals(Boolean.class)) {
                String val2 = value.toString().trim();
                boolean b = val2.equalsIgnoreCase("yes") || val2.equalsIgnoreCase("true") || val2.equalsIgnoreCase("on") || val2.equals("1");
                return expectedType.cast(b);
            }
            if (expectedType.equals(Float.class)) {
                return expectedType.cast(Float.valueOf(value.toString().trim()));
            }
            if (expectedType.equals(Double.class)) {
                return expectedType.cast(Double.valueOf(value.toString().trim()));
            }
            if (expectedType.equals(Character.TYPE)) {
                String v = value.toString().trim();
                if (v.length() == 1) {
                    return (T)Character.valueOf(v.charAt(0));
                }
                throw new RuntimeException("Cannot convert '" + v + "' to char.");
            }
            if (expectedType.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(value.toString().trim());
            }
            if (expectedType.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(value.toString().trim());
            }
            if (expectedType.equals(Long.TYPE)) {
                return (T)Long.valueOf(value.toString().trim());
            }
            if (expectedType.equals(Double.TYPE)) {
                return (T)Double.valueOf(value.toString().trim());
            }
            if (expectedType.equals(Short.TYPE)) {
                return (T)Short.valueOf(value.toString().trim());
            }
            if (expectedType.equals(Float.TYPE)) {
                return (T)Float.valueOf(value.toString().trim());
            }
            if (expectedType.equals(Boolean.TYPE)) {
                String val3 = value.toString().trim();
                boolean b = val3.equalsIgnoreCase("yes") || val3.equalsIgnoreCase("true") || val3.equalsIgnoreCase("on") || val3.equals("1");
                return (T)Boolean.valueOf(b);
            }
            if (expectedType.equals(Duration.class)) {
                return (T)Duration.parse(value.toString().trim());
            }
            if (expectedType.equals(byte[].class) && value.toString().startsWith("string:")) {
                return (T)value.toString().substring(7).getBytes();
            }
            if (expectedType.equals(byte[].class) && value.toString().startsWith("base64:")) {
                return (T)Base64.decode((String)value.toString().substring(7));
            }
            if (expectedType.equals(char[].class) && value.toString().startsWith("string:")) {
                return (T)value.toString().substring(7).toCharArray();
            }
            if (expectedType.equals(char[].class) && value.toString().startsWith("base64:")) {
                return (T)new String(Base64.decode((String)value.toString().substring(7))).toCharArray();
            }
            if (expectedType.isArray()) {
                if (value instanceof Collection) {
                    Collection col = (Collection)value;
                    Object result = Array.newInstance(expectedType.getComponentType(), col.size());
                    Iterator it = col.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Object v = it.next();
                        if (v instanceof ConfigReader.Variable) {
                            v = ((ConfigReader.Variable)v).calculateValue();
                        }
                        Array.set(result, i, v instanceof String ? this.convert((Object)DefaultTypesConverter.unescape((String)v), expectedType.getComponentType()) : v);
                        ++i;
                    }
                    return (T)result;
                }
                String[] a_str = value.toString().split(regex);
                Object result = Array.newInstance(expectedType.getComponentType(), a_str.length);
                for (int i = 0; i < a_str.length; ++i) {
                    Array.set(result, i, this.convert((Object)DefaultTypesConverter.unescape(a_str[i]), expectedType.getComponentType()));
                }
                return (T)result;
            }
            if (TypesConverter.Parcelable.class.isAssignableFrom(expectedType)) {
                try {
                    T obj = expectedType.newInstance();
                    String[] v = this.convert(value, String[].class);
                    ((TypesConverter.Parcelable)obj).fillFromString(v);
                    return obj;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException("Unsupported conversion (parcel) to " + expectedType, ex);
                }
            }
            if (EnumSet.class.isAssignableFrom(expectedType) && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] actualTypes = pt.getActualTypeArguments();
                if (actualTypes[0] instanceof Class) {
                    String[] a_str = value.toString().split(regex);
                    HashSet<Enum> result = new HashSet<Enum>();
                    for (int i = 0; i < a_str.length; ++i) {
                        result.add((Enum)this.convert((Object)DefaultTypesConverter.unescape(a_str[i]), (Class)actualTypes[0]));
                    }
                    return (T)EnumSet.copyOf(result);
                }
            } else {
                if (Pattern.class.isAssignableFrom(expectedType)) {
                    return (T)Pattern.compile(value.toString());
                }
                if (Collection.class.isAssignableFrom(expectedType) && genericType != null) {
                    ParameterizedType pt;
                    Type[] actualTypes;
                    int mod = expectedType.getModifiers();
                    if ((Modifier.isInterface(mod) || !Modifier.isAbstract(mod)) && genericType instanceof ParameterizedType && (actualTypes = (pt = (ParameterizedType)genericType).getActualTypeArguments())[0] instanceof Class) {
                        Stream<Object> stream = this.valueToStream(value, (Class)actualTypes[0]);
                        if (stream == null) {
                            return null;
                        }
                        if (Modifier.isInterface(mod)) {
                            if (expectedType.isAssignableFrom(List.class)) {
                                return (T)stream.collect(Collectors.toUnmodifiableList());
                            }
                            if (expectedType.isAssignableFrom(Set.class)) {
                                return (T)stream.collect(Collectors.toUnmodifiableSet());
                            }
                            throw new RuntimeException("Unsupported conversion to " + expectedType);
                        }
                        try {
                            Collection result = (Collection)expectedType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            stream.forEach(result::add);
                            return (T)result;
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                            throw new RuntimeException("Unsupported conversion to " + expectedType, ex);
                        }
                    }
                } else if (Map.class.isAssignableFrom(expectedType) && genericType instanceof ParameterizedType && value instanceof Map) {
                    int mod = expectedType.getModifiers();
                    Map<T, T> result = null;
                    if (!Modifier.isAbstract(mod) && !Modifier.isInterface(mod)) {
                        try {
                            result = (Map)expectedType.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException ex) {
                            throw new RuntimeException("Unsupported conversion to " + expectedType, ex);
                        }
                    } else if (value instanceof Map) {
                        result = new HashMap();
                    }
                    if (result != null) {
                        ParameterizedType pt = (ParameterizedType)genericType;
                        Type[] actualTypes = pt.getActualTypeArguments();
                        for (Map.Entry e : ((Map)value).entrySet()) {
                            T k = this.convert((Object)DefaultTypesConverter.unescape((String)e.getKey()), actualTypes[0]);
                            T v = e.getValue() instanceof String ? this.convert((Object)DefaultTypesConverter.unescape((String)e.getValue()), actualTypes[1]) : this.convert(e.getValue(), actualTypes[1]);
                            result.put(k, v);
                        }
                        return (T)result;
                    }
                } else {
                    try {
                        Class<?> cls = ModulesManagerImpl.getInstance().forName(value.toString());
                        if (expectedType.isAssignableFrom(cls)) {
                            return (T)cls.newInstance();
                        }
                    }
                    catch (ClassNotFoundException cls) {
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        throw new RuntimeException("Could not instantiate instance of " + value.toString());
                    }
                }
            }
            throw new RuntimeException("Unsupported conversion to " + expectedType);
        }
        catch (TigaseStringprepException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <T> Stream<T> valueToStream(Object value, Class<T> actualType) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            return Stream.iterate(0, i -> i + 1).limit(size).map(i -> Array.get(value, i)).map(v -> this.convert(v, actualType));
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(v -> this.convert(v, actualType));
        }
        return this.valueToStream(value.toString().split(regex), actualType);
    }

    protected <T> T customConversion(Object value, Class<T> expectedType, Type genericType) {
        return null;
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TypesConverter.Parcelable) {
            return this.toString(((TypesConverter.Parcelable)value).encodeToStrings());
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        if (value instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                sb.append(DefaultTypesConverter.escape(this.toString(it.next())));
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            int l = Array.getLength(value);
            for (int i = 0; i < l; ++i) {
                Object o = Array.get(value, i);
                sb.append(DefaultTypesConverter.escape(this.toString(o)));
                if (i + 1 >= l) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        if (value instanceof ConfigReader.Variable) {
            return this.toString(((ConfigReader.Variable)value).calculateValue());
        }
        return value.toString();
    }
}

