/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.db.DataRepository;
import tigase.muc.Room;
import tigase.muc.history.AbstractJDBCHistoryProvider;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class SqlserverSqlHistoryProvider
extends AbstractJDBCHistoryProvider {
    public static final String ADD_MESSAGE_QUERY_VAL = "insert into muc_history (room_name, event_type, timestamp, sender_jid, sender_nickname, body, public_event, msg) values (?, 1, ?, ?, ?, ?, ?, ?)";
    public static final String DELETE_MESSAGES_QUERY_VAL = "delete from muc_history where room_name=?";
    public static final String GET_MESSAGES_MAXSTANZAS_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from (select top (?) * from muc_history where room_name=? order by timestamp desc  ) AS t order by t.timestamp";
    public static final String GET_MESSAGES_SINCE_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from (select top (?) * from muc_history where room_name= ? and timestamp >= ? order by timestamp desc  ) AS t order by t.timestamp";
    public static final String CHECK_TEXT_FIELD_INVALID_TYPES = "select 1 from [INFORMATION_SCHEMA].[COLUMNS] where [TABLE_NAME] = 'muc_history' and ([COLUMN_NAME] = 'body' or [COLUMN_NAME] = 'msg') and [DATA_TYPE] = 'TEXT' and [TABLE_CATALOG] = DB_NAME()";
    private static final String CREATE_MUC_HISTORY_TABLE_VAL = "create table muc_history (room_name nvarchar(128) NOT NULL,\nevent_type int, \ntimestamp bigint,\nsender_jid nvarchar(2049),\nsender_nickname nvarchar(128),\nbody nvarchar(max),\npublic_event bit,\n msg nvarchar(max) )";
    private Logger log = Logger.getLogger(this.getClass().getName());

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        block27: {
            String roomJID = room.getRoomJID().toString();
            int maxMessages = room.getConfig().getMaxHistory();
            try {
                PreparedStatement st;
                ResultSet rs;
                block30: {
                    PreparedStatement st2;
                    block29: {
                        PreparedStatement st3;
                        block28: {
                            PreparedStatement st4;
                            rs = null;
                            if (since == null) break block28;
                            if (this.log.isLoggable(Level.FINEST)) {
                                this.log.finest("Using SINCE selector: roomJID=" + roomJID + ", since=" + since.getTime() + " (" + since + ")");
                            }
                            PreparedStatement preparedStatement = st4 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_SINCE_QUERY_KEY");
                            synchronized (preparedStatement) {
                                try {
                                    st4.setInt(1, maxMessages);
                                    st4.setString(2, roomJID);
                                    st4.setLong(3, since.getTime());
                                    rs = st4.executeQuery();
                                    this.processResultSet(room, senderJID, writer, rs);
                                }
                                catch (Throwable throwable) {
                                    this.dataRepository.release(null, rs);
                                    throw throwable;
                                }
                                this.dataRepository.release(null, rs);
                                break block27;
                            }
                        }
                        if (maxstanzas == null) break block29;
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("Using MAXSTANZAS selector: roomJID=" + roomJID + ", maxstanzas=" + maxstanzas);
                        }
                        PreparedStatement preparedStatement = st3 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                        synchronized (preparedStatement) {
                            try {
                                st3.setInt(1, Math.min(maxstanzas, maxMessages));
                                st3.setString(2, roomJID);
                                this.log.log(Level.FINEST, "getHistoryMessages: " + st3 + " || \t GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                                rs = st3.executeQuery();
                                this.processResultSet(room, senderJID, writer, rs);
                            }
                            catch (Throwable throwable) {
                                this.dataRepository.release(null, rs);
                                throw throwable;
                            }
                            this.dataRepository.release(null, rs);
                            break block27;
                        }
                    }
                    if (seconds == null) break block30;
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Using SECONDS selector: roomJID=" + roomJID + ", seconds=" + seconds);
                    }
                    PreparedStatement preparedStatement = st2 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_SINCE_QUERY_KEY");
                    synchronized (preparedStatement) {
                        try {
                            st2.setInt(1, maxMessages);
                            st2.setString(2, roomJID);
                            st2.setLong(3, new Date().getTime() - (long)(seconds * 1000));
                            rs = st2.executeQuery();
                            this.processResultSet(room, senderJID, writer, rs);
                        }
                        catch (Throwable throwable) {
                            this.dataRepository.release(null, rs);
                            throw throwable;
                        }
                        this.dataRepository.release(null, rs);
                        break block27;
                    }
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Using DEFAULT selector: roomJID=" + roomJID);
                }
                PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                synchronized (preparedStatement) {
                    try {
                        st.setInt(1, maxMessages);
                        st.setString(2, roomJID);
                        this.log.log(Level.FINEST, "getHistoryMessages: " + st.toString() + " max " + maxMessages + " roomJID " + roomJID + " || \t GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                        rs = st.executeQuery();
                        this.processResultSet(room, senderJID, writer, rs);
                    }
                    catch (Throwable throwable) {
                        this.dataRepository.release(null, rs);
                        throw throwable;
                    }
                    this.dataRepository.release(null, rs);
                }
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "Can't get history", e);
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void init(DataRepository dataRepository) {
        try {
            dataRepository.checkTable("muc_history", CREATE_MUC_HISTORY_TABLE_VAL);
            this.internalInit(dataRepository);
        }
        catch (SQLException e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Initializing problem", e);
            }
            try {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Trying to create tables: create table muc_history (room_name nvarchar(128) NOT NULL,\nevent_type int, \ntimestamp bigint,\nsender_jid nvarchar(2049),\nsender_nickname nvarchar(128),\nbody nvarchar(max),\npublic_event bit,\n msg nvarchar(max) )");
                }
                Statement st = dataRepository.createStatement(null);
                st.execute(CREATE_MUC_HISTORY_TABLE_VAL);
                this.internalInit(dataRepository);
            }
            catch (SQLException e1) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Can't initialize muc history", e1);
                }
                throw new RuntimeException(e1);
            }
        }
    }

    @Override
    public void setDataSource(DataRepository dataSource) {
        this.init(dataSource);
        super.setDataSource(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInit(DataRepository dataRepository) throws SQLException {
        Statement stmt = dataRepository.createStatement(null);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(CHECK_TEXT_FIELD_INVALID_TYPES);
            if (rs.next()) {
                rs.close();
                rs = null;
                stmt.execute("alter table [dbo].[muc_history] alter column msg nvarchar(MAX)");
                stmt.execute("alter table [dbo].[muc_history] alter column body nvarchar(MAX)");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        dataRepository.initPreparedStatement("ADD_MESSAGE_QUERY_KEY", ADD_MESSAGE_QUERY_VAL);
        dataRepository.initPreparedStatement("DELETE_MESSAGES_QUERY_KEY", DELETE_MESSAGES_QUERY_VAL);
        dataRepository.initPreparedStatement("GET_MESSAGES_SINCE_QUERY_KEY", GET_MESSAGES_SINCE_QUERY_VAL);
        dataRepository.initPreparedStatement("GET_MESSAGES_MAXSTANZAS_QUERY_KEY", GET_MESSAGES_MAXSTANZAS_QUERY_VAL);
    }
}

