/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.ACSInfoPage;
import tigase.http.modules.setup.pages.AboutSoftwarePage;
import tigase.http.modules.setup.pages.AdvConfigPage;
import tigase.http.modules.setup.pages.AdvancedConfigPage;
import tigase.http.modules.setup.pages.BasicConfigPage;
import tigase.http.modules.setup.pages.ConnectorsPage;
import tigase.http.modules.setup.pages.DBCheckPage;
import tigase.http.modules.setup.pages.DBSetupPage;
import tigase.http.modules.setup.pages.FeaturesPage;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.pages.PluginsConfigPage;
import tigase.http.modules.setup.pages.SaveConfigPage;
import tigase.http.modules.setup.pages.SetupSecurityPage;
import tigase.http.modules.setup.pages.SimpleConfigPage;
import tigase.http.modules.setup.questions.Question;

public class Setup {
    private final Config config = new Config();
    private final List<Page> pages = new ArrayList<Page>();

    public Setup() {
        this.addPage(new AboutSoftwarePage());
        this.addPage(new ACSInfoPage(this.config));
        this.addPage(new BasicConfigPage(this.config));
        this.addPage(new ConnectorsPage(this.config));
        this.addPage(new FeaturesPage(this.config));
        this.addPage(new AdvConfigPage(this.config));
        this.addPage(new PluginsConfigPage(this.config));
        this.addPage(new DBSetupPage(this.config));
        this.addPage(new DBCheckPage(this.config));
        this.addPage(new SetupSecurityPage(this.config));
        this.addPage(new SaveConfigPage(this.config));
        this.addPage(new Page("Finished", "finished.html", new Question[0]));
    }

    private void addPage(Page page) {
        page.init(this);
        this.pages.add(page);
    }

    public Page getPageById(int page) {
        int i = 0;
        while (i < page - 1) {
            Page p = this.getPages().get(i);
            if (!p.isValid()) {
                return p;
            }
            ++i;
        }
        return this.getPages().get(page - 1);
    }

    public int pageId(Page page) {
        if (page == null) {
            return 1;
        }
        return this.getPages().indexOf(page) + 1;
    }

    public int nextPageId(Page page) {
        if (page == null) {
            return 1;
        }
        return this.getPages().indexOf(page) + 2;
    }

    public List<Page> getPages() {
        return this.pages.stream().filter(page -> this.config.advancedConfig ? !(page instanceof SimpleConfigPage) : !(page instanceof AdvancedConfigPage)).collect(Collectors.toList());
    }

    public List<String> getTemplates() {
        return this.pages.stream().map(Page::getTemplate).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

