/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.util.Optional;
import java.util.Queue;
import javax.script.Bindings;
import tigase.db.comp.RepositoryItem;
import tigase.http.modules.rest.AbstractApiKeyCmd;
import tigase.http.modules.rest.ApiKeyItem;
import tigase.http.modules.rest.ApiKeyRepository;
import tigase.http.modules.rest.RestModule;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;

public class ApiKeyAddCmd
extends AbstractApiKeyCmd {
    public ApiKeyAddCmd(RestModule module) {
        super(module);
    }

    public String getCommandId() {
        return "api-key-add";
    }

    public String getDescription() {
        return "Add API key";
    }

    public String getGroup() {
        return "Configuration";
    }

    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        if (!this.checkIsFromAdmin(packet, results::offer)) {
            return;
        }
        ApiKeyItem item = this.module.getApiKeyRepository().getItemInstance();
        item.initFromCommand((Packet)packet);
        if (Command.getFieldValue((Packet)packet, (String)"command-marker") == null) {
            Packet result = packet.commandResult(Command.DataType.form);
            Command.addHiddenField((Packet)result, (String)"command-marker", (String)"command-marker");
            item.addCommandFields(result);
            results.offer(result);
            return;
        }
        Packet result = packet.commandResult(Command.DataType.result);
        Optional<ApiKeyItem> oldItem = Optional.ofNullable(item.getKey()).map(arg_0 -> ((ApiKeyRepository)this.module.getApiKeyRepository()).getItem(arg_0));
        if (oldItem.isPresent()) {
            Command.addTextField((Packet)result, (String)"Error", (String)"The item is already added, you can't add it twice.");
        } else {
            String validateResult = this.module.getApiKeyRepository().validateItem((RepositoryItem)item);
            if (validateResult == null && Optional.ofNullable(item.getKey()).filter(val -> !val.isEmpty()).isPresent()) {
                this.module.getApiKeyRepository().addItem(item);
                Command.addTextField((Packet)result, (String)"Note", (String)"Operation successful.");
            } else {
                Command.addTextField((Packet)result, (String)"Error", (String)"The item did not pass validation checking.");
                Command.addTextField((Packet)result, (String)"Note", (String)"   ");
                Command.addTextField((Packet)result, (String)"Warning", (String)validateResult);
            }
        }
        results.offer(result);
    }
}

