/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.PacketWriter;
import tigase.http.api.HttpServerIfc;
import tigase.http.modules.Module;
import tigase.http.stats.HttpStatsCollector;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="http", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SetupMode})
public class HttpMessageReceiver
extends AbstractMessageReceiver
implements PacketWriter,
RegistrarBean {
    private static final Logger log = Logger.getLogger(HttpMessageReceiver.class.getCanonicalName());
    private static final EnumSet<StanzaType> resultTypes = EnumSet.of(StanzaType.error, StanzaType.result);
    @Inject
    private List<Module> activeModules = new ArrayList<Module>();
    @Inject
    private HttpServerIfc httpServer;
    private Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private ConcurrentHashMap<String, Request> pendingRequest = new ConcurrentHashMap();
    private ScheduledExecutorService scheduler;
    @Inject(nullAllowed=true)
    private List<HttpStatsCollector> statsCollectors = Collections.emptyList();

    public void everyHour() {
        for (Module m : this.modules.values()) {
            m.everyHour();
        }
    }

    public void everyMinute() {
        for (Module m : this.modules.values()) {
            m.everyMinute();
        }
    }

    public void everySecond() {
        for (Module m : this.modules.values()) {
            m.everySecond();
        }
    }

    public void start() {
        this.scheduler = Executors.newScheduledThreadPool(2);
        super.start();
    }

    public void stop() {
        this.scheduler.shutdown();
        super.stop();
    }

    public String getDiscoDescription() {
        return "HTTP server integration module";
    }

    public boolean isSubdomain() {
        return true;
    }

    public void setActiveModules(List<Module> activeModules) {
        ArrayList<Module> toUnregister = new ArrayList<Module>(this.activeModules);
        toUnregister.removeAll(activeModules);
        ArrayList<Module> toRegister = new ArrayList<Module>(activeModules);
        toRegister.removeAll(this.activeModules);
        for (Module module : toUnregister) {
            this.modules.remove(module.getName());
        }
        JID componentJid = JID.jidInstanceNS((String)(String.valueOf(this.getName()) + "." + this.getDefHostName().getDomain()));
        for (Module module : toRegister) {
            module.init(componentJid, this.getName(), this);
            this.modules.put(module.getName(), module);
        }
        this.activeModules = activeModules;
    }

    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid.getLocalpart() == null) {
            return super.getDiscoInfo(node, jid, from);
        }
        Module module = this.modules.get(jid.getLocalpart());
        if (module != null) {
            return module.getDiscoInfo(node, this.isAdmin(from));
        }
        return null;
    }

    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (jid.getDomain().startsWith(String.valueOf(this.getName()) + ".")) {
            if (jid.getLocalpart() != null) {
                Module module = this.modules.get(jid.getLocalpart());
                if (module != null) {
                    return module.getDiscoItems(node, jid, from);
                }
                return Collections.emptyList();
            }
            if (node == null) {
                ArrayList<Element> items = new ArrayList<Element>();
                for (Module module : this.modules.values()) {
                    items.addAll(module.getDiscoItems(node, jid, from));
                }
                List pitems = super.getDiscoItems(node, jid, from);
                if (pitems != null) {
                    items.addAll(pitems);
                }
                return items;
            }
            return super.getDiscoItems(node, jid, from);
        }
        return super.getDiscoItems(node, jid, from);
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.modules.values().forEach(m -> m.getStatistics(this.getName(), list));
        this.statsCollectors.forEach(col -> col.getStatistics(this.getName(), list));
    }

    public void processPacket(Packet packet) {
        Module module;
        boolean handled = false;
        if (resultTypes.contains(packet.getType())) {
            handled = this.processResultPacket(packet);
        }
        if (!handled && packet.getStanzaTo() != null && packet.getStanzaTo().getLocalpart() != null && (module = this.modules.get(packet.getStanzaTo().getLocalpart())) != null) {
            handled = module.processPacket(packet);
        }
        if (!(handled || packet.getElemName() == "iq" && resultTypes.contains(packet.getType()))) {
            try {
                this.addOutPacket(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "packet processing type error", ex);
            }
        }
    }

    public void requestTimedOut(String key) {
        Request request = this.pendingRequest.remove(key);
        if (request == null) {
            return;
        }
        request.callback.onResult(null);
    }

    @Override
    public boolean write(Module module, Packet packet) {
        String id;
        JID from = module.getJid().copyWithoutResource();
        if (packet.getStanzaFrom() == null) {
            packet.initVars(from, packet.getStanzaTo());
        }
        if ((id = packet.getAttributeStaticStr("id")) == null) {
            id = UUID.randomUUID().toString();
            packet.getElement().setAttribute("id", id);
            packet.initVars(packet.getStanzaFrom(), packet.getStanzaTo());
        }
        packet.setPacketFrom(from);
        return this.addOutPacket(packet);
    }

    @Override
    public boolean write(Module module, Packet packet, Integer timeout, PacketWriter.Callback callback) {
        String id;
        String uuid = UUID.randomUUID().toString();
        JID from = this.getComponentId().copyWithResourceNS(uuid);
        if (packet.getStanzaFrom() == null) {
            packet.initVars(from, packet.getStanzaTo());
        }
        if ((id = packet.getAttributeStaticStr("id")) == null) {
            id = UUID.randomUUID().toString();
            packet.getElement().setAttribute("id", id);
            packet.initVars(packet.getStanzaFrom(), packet.getStanzaTo());
        }
        packet.setPacketFrom(from);
        if (packet.getStanzaFrom() != null && !this.isLocalDomainOrComponent(packet.getStanzaFrom().toString())) {
            if (this.isAdmin(packet.getStanzaFrom())) {
                packet.setPermissions(Permissions.ADMIN);
            } else {
                packet.setPermissions(Permissions.AUTH);
            }
        }
        final String key = this.generateKey(uuid, id);
        if (callback != null) {
            if (timeout == null || timeout < 0) {
                timeout = 30;
            }
            Request request = new Request(callback, this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    HttpMessageReceiver.this.requestTimedOut(key);
                }
            }, (long)timeout.intValue(), TimeUnit.SECONDS));
            this.pendingRequest.put(key, request);
        }
        return this.addOutPacket(packet);
    }

    public void register(Kernel kernel) {
    }

    public void unregister(Kernel kernel) {
    }

    private String generateKey(String uuid, String key) {
        return String.valueOf(uuid) + "-" + key;
    }

    private boolean processResultPacket(Packet packet) {
        Request request;
        block3: {
            String id;
            String uuid = packet.getTo().getResource();
            String key = this.generateKey(uuid, id = packet.getAttributeStaticStr("id"));
            request = this.pendingRequest.remove(key);
            if (request != null) {
                request.future.cancel(false);
                try {
                    request.callback.onResult(packet);
                }
                catch (IllegalStateException ex) {
                    if (!log.isLoggable(Level.FINEST)) break block3;
                    log.log(Level.FINEST, "exception while processing response on HTTP request, is HTTP connection closed?", ex);
                }
            }
        }
        return request != null;
    }

    private class Request {
        final PacketWriter.Callback callback;
        final Future future;

        Request(PacketWriter.Callback callback, Future future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

