/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.tls.NamedCurve;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import org.bouncycastle.util.BigIntegers;

public class BcTlsECDomain
implements TlsECDomain {
    protected BcTlsCrypto crypto;
    protected TlsECConfig ecConfig;
    protected ECDomainParameters ecDomain;

    public BcTlsECDomain(BcTlsCrypto bcTlsCrypto, TlsECConfig tlsECConfig) {
        this.crypto = bcTlsCrypto;
        this.ecConfig = tlsECConfig;
        this.ecDomain = this.getParameters(tlsECConfig);
    }

    public byte[] calculateECDHAgreement(ECPublicKeyParameters eCPublicKeyParameters, ECPrivateKeyParameters eCPrivateKeyParameters) {
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init((CipherParameters)eCPrivateKeyParameters);
        BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement((CipherParameters)eCPublicKeyParameters);
        return BigIntegers.asUnsignedByteArray((int)eCDHBasicAgreement.getFieldSize(), (BigInteger)bigInteger);
    }

    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] byArray) throws IOException {
        return this.ecDomain.getCurve().decodePoint(byArray);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] byArray) throws IOException {
        try {
            ECPoint eCPoint = this.decodePoint(byArray);
            return new ECPublicKeyParameters(eCPoint, this.ecDomain);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    public byte[] encodePoint(ECPoint eCPoint) throws IOException {
        return eCPoint.getEncoded(this.ecConfig.getPointCompression());
    }

    public byte[] encodePublicKey(ECPublicKeyParameters eCPublicKeyParameters) throws IOException {
        return this.encodePoint(eCPublicKeyParameters.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.ecDomain, this.crypto.getSecureRandom()));
        return eCKeyPairGenerator.generateKeyPair();
    }

    public BcTlsCrypto getCrypto() {
        return this.crypto;
    }

    public ECDomainParameters getParameters(TlsECConfig tlsECConfig) {
        return this.getParametersForNamedCurve(tlsECConfig.getNamedCurve());
    }

    public ECDomainParameters getParametersForNamedCurve(int n) {
        String string = NamedCurve.getNameOfSpecificCurve(n);
        if (string == null) {
            return null;
        }
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName((String)string);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByName((String)string)) == null) {
            return null;
        }
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }
}

