/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigFieldType;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.IEncryptedNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPlainNotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.apns.APNS;
import tigase.push.apns.APNSUtil;
import tigase.push.apns.ApnsNotification;
import tigase.push.apns.ApnsPayload;
import tigase.push.apns.ApnsService;
import tigase.push.apns.ApnsServiceException;
import tigase.push.modules.AffiliationChangedModule;
import tigase.push.monitor.SSLCertificateExpirationAware;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.Counter;
import tigase.stats.StatisticsList;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="apns-binary-api", parent=PushNotificationsComponent.class, active=false)
public class APNsBinaryApiProvider
implements Initializable,
UnregisterAware,
ConfigurationChangedAware,
IPushProvider,
SSLCertificateExpirationAware,
ComponentStatisticsProvider {
    private static final Logger a = Logger.getLogger(APNsBinaryApiProvider.class.getCanonicalName());
    protected final EventBus eventBus = EventBusFactory.getInstance();
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    @Inject
    private UserRepository userRepository;
    @ConfigField(desc="Password for certificate file", alias="cert-password", type=ConfigFieldType.Password)
    private String certificatePassword;
    @ConfigField(desc="Path to certificate file (.p12)", alias="cert-file")
    private String certificatePath;
    @ConfigField(desc="Certificate in PEM format", alias="cert-base64")
    private String base64certificate;
    @ConfigField(desc="Path to PushKit certificate file (.p12)", alias="pushkit-cert-file")
    private String pushkitCertificatePath;
    @ConfigField(desc="Path to PushKit certificate file (.p12)", alias="pushkit-cert-base64")
    private String base64pushkitCertificate;
    @ConfigField(desc="Provider description")
    private String description = "Push provider for APNs - Binary API";
    @ConfigField(desc="Fallback to sandbox")
    private boolean fallbackToSandbox = false;
    @ConfigField(desc="APNS-Topic", alias="apns-topic")
    private String apnsTopic;
    @ConfigField(desc="Provider name")
    private String name = "apns-binary-api";
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Sandbox")
    private boolean sandbox = false;
    private ApnsService b;
    private ApnsService c;
    private ApnsService d;
    private ApnsService e;
    private final Counter f = new Counter("Number of push notifications sent", Level.FINE);
    private final Counter g = new Counter("Number of failed push notifications", Level.FINE);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void initialize() {
        if (this.eventBus != null) {
            this.eventBus.registerAll((Object)this);
        }
    }

    @Override
    public Optional<Integer> maxPayloadSize() {
        return Optional.of(3072);
    }

    @Override
    public Set<IPushProvider.Feature> supportedFeatures() {
        return Set.of(IPushProvider.Feature.plain, IPushProvider.Feature.encrypted);
    }

    @Override
    public CompletableFuture<String> pushNotification(IPushSettings.IDevice device, INotification notification) {
        String string;
        boolean bl = this.d != null && notification.getType() == INotification.Type.voip && notification.getPriority() == INotification.Priority.high;
        String string2 = string = !bl ? device.getDeviceId() : device.getDeviceSecondId();
        if (string == null) {
            a.log(Level.FINEST, "there is no device (second) id for push notification for account " + notification.getAccount());
            if (bl) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(new ComponentException(Authorization.ITEM_NOT_FOUND, "Unknown device ID"));
        }
        ApnsPayload.Builder builder = this.preparePayload(APNS.newPayload(), notification);
        ApnsNotification.Builder builder2 = APNS.newNotification();
        if (!bl) {
            if (this.apnsTopic != null) {
                builder2.topic(this.apnsTopic);
            }
            switch (notification.getPriority()) {
                case low: {
                    builder2.pushType(ApnsNotification.PushType.background);
                    break;
                }
                case high: {
                    builder.body("New message!").sound("default").mutableContent(1).category("MESSAGE").threadId(notification.getAccount().toString());
                    builder2.pushType(ApnsNotification.PushType.alert);
                }
            }
        } else {
            builder2.pushType(ApnsNotification.PushType.voip);
        }
        ApnsNotification apnsNotification = builder2.deviceId(string).payload(builder.build()).build();
        this.f.inc();
        if (bl) {
            return this.pushNotification(device, apnsNotification, this.d, this.e);
        }
        return this.pushNotification(device, apnsNotification, this.b, this.c);
    }

    @Override
    public Stream<SSLCertificateExpirationAware.Result> getSSLCertificatesValidPeriod() {
        Stream<SSLCertificateExpirationAware.Result> stream = Stream.empty();
        try {
            if (this.base64certificate != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromBase64(this.base64certificate, this.certificatePassword));
            } else if (this.certificatePath != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromFile(this.certificatePath, this.certificatePassword));
            }
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, throwable, () -> "Could not retrieve valid period for Push SSL certificate");
        }
        try {
            if (this.base64pushkitCertificate != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromBase64(this.base64pushkitCertificate, this.certificatePassword));
            } else if (this.pushkitCertificatePath != null) {
                stream = Stream.concat(stream, APNSUtil.getCertificateValidPeriodFromFile(this.pushkitCertificatePath, this.certificatePassword));
            }
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, throwable, () -> "Could not retrieve valid period for PushKit SSL certificate");
        }
        return stream;
    }

    protected CompletableFuture<String> pushNotification(IPushSettings.IDevice device, ApnsNotification apnsNotification, ApnsService service, ApnsService fallbackService) {
        return this.a(service, fallbackService, apnsNotification).whenComplete((string, throwable) -> {
            if (throwable != null && throwable instanceof ApnsServiceException) {
                ApnsServiceException apnsServiceException = (ApnsServiceException)((Object)((Object)throwable));
                switch (apnsServiceException.getErrorType()) {
                    case badDeviceToken: 
                    case deviceTokenNotForTopic: 
                    case unregistred: {
                        this.unregisterDevice(device.getDeviceId());
                        break;
                    }
                }
            }
        });
    }

    private CompletableFuture<String> a(ApnsService apnsService, ApnsNotification apnsNotification) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "sending push notification " + apnsNotification.getId() + " at service " + apnsService);
        }
        return this.a(apnsService, apnsNotification, 1).whenComplete((string, throwable) -> {
            if (throwable == null) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "sent push notification = " + apnsNotification.getId() + " at service = " + apnsService);
                }
            } else if (throwable instanceof CompletionException) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "failed to send push notification = " + apnsNotification.getId() + " at service = " + apnsService + ", error: " + throwable.getCause());
                }
            } else if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "failed to send push notification = " + apnsNotification.getId() + " at service = " + apnsService, (Throwable)throwable);
            }
        });
    }

    private CompletableFuture<String> a(ApnsService apnsService, ApnsNotification apnsNotification, int n) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        try {
            ((CompletableFuture)apnsService.push(apnsNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable2 -> {
                if (n <= 3 && APNsBinaryApiProvider.a(throwable2)) {
                    ((CompletableFuture)this.a(apnsService, apnsNotification, n + 1).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable -> {
                        completableFuture.completeExceptionally((Throwable)throwable);
                        return null;
                    });
                } else {
                    completableFuture.completeExceptionally((Throwable)throwable2);
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            completableFuture.completeExceptionally(throwable);
        }
        return completableFuture;
    }

    private CompletableFuture<String> a(ApnsService apnsService, ApnsService apnsService2, ApnsNotification apnsNotification) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        ((CompletableFuture)this.a(apnsService, apnsNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable2 -> {
            if (apnsService2 != null && APNsBinaryApiProvider.a(throwable2, ApnsService.ErrorType.badDeviceToken)) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "trying to use fallback service " + apnsService2 + " for notification " + apnsNotification.getId());
                }
                ((CompletableFuture)this.a(apnsService2, apnsNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            } else {
                completableFuture.completeExceptionally((Throwable)throwable2);
            }
            return null;
        });
        return completableFuture;
    }

    private static boolean a(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return APNsBinaryApiProvider.a(throwable.getCause());
        }
        if (throwable instanceof IOException) {
            return true;
        }
        if (throwable instanceof ApnsServiceException) {
            return ((ApnsServiceException)((Object)throwable)).getErrorType().shouldRetry();
        }
        return false;
    }

    private static boolean a(Throwable throwable, ApnsService.ErrorType errorType) {
        if (throwable instanceof CompletionException) {
            return APNsBinaryApiProvider.a(throwable.getCause(), errorType);
        }
        if (throwable instanceof ApnsServiceException) {
            return ((ApnsServiceException)((Object)throwable)).isErrorType(errorType);
        }
        return false;
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
        this.a(null);
        this.b(null);
        this.c(null);
        this.d(null);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void certificateChange(APNSCertificateChangedEvent event) {
        try {
            this.reloadAPNSCertificateFromRepository();
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Reloading APNS certificate failed", tigaseDBException);
        }
    }

    public void reloadAPNSCertificateFromRepository() throws TigaseDBException {
        BareJID bareJID = BareJID.bareJIDInstanceNS((String)"push");
        if (!this.userRepository.userExists(bareJID)) {
            this.userRepository.addUser(bareJID);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.base64certificate = this.userRepository.getData(bareJID, this.name, "base64certificate");
        if (this.base64certificate != null) {
            arrayList.add("base64certificate");
        }
        this.base64pushkitCertificate = this.userRepository.getData(bareJID, this.name, "base64pushkitCertificate");
        if (this.base64pushkitCertificate != null) {
            arrayList.add("base64pushkitCertificate");
        }
        if (this.base64certificate != null || this.base64pushkitCertificate != null) {
            this.certificatePassword = this.userRepository.getData(bareJID, this.name, "certificatePassword");
            if (this.certificatePassword != null) {
                arrayList.add("certificatePassword");
            }
        }
        this.beanConfigurationChanged(arrayList);
    }

    public void setAPNSCertificate(String base64certificate, String base64pushkitCertificate, String certificatePassword) throws TigaseDBException {
        Objects.nonNull(base64certificate);
        Objects.nonNull(base64pushkitCertificate);
        Objects.nonNull(certificatePassword);
        this.base64certificate = base64certificate;
        this.base64pushkitCertificate = base64pushkitCertificate;
        this.certificatePassword = certificatePassword;
        this.beanConfigurationChanged(List.of("base64certificate", "base64pushkitCertificate", "certificatePassword"));
        this.a(base64certificate, base64pushkitCertificate, certificatePassword);
        this.eventBus.fire((Object)new APNSCertificateChangedEvent("push", this.name));
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("certificatePath") || changedFields.contains("pushkitCertificatePath") || changedFields.contains("base64certificate") || changedFields.contains("base64pushkitCertificate") || changedFields.contains("certificatePassword") || changedFields.contains("poolSize") || changedFields.contains("fallbackToSandbox") || changedFields.contains("userRepository")) {
            try {
                if (this.certificatePath == null && this.base64certificate == null) {
                    if (this.fallbackToSandbox) {
                        this.b(null);
                    }
                    this.a(null);
                } else {
                    if (this.fallbackToSandbox) {
                        this.b(APNS.newService().withCert(this.certificatePath, this.base64certificate, this.certificatePassword).withAppleDestination(false).build());
                    } else {
                        this.b(null);
                    }
                    this.a(APNS.newService().withCert(this.certificatePath, this.base64certificate, this.certificatePassword).withAppleDestination(!this.sandbox).build());
                }
                if (this.pushkitCertificatePath == null && this.base64pushkitCertificate == null) {
                    if (this.fallbackToSandbox) {
                        this.d(null);
                    }
                    this.c(null);
                } else {
                    if (this.fallbackToSandbox) {
                        this.d(APNS.newService().withCert(this.pushkitCertificatePath, this.base64pushkitCertificate, this.certificatePassword).withAppleDestination(false).build());
                    } else {
                        this.d(null);
                    }
                    this.c(APNS.newService().withCert(this.pushkitCertificatePath, this.base64pushkitCertificate, this.certificatePassword).withAppleDestination(!this.sandbox).build());
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not configure APNs provider!", iOException);
            }
        }
    }

    public void everyHour() {
        this.f.everyHour();
        this.g.everyHour();
    }

    public void everyMinute() {
        this.f.everyMinute();
        this.g.everyMinute();
    }

    public void everySecond() {
        this.f.everySecond();
        this.g.everySecond();
    }

    public void getStatistics(String compName, StatisticsList list) {
        this.f.getStatistics(compName + "/" + this.getName(), list);
        this.g.getStatistics(compName + "/" + this.getName(), list);
    }

    void a(String string, String string2, String string3) throws TigaseDBException {
        BareJID bareJID = BareJID.bareJIDInstanceNS((String)"push");
        if (!this.userRepository.userExists(bareJID)) {
            this.userRepository.addUser(bareJID);
        }
        this.userRepository.setData(bareJID, this.name, "base64certificate", string);
        this.userRepository.setData(bareJID, this.name, "base64pushkitCertificate", string2);
        this.userRepository.setData(bareJID, this.name, "certificatePassword", string3);
    }

    protected ApnsPayload.Builder preparePayload(ApnsPayload.Builder builder, INotification notification) {
        if (notification instanceof IPlainNotification) {
            return this.preparePlainPayload(builder, (IPlainNotification)notification);
        }
        if (notification instanceof IEncryptedNotification) {
            return this.prepareEncryptedPayload(builder, (IEncryptedNotification)notification);
        }
        throw new IllegalArgumentException("Not supported notification class:" + notification.getClass().getCanonicalName());
    }

    protected ApnsPayload.Builder preparePlainPayload(ApnsPayload.Builder builder, IPlainNotification notification) {
        if (notification.getPriority() != INotification.Priority.high) {
            builder.instantDeliveryOrSilentNotification();
        }
        builder.customField("account", notification.getAccount().toString());
        notification.ifMessageCount(l -> builder.customField("unread-messages", l));
        notification.ifLastMessageSender(jID -> builder.customField("sender", jID.getBareJID().toString()));
        notification.ifGroupchatSenderNickname(string -> builder.customField("nickname", string));
        notification.ifLastMessageBody(object -> {
            if (((String)object).length() > 512) {
                object = ((String)object).substring(0, 500) + "...";
            }
            builder.customField("body", object);
        });
        return builder;
    }

    protected ApnsPayload.Builder prepareEncryptedPayload(ApnsPayload.Builder builder, IEncryptedNotification notification) {
        if (notification.getPriority() != INotification.Priority.high) {
            builder.instantDeliveryOrSilentNotification();
        }
        builder.customField("account", notification.getAccount().toString()).customField("encrypted", notification.getEncrypted()).customField("iv", notification.getIV());
        return builder;
    }

    protected void unregisterDevice(String deviceId) {
        try {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "unregistering device " + deviceId + " as it was reported as inactive by APNs");
            }
            Stream<IPushSettings> stream = this.repository.getNodeSettings(this.getName(), deviceId);
            stream.forEach(iPushSettings -> {
                try {
                    IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), this.getName(), deviceId);
                    if (iPushSettings2 != null && (iPushSettings2.getDevices().isEmpty() || iPushSettings2.getVersion() > 0)) {
                        this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings2.getServiceJid(), iPushSettings2.getOwnerJid(), iPushSettings2.getNode(), Affiliation.none);
                    }
                }
                catch (ComponentException componentException) {
                    a.log(Level.FINER, this.getName() + ", failed to unregister device = " + deviceId, componentException);
                }
                catch (RepositoryException repositoryException) {
                    a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
                }
            });
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
        }
    }

    private void a(ApnsService apnsService) {
        ApnsService apnsService2 = this.b;
        this.b = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private void b(ApnsService apnsService) {
        ApnsService apnsService2 = this.c;
        this.c = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private void c(ApnsService apnsService) {
        ApnsService apnsService2 = this.d;
        this.d = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
        try {
            this.reloadAPNSCertificateFromRepository();
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Reloading APNS certificate failed", tigaseDBException);
        }
    }

    private void d(ApnsService apnsService) {
        ApnsService apnsService2 = this.e;
        this.e = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    public static class APNSCertificateChangedEvent
    implements Serializable {
        private String a;
        private String b;

        public APNSCertificateChangedEvent() {
        }

        public APNSCertificateChangedEvent(String componentId, String name) {
            this.a = componentId;
            this.b = name;
        }
    }
}

