/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.pubsub.PubSubComponent;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@ClusterModeRequired(active=false)
@Bean(name="presenceRepository", parent=PubSubComponent.class, active=true)
public class PresenceCollectorRepository {
    protected final ConcurrentMap<BareJID, ServiceEntry> entriesByService = new ConcurrentHashMap<BareJID, ServiceEntry>();
    @ConfigField(desc="Maximum amount of last available user resources kept in cache")
    private int maximumNoOfResources = 20;
    private final Object[] JID_LOCKS = new Object[Runtime.getRuntime().availableProcessors() * 4];

    public PresenceCollectorRepository() {
        for (int i = 0; i < this.JID_LOCKS.length; ++i) {
            this.JID_LOCKS[i] = new Object();
        }
    }

    public String add(BareJID serviceJid, JID jid, String caps) {
        if (jid.getResource() != null) {
            return this.entriesByService.computeIfAbsent(serviceJid, x$0 -> new ServiceEntry((BareJID)x$0)).add(jid, caps);
        }
        return null;
    }

    public Stream<JID> getAllAvailableJids(BareJID serviceJid, Predicate<String> nodesPredicate) {
        ServiceEntry entriesByUser = (ServiceEntry)this.entriesByService.get(serviceJid);
        if (entriesByUser == null) {
            return Stream.empty();
        }
        Stream<Object> resultStream = entriesByUser.userEntriesStream().flatMap(userEntry -> userEntry.userResourceEntriesStream());
        if (nodesPredicate != null) {
            resultStream = resultStream.filter(entry -> entry.containsCapsNode(nodesPredicate));
        }
        return resultStream.map(UserResourceEntry::getJid);
    }

    public List<JID> getAllAvailableResources(BareJID serviceJid, BareJID bareJid) {
        ServiceEntry entriesByUser = (ServiceEntry)this.entriesByService.get(serviceJid);
        if (entriesByUser == null) {
            return Collections.emptyList();
        }
        UserEntry values = entriesByUser.get(bareJid);
        if (values == null) {
            return Collections.emptyList();
        }
        return values.userResourceEntriesStream().map(UserResourceEntry::getJid).collect(Collectors.toList());
    }

    public boolean isAvailable(BareJID serviceJid, BareJID bareJid) {
        ServiceEntry entriesByUser = (ServiceEntry)this.entriesByService.get(serviceJid);
        if (entriesByUser == null) {
            return false;
        }
        UserEntry resources = entriesByUser.get(bareJid);
        return resources != null && resources.size() > 0;
    }

    public boolean isAvailable(BareJID serviceJid, JID jid) {
        ServiceEntry entriesByUser = (ServiceEntry)this.entriesByService.get(serviceJid);
        if (entriesByUser == null) {
            return false;
        }
        UserEntry resources = entriesByUser.get(jid.getBareJID());
        if (resources == null || resources.size() == 0) {
            return false;
        }
        return resources.getResources().contains(jid.getResource());
    }

    public boolean remove(BareJID serviceJid, JID jid) {
        ServiceEntry entriesByUser = (ServiceEntry)this.entriesByService.get(serviceJid);
        if (entriesByUser == null) {
            return false;
        }
        return entriesByUser.remove(jid);
    }

    public Collection<ServiceEntry> getServiceEntries() {
        return this.entriesByService.values();
    }

    public Stream<UserResourceEntry> userResourceEntryStream() {
        return this.entriesByService.values().stream().flatMap(ServiceEntry::userEntriesStream).flatMap(UserEntry::userResourceEntriesStream);
    }

    public Stream<UserResourceEntry> expiredUserResourceEntriesStream(long expirationTimestamp) {
        return this.userResourceEntryStream().filter(userResourceEntry -> userResourceEntry.isOlderThan(expirationTimestamp));
    }

    public class UserResourceEntry {
        private final UserEntry entries;
        private final String resource;
        private final String caps;
        private long lastSeen = System.currentTimeMillis();

        public UserResourceEntry(UserEntry entries, String resource, String caps) {
            this.entries = entries;
            this.resource = resource;
            this.caps = caps;
        }

        public BareJID getServiceJid() {
            return this.entries.getServiceJid();
        }

        public JID getJid() {
            return JID.jidInstanceNS((BareJID)this.entries.getJid(), (String)this.resource);
        }

        public String getResource() {
            return this.resource;
        }

        public boolean containsCapsNode(Predicate<String> predicate) {
            return this.caps != null && predicate.test(this.caps);
        }

        public String getCaps() {
            return this.caps;
        }

        public long getLastSeen() {
            return this.lastSeen;
        }

        protected boolean matches(String resource) {
            if (resource == null) {
                return this.resource == null;
            }
            return resource.equals(this.resource);
        }

        public boolean isOlderThan(long timestamp) {
            return this.lastSeen < timestamp;
        }

        public void markAsSeen() {
            this.lastSeen = System.currentTimeMillis();
            this.entries.markAsSeen(this);
        }
    }

    public class UserEntry {
        private final BareJID serviceJid;
        private final BareJID jid;
        private final CopyOnWriteArrayList<UserResourceEntry> entries = new CopyOnWriteArrayList();

        public UserEntry(BareJID serviceJid, BareJID jid) {
            this.serviceJid = serviceJid;
            this.jid = jid;
        }

        public BareJID getJid() {
            return this.jid;
        }

        public BareJID getServiceJid() {
            return this.serviceJid;
        }

        public synchronized String add(String resource, String caps) {
            String oldCaps = null;
            for (int i = 0; i < this.entries.size(); ++i) {
                UserResourceEntry e = this.entries.get(i);
                if (!e.matches(resource)) continue;
                oldCaps = this.entries.remove((int)i).caps;
                break;
            }
            while (this.entries.size() >= PresenceCollectorRepository.this.maximumNoOfResources) {
                this.entries.remove(0);
            }
            this.entries.add(new UserResourceEntry(this, resource, caps == null ? null : caps.intern()));
            return oldCaps;
        }

        public synchronized boolean remove(String resource) {
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get(i).getResource().equals(resource)) continue;
                this.entries.remove(i);
                return true;
            }
            return false;
        }

        public synchronized void markAsSeen(UserResourceEntry entry) {
            this.remove(entry.resource);
            this.entries.add(entry);
        }

        public List<String> getResources() {
            ArrayList<String> result = new ArrayList<String>(this.entries.size());
            for (UserResourceEntry e : this.entries) {
                result.add(e.resource);
            }
            return result;
        }

        public <T> List<T> mapEntries(Function<UserResourceEntry, T> function, Predicate<UserResourceEntry> filter) {
            ArrayList<T> result = new ArrayList<T>();
            for (UserResourceEntry e : this.entries) {
                if (!filter.test(e)) continue;
                result.add(function.apply(e));
            }
            return result;
        }

        public Stream<UserResourceEntry> getEntriesOlderThen(long timestamp) {
            return this.entries.stream().filter(e -> e.isOlderThan(timestamp));
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public int size() {
            return this.entries.size();
        }

        public Stream<UserResourceEntry> userResourceEntriesStream() {
            return this.entries.stream();
        }
    }

    public class ServiceEntry {
        private final BareJID serviceJid;
        private final ConcurrentHashMap<BareJID, UserEntry> usersEntries = new ConcurrentHashMap();

        public ServiceEntry(BareJID serviceJid) {
            this.serviceJid = serviceJid;
        }

        public BareJID getServiceJid() {
            return this.serviceJid;
        }

        public String add(JID jid, String caps) {
            return this.synchronizeOnUserJID(jid.getBareJID(), () -> this.usersEntries.computeIfAbsent(jid.getBareJID(), k -> new UserEntry(this.serviceJid, (BareJID)k)).add(jid.getResource(), caps));
        }

        public boolean remove(JID jid) {
            return this.synchronizeOnUserJID(jid.getBareJID(), () -> {
                UserEntry entries = this.usersEntries.get(jid.getBareJID());
                if (entries == null) {
                    return false;
                }
                if (jid.getResource() == null) {
                    boolean result = !entries.isEmpty();
                    this.usersEntries.clear();
                    return result;
                }
                boolean result = entries.remove(jid.getResource());
                if (entries.isEmpty()) {
                    this.usersEntries.remove(jid.getBareJID());
                }
                return result;
            });
        }

        public UserEntry get(BareJID jid) {
            return this.usersEntries.get(jid);
        }

        public Collection<UserEntry> getUserEntries() {
            return this.usersEntries.values();
        }

        public Stream<UserEntry> userEntriesStream() {
            return this.usersEntries.values().stream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> T synchronizeOnUserJID(BareJID jid, Supplier<T> run) {
            Object object = PresenceCollectorRepository.this.JID_LOCKS[Math.abs(jid.hashCode()) % PresenceCollectorRepository.this.JID_LOCKS.length];
            synchronized (object) {
                return run.get();
            }
        }
    }
}

