/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dnswebservice;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.modules.dnswebservice.DnsItem;
import tigase.http.modules.dnswebservice.DnsResolver;
import tigase.http.modules.dnswebservice.formatters.JsonUtilV1;
import tigase.http.modules.dnswebservice.formatters.JsonUtilV2;

public class JsonServlet
extends HttpServlet {
    public String getServletInfo() {
        return "Short description";
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int version;
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String domain = request.getParameter("domain");
        String callback = request.getParameter("callback");
        int n = version = request.getParameter("version") == null ? 1 : Integer.parseInt(request.getParameter("version"));
        if (version > 2) {
            response.sendError(400);
        }
        try {
            DnsItem item = DnsResolver.get(domain);
            if (item == null) {
                response.sendError(404);
            } else {
                StringBuilder sb = new StringBuilder(1000);
                if (callback != null) {
                    sb.append(callback);
                    sb.append("(");
                }
                switch (version) {
                    case 2: {
                        JsonUtilV2.format(sb, item);
                        break;
                    }
                    default: {
                        JsonUtilV1.format(sb, item);
                    }
                }
                if (callback != null) {
                    sb.append(")");
                }
                out.append(sb.toString());
            }
        }
        finally {
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

